/* ------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------------------------*/

/* bridge.h
 *
 *
 *
 * system: SA1200
 * subsystem: Bridge
 * author: Rajendra Shukla 02/26/99
 * revisions:
 * $History: brm.h $
 * 
 * *****************  Version 4  *****************
 * User: Drjohns1     Date: 2/08/00    Time: 10:31a
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 3  *****************
 * User: Drjohns1     Date: 1/24/00    Time: 10:21a
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 19  *****************
 * User: Dhooper      Date: 5/14/99    Time: 9:45a
 * Updated in $/BL5_Plus/Include
 * move stuff from bridge.h to br_config.h
 * 
 * *****************  Version 18  *****************
 * User: Dhooper      Date: 5/14/99    Time: 9:24a
 * Updated in $/BL5_Plus/SA1_CoreLibs/bridge
 * use SRAM, SDRAM_Attach, inline Br_Init
 * 
 * *****************  Version 17  *****************
 * User: Dhooper      Date: 4/15/99    Time: 3:31p
 * Updated in $/development/bridge
 * svlib call from console interface
 * 
 * *****************  Version 16  *****************
 * User: Rshukla1     Date: 4/13/99    Time: 9:35p
 * Updated in $/development/bridge
 * 
 * *****************  Version 15  *****************
 * User: Rshukla1     Date: 4/12/99    Time: 5:27p
 * Updated in $/development/bridge
 * 
 * *****************  Version 14  *****************
 * User: Rshukla1     Date: 4/09/99    Time: 9:49a
 * Updated in $/development/bridge
 * 
 * *****************  Version 12  *****************
 * User: Rshukla1     Date: 4/08/99    Time: 9:46a
 * Updated in $/development/bridge
 * 
 * *****************  Version 11  *****************
 * User: Rshukla1     Date: 4/06/99    Time: 9:06a
 * Updated in $/development/bridge
 * 
 * *****************  Version 10  *****************
 * User: Rshukla1     Date: 4/02/99    Time: 10:06a
 * Updated in $/development/bridge
 * Library added
 * 
 * *****************  Version 9  *****************
 * User: Rshukla1     Date: 4/01/99    Time: 1:15p
 * Updated in $/development/bridge
 * 
 * *****************  Version 8  *****************
 * User: Qabuild      Date: 3/24/99    Time: 9:04a
 * Updated in $/development/bridge
 * Updated bridge project again.  Wrong path in links area for debug and
 * release of bridge.exe
 * 
 * *****************  Version 7  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:16p
 * Updated in $/development/bridge
 * update COPYRIGHT
 * 
 * *****************  Version 3  *****************
 * User: Rshukla1     Date: 3/05/99    Time: 3:01p
 * Updated in $/development/bridge
 * 
 * *****************  Version 2  *****************
 * User: Rshukla1     Date: 3/03/99    Time: 6:43p
 * Updated in $/development/bridge
 * yet not stable. Do not try to run
 * 
 * *****************  Version 1  *****************
 * User: Rshukla1     Date: 3/03/99    Time: 9:44a
 * Created in $/development/bridge
 * initial bridge managment files
 * 
 * 
 */

#ifndef BRIDGE_H
#define BRIDGE_H


//-----------------MACROS------------------------------

// All these pointer can be found in mem_map.h
/* MAIN ROUTING DATA STRUCTURES  */

struct Br_Table_S {
/* 
**  An array of 64K 32bit entries loaded in SRAM.
**       sram_l1_addr_hash_base:			2**16 (10000 hex) longword entries  256KB
**       The level 1 hash table (shared DA/SA).  Indexed by hash result<15:0>.         
**				<30>	- lock bit		entry not valid (update from core in progress)
**              <31>	- collision bit       	
**       	    if <31> = 0 then no collision - use the entry to look up forwarding table
**	                <23:16> - timeSinceLastSeen  ?? I'm not handling this now
**					<15:0>  - forwarding table index 
**              <31> = 1 collision - use the entry to look up level 2 hash table
**					<30:28> MBZ
**					<27:16> L2_index - index into L2 hash table
**					<15:5>  L2_bit_mask - 11 bits
**					<4:0>   L2_shift - hash table index shift left amount - 5 bits
*/
    unsigned int L1;  //sram; Level one hash table 
/*  
** L2 hash table. Extracted from one of the set of 11 bits from the hash table.
** There could be number of such tables and total number of tables can be configured
** as a define in config.h. by parameter NUM_OF_L2
** 
**       sram_l2_addr_hash_base:			size is determined by software. ~64KB  
**       The level 2 hash table (shared DA/SA).  Indexed by (l2_index<<l2_shift) 
**                     OR (hash result<48:16> and l2_bit_mask).     
**       Can resolve 2 - 256 collisions.
**				<30>	- lock bit		entry not valid (update from core in progress)
**              <31>	- collision bit       	
**       	    if  <31> = 0 then no collision - use the entry to look up forwarding table
**	                <23:16> - timeSinceLastSeen  ?? I'm not handling this now
**				    <15:0>  - forwarding table index 
**              <31> = 1 collision - use the entry to look up a further level 2 hash table entry
**					<30:28> MBZ
**					<27:16> L2_index - index into L2 hash table
**					<15:5>  L2_bit_mask - 11 bits
**					<4:0>   L2_shift - hash table index shift left amount - 5 bits
*/
    unsigned int L2;  //sram; Level two hash table
/*
** SRAM port state lookup
**       at sram[SRAM_PORT_STATE_BASE + port_num] #ports
**         
**	        longword 0
**              <31:4>	- possible trap info
**				<3:0>	- port state
**					0 = disabled
**					1 = listening
**					2 = learning
**					3 = blocking
**					forwarding if all the bits are zero
**	        longword 1
**                  not used: Possible timer values
**	        longword 2
**                  not used: pointer to table for chanel mapping
**	        longword 3
**                  not used
**
*/
    unsigned int port;  //sram; protocol hash table
/*
**       br_protocol lookup:	sram[br_protocol_base + protocol_len<15:5>]	
**                              2K longword entries
**	  result:	32 entries selected by protocol_len<4:0>
**
**			 	1 = Q to core (BPDU)
**				0 = handle by microcode. forward/filter decision   
*/
    unsigned int proto;

    // VTAG filter table not used at present but may be used later
    unsigned int filter;  //sram; vtag/filter table
/*
**      sdram_fwd_base_const:
**       (shared DA/SA)
**      longword0:	       
**               <31:16> - possible Channel Number
**               <15>    - possible ISS
**               <14:6>  - not used at this time
**               <5:0>   - port Number
**
**      longword1:
**                  not used at this time 
**      longword2: - hash remainder - 32 bits
**      longword3: - not used
**
*/
    unsigned int frwd;  //sdram; forwarding entry table
    unsigned int next_frwd; // next free entry in forwarding table
};

// L2 memory is aloocated in chunks defined by the BR_L2_CHUNK_SIZE
struct Br_L2_Info_S{
    unsigned int next_free;
    unsigned int chunk_remain;
};

struct Br_MAC_Addr{
    unsigned int B0123;   // little endian: byte 4 3 2 and 1
    unsigned short B45;   // byte 6 and 5
};

// defines the bridge identifies which includes an protocol 
// identifier/priority/channel number and the MAC addrress.

struct Br_Id {
     struct Br_MAC_Addr MAC_Addr;
     unsigned short proto_id;
};


extern Br_Table_S Br_Table;
extern Br_L2_Info_S Br_L2_Info;

// Function declaration
#if defined(__cplusplus)
extern "C"
{
#endif

extern int Br_Init(); // initializes various tables and routines and 

extern int Br_RtDel(); // will be implemented later

extern int Br_RtLookup(unsigned int, unsigned short, int);

extern int Br_SvInit();

extern int Br_HashEncode(struct Br_MAC_Addr *);  // hash encoding

extern int Br_LookupL1(unsigned int, unsigned int *); 

extern int Br_LookupL2(unsigned int, unsigned int *); //

// Add L2 level tables
extern unsigned int Br_RtAddL2(unsigned int, unsigned int, unsigned int, unsigned int *);

extern int Br_RtAdd(unsigned int, unsigned short, int);

extern int BR_Allocate_New_L2_Chunk(); 

extern int br_model_initialize();

#if defined(__cplusplus)
}
#endif

//--------------------------end of file---------------------------------------------
#endif /* BRIDGE_H */
