/* Xact_API.H
 *
 *
 * ------------------------------------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: Xact_IO
 * author: Lai-Wah Hui 1/15/98
 * revisions:
 * $History: Xact_API.h $
 * 
 * *****************  Version 24  *****************
 * User: Lhui         Date: 6/15/99    Time: 11:35a
 * Updated in $/dev_1200/Include
 * Add support for XACTIO
 * 
 * *****************  Version 23  *****************
 * User: Drjohns1     Date: 6/10/99    Time: 4:49p
 * Updated in $/dev_1200/Include
 * Updated for new iostyle -- incomplete
 * 
 * *****************  Version 21  *****************
 * User: Hqianx       Date: 4/27/99    Time: 3:40p
 * Updated in $/dev_1200/SA1_CoreLibs/Xact_io
 * Removed UENGINE_DRIVER.
 * 
 * *****************  Version 19  *****************
 * User: Drjohns1     Date: 4/16/99    Time: 1:39p
 * Updated in $/development/tool/Xact_io
 * Fixed XactIoReadIREG and created XactIoWriteIREG
 * 
 * *****************  Version 18  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:18p
 * Updated in $/development/tool/Xact_io
 * update COPYRIGHT
 * 
 * *****************  Version 17  *****************
 * User: Dhooper      Date: 3/08/99    Time: 11:17a
 * Updated in $/development/tool/Xact_io
 * add ZeroBuffer and SDZeroBuffer
 * 
 * *****************  Version 16  *****************
 * User: Drjohns1     Date: 2/12/99    Time: 5:52p
 * Updated in $/development/tool/Xact_io
 * Updated for multi-chip/auto_ambio related changes
 * 
 * *****************  Version 15  *****************
 * User: Lhui         Date: 11/24/98   Time: 5:49p
 * Updated in $/development/tool/Xact_io
 * Provide support for the multiple chip feature supported in the
 * Transactor.
 * 
 * *****************  Version 14  *****************
 * User: Drjohns1     Date: 8/06/98    Time: 11:39a
 * Updated in $/base_level3/tool/Xact_io
 * Added XactIo_ReadBuffer
 * 
 * *****************  Version 13  *****************
 * User: Dhooper      Date: 7/15/98    Time: 5:30p
 * Updated in $/base_level3/tool/Xact_io
 * Add XactIo_WriteBuffer and XactIo_InitSDBuffer
 * 
 * *****************  Version 12  *****************
 * User: Lhui         Date: 6/04/98    Time: 2:38p
 * Updated in $/base_level3/tool/Xact_io
 * modify XactIoWrite and XactIoRead to support VSIG
 * 
 * *****************  Version 11  *****************
 * User: Lhui         Date: 6/01/98    Time: 10:15a
 * Updated in $/base_level3/tool/Xact_io
 * Remove safexact.h
 * 
 * *****************  Version 10  *****************
 * User: Lhui         Date: 5/20/98    Time: 6:30p
 * Updated in $/base_level2/tool/Xact_io
 * Replace Digital copyright with Intel copyright statement
 * 
 * *****************  Version 9  *****************
 * User: Lhui         Date: 3/09/98    Time: 12:01p
 * Updated in $/base_level1/tool/Xact_io
 * Added versioning
 * 
 * *****************  Version 8  *****************
 * User: C-hqian      Date: 3/04/98    Time: 2:32p
 * Updated in $/base_level1/tool/Xact_io
 * Added function: int XactIoReadIREG(unsigned int* value);
 * 
 * *****************  Version 7  *****************
 * User: Lhui         Date: 2/05/98    Time: 3:06p
 * Updated in $/base_level1/tool/Xact_io
 * Add support for array read/write
 * 
 * *****************  Version 6  *****************
 * User: C-hqian      Date: 1/26/98    Time: 2:34p
 * Updated in $/base_level1/tool/Xact_io
 * Added functions:
 *     int XactIoSignalDone(void);
 *     int XactIoDefineCallBackFunction(PFI ptrCallBackFunction);
 *     void XactIoDump(int firstMailBox, int numberOfMailBox);
 * 
 * *****************  Version 5  *****************
 * User: Lhui         Date: 1/20/98    Time: 3:33p
 * Updated in $/base_level1/tool/Xact_io
 * Fixed bug with SDRAM 64 bit read/write
 * 
 * *****************  Version 4  *****************
 * User: Lhui         Date: 1/16/98    Time: 8:38p
 * Updated in $/base_level1/tool/VxWork-XactAPI
 * Updated prototype
 *
 *---------------------------------------------------------------------
 */ 
#ifndef Xact_API_H
#define Xact_API_H 


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "core_io.h"


#define XACT_SUCCESS 1
#define XACT_ERROR   0 
#define MAX_MENGINE 6

enum eStorge {SRAM=0, SDRAM, U_SIGNAL ,USTORE};
typedef int (*PFI)(int, void*);
#define NULLChip ""
#if defined(__cplusplus)
extern "C"
{
#endif

void TempMain();
#ifdef MULTI_CHIP
int XactIoInit(char *ChipName);
int XactIoRead(char *ChipName, int storage, char MEngineMask, int from, unsigned int *element);
int XactIoWrite(char *ChipName,int storage, char MEngineMask, unsigned int element, int to);
int XactIoLoad(char *ChipName, char *listfile, char MEngineMask); 
int XactFastRead(char *ChipName, int storage,int from,unsigned int *element);
int XactFastWrite(char *ChipName,int  storage,	unsigned int element, int to);
int XactIo_ReadBuffer(char *ChipName, int storage, unsigned int *inptr, unsigned int  size, unsigned int baseaddr);
int XactIo_WriteBuffer(char *ChipName, int storage, unsigned int *inptr, unsigned int  size, unsigned int baseaddr);
int XactIo_ZeroBuffer(char *ChipName, int storage, unsigned int  size, unsigned int baseaddr);
int XactIo_InitSDBuffer(char *ChipName, unsigned int *inptr, unsigned int  size, unsigned int baseaddr);
int XactIo_ZeroSDBuffer(char *ChipName, unsigned int  size, unsigned int baseaddr);

int XactIoSignalDone(char *ChipName);
int XactIoDefineCallBackFunction(char *ChipName, PFI ptrCallBackFunction);
int XactIoReadIREG(char *ChipName, unsigned int* value);
int XactIoWriteIREG(char *ChipName, unsigned int value);
void XactIoDump(char *ChipName, int firstMailBox, int numberOfMailBox);

#else
static char *ChipName = "";
int XactIoInit();
int XactIoRead(int storage, char MEngineMask, int from, unsigned int *element);
int XactIoWrite(int storage, char MEngineMask, unsigned int element, int to);
int XactIoLoad(char *listfile, char MEngineMask); 
int XactFastRead(int storage,int from,unsigned int *element);
int XactFastWrite(int  storage,	unsigned int element, int to);
int XactIo_ReadBuffer(int storage, unsigned int *inptr, unsigned int  size, unsigned int baseaddr);
int XactIo_WriteBuffer(int storage, unsigned int *inptr, unsigned int  size, unsigned int baseaddr);
int XactIo_ZeroBuffer(int storage, unsigned int  size, unsigned int baseaddr);
int XactIo_InitSDBuffer(unsigned int *inptr, unsigned int  size, unsigned int baseaddr);
int XactIo_ZeroSDBuffer(unsigned int  size, unsigned int baseaddr);

int XactIoSignalDone(void);
int XactIoDefineCallBackFunction(PFI ptrCallBackFunction);
int XactIoReadIREG(unsigned int* value);
int XactIoWriteIREG(unsigned int value);
void XactIoDump(int firstMailBox, int numberOfMailBox);
#endif
int XACTIO_IRQ_Connect(char *chipname, SA1200_INTS vector, ISR_FUNC isr, int param);
int XACTIO_IRQ_Enable(char *chipname, SA1200_INTS vector);
int XACTIO_IRQ_Disable(char *chipname, SA1200_INTS vector);
int XACTIO_intLock(char *chipname);
int XACTIO_intUnlock(char *chipname, int prev_val);
int XACTIO_Write32(char *chipname,unsigned intaddr, unsigned intval);
int XACTIO_Read32(char *chipname, unsigned intaddr, unsigned int *val);

#if defined(__cplusplus)
}
#endif


#endif  //Xact_API_H
