/* ts.h
 * Thread utility
 *
 * ------------------------------------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Common
 *  author: sk/drj Feb 27, 98  Initial version
 *  revisions:
 *  $History: TS.h $
 * 
 * *****************  Version 22  *****************
 * User: Dmwhite      Date: 4/05/00    Time: 2:54p
 * Updated in $/dev_1200/Include
 * no more  U_COS macro, changed to (OS==UCOS)
 * 
 * *****************  Version 19  *****************
 * User: Drjohns1     Date: 8/06/99    Time: 4:36p
 * Updated in $/dev_1200/Include
 * Updated Sem_Wait
 * 
 * *****************  Version 17  *****************
 * User: Lhui         Date: 7/13/99    Time: 12:50p
 * Updated in $/Beta_1/Include
 * Change UCOS to U_COS to avoid the conflict with UCOS=2 which is defined
 * in ostype.h
 * 
 * *****************  Version 15  *****************
 * User: Skornfel     Date: 3/25/99    Time: 7:41p
 * Updated in $/development/tool/common
 * changed Thread constructor signature for UCOS
 * 
 * *****************  Version 13  *****************
 * User: Skornfel     Date: 3/03/99    Time: 2:25p
 * Updated in $/development/tool/common
 * UCOS added & tested
 * 
 * *****************  Version 12  *****************
 * User: Drjohns1     Date: 2/16/99    Time: 11:54a
 * Updated in $/development/tool/common
 * Updated for auto_ambio & multi-chip related changes.
 * 
 * *****************  Version 11  *****************
 * User: Lhui         Date: 11/24/98   Time: 5:54p
 * Updated in $/development/tool/common
 * Add a Thread constructor with an input parameter.
 * 
 * *****************  Version 10  *****************
 * User: Drjohns1     Date: 6/17/98    Time: 2:48p
 * Updated in $/base_level3/tool/common
 * Linux/GNU port -- .changed to used ../common/thread.* and
 * ../common/sem.*
 * 
 * *****************  Version 9  *****************
 * User: Lhui         Date: 5/20/98    Time: 6:31p
 * Updated in $/base_level2/tool/common
 * Replace Digital copyright with Intel copyright statement
 */ 

#ifndef THREAD_SIGNAL
#define THREAD_SIGNAL

#include "sem.h"
#include "thread.h"
#include "ostype.h"
#ifdef __cplusplus

class Semaphore{

public:
	Semaphore ()         { SemaphoreHandle = Sem_Init(0);};
	Semaphore (int state){ SemaphoreHandle = Sem_Init(state);};

	~Semaphore(){Status = Sem_Destroy(SemaphoreHandle);};
	
	inline void
	Take(){
		Status = Sem_Wait(SemaphoreHandle, SEM_WAITFOREVER);
	};

	inline void
	Give(){
		Status =  Sem_Post(SemaphoreHandle);
	};

private:
	sem_T SemaphoreHandle;
	unsigned int Status;
	
};


class Thread{

public:

#if (OS==UCOS)
	Thread (void (*runfunction)()/*(void*)*/, int pr){ RunFunction = runfunction; m_arg = NULL; priority=pr;Run();};
	Thread (void (*runfunction)()/*(void*)*/, int pr, void *arg){ RunFunction = runfunction; m_arg = arg; priority=pr; Run();};
#else
	Thread (void (*runfunction)()){ RunFunction = runfunction; m_arg = NULL; Run();};
	Thread (void (*runfunction)(), void *arg){ RunFunction = runfunction; m_arg = arg; Run();};
#endif
	~Thread(){Thread_Cancel(ThreadHandle);};

	inline void
	Run(){
#if (OS==UCOS)
		ThreadHandle = Thread_Create (priority, (threadFunc_T) RunFunction , m_arg);
#else
		ThreadHandle = Thread_Create(MID_PRIORITY, (threadFunc_T) RunFunction, m_arg);
#endif
	};

        thread_T GetThreadHandle() const {return ThreadHandle;};

private:
	thread_T ThreadHandle;
	void *m_arg;
#if (OS==UCOS)
	int priority;
	void (*RunFunction)();/*(void *);*/
#else
	void (*RunFunction)();
#endif
};
#endif

#endif //THREAD_SIGNAL
