//
//	cbswitching Application
//	Host application header file
//

// ///////////////////////////////////////////////////////////// 
//	Binding paths for all ACEs, System ACEs and ACE Targets
// /////////////////////////////////////////////////////////////
#define FROMPASS_Nic1   "/nbhwpe0/FromInterface:nbhwpe0A/Interface/pass"
#define FROMPASS_Nic2   "/nbhwpe0/FromInterface:nbhwpe0B/Interface/pass"
#define TO_Nic1         "/nbhwpe0/ToInterface:nbhwpe0A/Interface"
#define TO_Nic2         "/nbhwpe0/ToInterface:nbhwpe0B/Interface"

#define TO_Stack1       "/nbhwpe0/ToStack:nbhwpe0A/Stack"
#define TO_Stack2       "/nbhwpe0/ToStack:nbhwpe0B/Stack"
#define FROMPASS_Stack1 "/nbhwpe0/FromStack:nbhwpe0A/Stack/pass"
#define FROMPASS_Stack2 "/nbhwpe0/FromStack:nbhwpe0B/Stack/pass"

// /////////////////////////////////////////////////////////////
//	Bindings for defined ACES
// /////////////////////////////////////////////////////////////
#define	TO_cbswitching       "/CcbswitchingAppl/CcbswitchingAceGroup/Ccbswitching"
#define	FROMPASS_cbswitching "/CcbswitchingAppl/CcbswitchingAceGroup/Ccbswitching/pass"	
#define	FROMDROP_cbswitching "/CcbswitchingAppl/CcbswitchingAceGroup/Ccbswitching/drop"	
#define TARGETB_cbswitching  "/CcbswitchingAppl/CcbswitchingAceGroup/Ccbswitching/port_B"



class CcbswitchingTargetMgr:public TargetManager {
public:
	CcbswitchingTargetMgr(NBAppl* appl,AceGroup* acegroup,AceManager* acemgr,char *name);
	~CcbswitchingTargetMgr();

};



// /////////////////////////////////////////////////////////////
//	CcbswitchingMgr class definition
//  
//  Note: This ACE allows use of the string search engine
//
// /////////////////////////////////////////////////////////////
class CcbswitchingMgr:public AceManager {
public:
   CcbswitchingMgr(NBAppl* appl, AceGroup* acegroup, char* name);
   ~CcbswitchingMgr();
	CcbswitchingTargetMgr* port_B_manager;

};



// /////////////////////////////////////////////////////////////
//  CcbswitchingAceGroup class definition
// /////////////////////////////////////////////////////////////
class CcbswitchingAceGroup: public AceGroup {
public:
   CcbswitchingAceGroup(NBAppl* appl, NBFactory* aceFactory, char* name);
   ~CcbswitchingAceGroup();
   /*
      Add additional ACE Manager pointers here if you wish to use more
      than one instantiation of a particular ACE.  The Wizard
      only creates one instantiate of each ACE and ACE Manager.
   */
	CcbswitchingMgr*	pcbswitchingMgr;
};


// /////////////////////////////////////////////////////////////
// CcbswitchingAppl class definition
// /////////////////////////////////////////////////////////////
class CcbswitchingAppl:public NBAppl {
public:
   CcbswitchingAppl(void);
	~CcbswitchingAppl();
  	CcbswitchingAceGroup *pcbswitchingAceGrp;

   int  nRunAppl;
};


