//
//   Copyright (c) 1998 NetBoost Corporation.  All Rights Reserved.  
//   Except as expressly authorized by NetBoost Corporation in writing,
//   reproduction of any portion or element of this computer program, 
//   including without limitation, any portion of any text, sound, image, 
//   data or screen, is strictly prohibited and is a violation of Federal law.
//

// $Header: /Fiji/documents/demos/LoopApp/source/loopncl.ncl 3     6/23/00 2:27p Release $


#include "NBTcpip.ncl"


predicate isTCPclient{
tcp && (ip.src == 0x14000002) && (tcp.dport == 80)
}

predicate isTCPbackend{
tcp && (ip.src == 0xa000002)
}

predicate isSYNTCP {
 tcp.flags ==0x02
}

predicate isSYNACKTCP {
tcp.flags==0x12
}

//ack and push packet (lynx generate packets with push flag on)
predicate isACKTCP{
 tcp.flags ==0x18
}


predicate isACK10TCP{
tcp.flags ==0x11 || tcp.flags==0x10  || tcp.flags ==0x04 || tcp.flags== 0x14 || tcp.flags==0x19
}

//RULES FOR CLIENT-FRONTEND COMMUNICATION

//ACK where flag = 0x18 packets grabbed should be forwarded to backends
rule    existentTCPsess2 {  isTCPclient  && isACKTCP } {action_exist_tcpsession_ack()}


//SYN packets grabbed. Should create a TCPSession object and insert a Set element
rule	newTCPsess	{ isTCPclient && isSYNTCP }  { action_new_tcpsession_syn()}


//RULES FOR FRONTEND-BACKEND COMMUNICATION

//catch SYN+ACK response from backend
rule    existentTCPsess4 { isTCPbackend && isSYNACKTCP  } {action_exist_tcpsession_synack_backend()}


//THE LAST RULE GRABS ANY 0X10 ACK PKT
//ACK where flag = 0x10
rule    existentTCPsess2_1 { isTCPclient  && isACK10TCP } {action_exist_tcpsession_ack10()}


//DROP PACKETS THAT DO NOT FIT IN RULES

rule droprest {1} {action_drop()}
