//
//   Copyright (c) 1998 NetBoost Corporation.  All Rights Reserved.  
//   Except as expressly authorized by NetBoost Corporation in writing,
//   reproduction of any portion or element of this computer program, 
//   including without limitation, any portion of any text, sound, image, 
//   data or screen, is strictly prohibited and is a violation of Federal law.
//

#include "NBTcpip.ncl"


//set and searchs
set ethernetset <1> { 
  size_hint { 900 } 
} 

search ethernetset.tcpsession ( tcp.sport ) 
{ 
  requires {tcp} 
} 


predicate existTCPsession {ethernetset.tcpsession}


predicate isTCPclient{
tcp && ((ip.src == 0x14000002) ||(ip.src == 0x14000003))
//&& (tcp.dport == 0x7ab7)
}

predicate isSYNTCP {
 (tcp.flags &0x02)!=0
}

predicate isACK10TCP{
(tcp.flags &0x01)!=0 && (tcp.flags &0x08)!=0 && (tcp.flags &0x12)!=0  && (tcp.flags &0x11)!=0 && (tcp.flags &0x10)!=0  || (tcp.flags &0x04)!=0 || (tcp.flags &0x14)!=0 || (tcp.flags &0x19)!=0
}

//RULES FOR CLIENT-FRONTEND COMMUNICATION

//SYN packets grabbed. Should create a TCPSession object and insert a Set element
//rule	newTCPsess	{isTCPclient && isSYNTCP && !existTCPsession}  { action_new_tcpsession_syn(ethernetset.tcpsession)}
rule	newTCPsess	{isTCPclient && isSYNTCP }  { action_new_tcpsession_syn(ethernetset.tcpsession)}

//THE LAST RULE GRABS ANY 0X10 ACK PKT
//ACK where flag = any but not 0x02
//rule    existentTCPsess2_1 { isTCPclient  && isACK10TCP && existTCPsession } {action_exist_tcpsession_ack10(ethernetset.tcpsession)}
rule    existentTCPsess2_1 { isTCPclient  && isACK10TCP } {action_exist_tcpsession_ack10(ethernetset.tcpsession)}

//DROP PACKETS THAT DO NOT FIT IN RULES

rule droprest {1} {action_drop()}
