/*
//   Copyright (c) 1998 NetBoost Corporation.  All Rights Reserved.  
//   Except as expressly authorized by NetBoost Corporation in writing,
//   reproduction of any portion or element of this computer program, 
//   including without limitation, any portion of any text, sound, image, 
//   data or screen, is strictly prohibited and is a violation of Federal law.
*/

/*
//   This sample application allows for 'sniffing' of full duplex
//     traffic.  It requires two NetBoost PE's to operate.
//   
//   MACs A and B, on the first NetBoost PE ( nbhwpe0 ) are bound together in 
//     each direction.  Traffic  arriving at A is forwared to B, and traffic 
//     arriving at B is forwarded to A.  When a forwarded packet is sucessfully 
//   transmitted onto the wire, the packet may be 'recycled' at the ToInterface's
//     pass target ( example: /nbhwpe0/ToInterface:nbhwpe0A/Interface/pass )
//
//   Packets from this target are bound the TAP ace, which is instantiated
//     on the second NetBoost PE ( nbhwpe1 ).  The TAP ace collects statistics
//   and also forwards the packets to MAC A on the second PE, where a sniffing
//     device may be attached.
//
//     The action code supplied simply collects statistics, sends them to the host
//     via upcalls, and fowards packets received to its pass target, which is bound 
//     to MAC A on PE 1
*/



#include "NBtypes.h"
#include "nbswap.h"
#include "nbapi/nbappl.h"

//
// -------------- Ace Managers for each Ace ---------------------
//

class StatsAceManager: public AceManager {
public:
    StatsAceManager(NBAppl* appl, AceGroup* acegroup, char* name, unsigned long mode, char* pe);
    ~StatsAceManager();

   // void showPacketCount(Message* m);
   // UpcallHandler* showPacketCountUpcallHandler;

};


class Tap: public NBAppl {
public:
    Tap(void);
    ~Tap();
    
    AceGroup* aceGroup;
    StatsAceManager* statsAceManager;
};


// ----------------------------------------------------------------


void
main(int argc, char** argv) 
{
   // nb_trace_verbose(1);

    Tap* tap;
    try {
    tap = new Tap();
    }
    catch (NBError E) {
    NB_ABORT(1);
    }

    while (1) {
#ifdef WIN32
    Sleep(999999);
#elif defined __bsdi__
    sched_yield();
#else
    sleep(9);
#endif
    }
                           
    
}



// ----------------------------------------------------------------------

//
// Top level Appl Constructor
//

Tap::Tap(void):
    NBAppl("tap", NULL, NULL)
{
    //
    // Create group with NULL factory
    //
    try {
    aceGroup = new AceGroup(this, NULL, "tapgroup");
    } 
    catch (NBError E) {
        printf("Cannot create acegroup\n");
    NB_ABORT(2);
    }

    //
    // Create Aces
    //

    printf("Creating and loading Stats Ace..."); fflush(stdout);

    
    // Note that this ace is created on the second PE with the use of ACE_PLMODE_MANDATORY
    // and "nbhwpe1"
    try {
        statsAceManager = new StatsAceManager(this,
                                              aceGroup,
                                              "StatsAce",
                                              ACE_READER | ACE_PLMODE_MANDATORY,
                                              "nbhwpe0");
    }
    catch (NBError E) {
        printf("Cannot create Stats\n");
        NB_ABORT(5);
    }    
 
    printf("OK\n");

    unsigned long rval;

    printf("Binding Interface A input to Interface B output..."); fflush(stdout);

    // Bind system aces so traffic on PE 0, MAC A is forwarded to 
    // PE 0, MAC B
	//"/CcbswitchingAppl/CcbswitchingAceGroup/Ccbswitching"

    rval = bind("/nbhwpe0/FromInterface:nbhwpe0A/Interface/pass",
				"/tap/tapgroup/StatsAce");
                //"/nbhwpe0/ToInterface:nbhwpe0B/Interface");

    if (rval != NB_SUCCESS) {
        printf("Cannot bind Interface A to stats\n");
        NB_ABORT(rval);
    }
    printf("OK\n");   


	rval = bind("/tap/tapgroup/StatsAce/pass",
				"/nbhwpe0/ToInterface:nbhwpe0B/Interface");
                
    if (rval != NB_SUCCESS) {
        printf("Cannot bind stats pass to Interface B output\n");
        NB_ABORT(rval);
    }
    printf("OK\n");   

  
    printf("Binding Interface B input to Interface A output..."); fflush(stdout);
    
    // Bind system aces so traffic on PE 0, MAC B is forwarded to 
    // PE 0, MAC A
    rval = bind("/nbhwpe0/FromInterface:nbhwpe0B/Interface/pass",
                "/nbhwpe0/ToInterface:nbhwpe0A/Interface");

    if (rval != NB_SUCCESS) {
        printf("Cannot bind Interface B input to Interface A output\n");
        NB_ABORT(rval);
    }
    printf("OK\n");   



/*
    printf("Binding Interface A Output/pass to Stats..."); fflush(stdout);
    
    // Bind system aces so packets which have sucessfully transmitted on MAC A are
    // forwarded to the TAP ace on PE 1
    rval = bind("/nbhwpe0/ToInterface:nbhwpe0A/Interface/pass",
                "/tap/tapgroup/stats");

    if (rval != NB_SUCCESS) {
        printf("Cannot bind Interface A Output/pass to Stats\n");
        NB_ABORT(rval);
    }
    printf("OK\n");   

    printf("Binding  Interface B Output/pass to Stats..."); fflush(stdout);
    
    // Bind system aces so packets which have sucessfully transmitted on MAC B are
    // forwarded to the TAP ace on PE 1
    rval = bind("/nbhwpe0/ToInterface:nbhwpe0B/Interface/pass",
                "/tap/tapgroup/stats");

    if (rval != NB_SUCCESS) {
        printf("Cannot bind Interface B Output/pass to Stats\n");
        NB_ABORT(rval);
    }
    printf("OK\n");   

    
    printf("Binding stats/pass to nbhpe1-Interface A output..."); fflush(stdout);
    
    // Bind TAP ace's pass target to MAC A on PE 1, so traffic can be sniffed
    rval = bind("/tap/tapgroup/stats/pass",
                "/nbhwpe1/ToInterface:nbhwpe1A/Interface");

    if (rval != NB_SUCCESS) {
        printf("Cannot bind stats/pass to nbhpe1-Interface A output\n");
        NB_ABORT(rval);
    }
    printf("OK\n");   
*/
    printf("BINDINGS ARE DONE\n");


}

Tap::~Tap()
{
    delete statsAceManager;
    delete aceGroup;
}


// ----------------------------------------------------------------------


StatsAceManager::StatsAceManager(NBAppl* appl,
                                 AceGroup* acegroup,
                                 char* name,
                                 unsigned long mode, 
                                 char* pe):
    AceManager(appl, acegroup, name, mode, pe)
{

    //
    // Create the internal ace elements - upcalls, downcalls, targets
    //

    // upcall
   /* try {
    showPacketCountUpcallHandler = new UpcallHandler(appl,
                             acegroup,
                             this,
                             "showPacketCount",
                             (UpcallFp)&StatsAceManager::showPacketCount);
    }
    catch (NBError E) {
        printf("Cannot create Stats/showPacketCount\n");
        NB_ABORT(20);
    }
*/
    // load rules, actions

    int errorcode;
  
    if ((errorcode = load("taprules_stats", "tapactions_stats")) != NB_SUCCESS) {
        printf("Cannot load actions/rules for Stats\n");
        NB_ABORT(21);
    }

}


StatsAceManager::~StatsAceManager()
{
  //  delete showPacketCountUpcallHandler;
}

/*
void
StatsAceManager::showPacketCount(Message* m)
{
    NB_ASSERT(m->getLen1() == sizeof(nuint32));
    printf("NoOfPackets: %08d\n", ntohl(*(nuint32 *)m->getBuffer1()));
    releaseMessage(m);
}

  */ 
