	LIST
; P17CXXD.INC  Defines Header File, Version 2.0     Microchip Technology, Inc.
	NOLIST

; This header file defines short cuts for register bits for the 17CXX 
; microcontrollers.  This is an optional file for users and may not
; be fully supported by Microchip. The user is however, can modify 
; and utilize this file as required.
; The microcontrollers included in this file are:

; 17C42
; 17C43
; 17C44

; There is one group of defines that is valid for all microcontrollers.  
; Each microcontroller in this family also has its own section of special 
; defines.  Note that the processor must be selected and the file P17CXX.INC
; included before this file is included.  The processor may be selected the 
; following ways:

;       1. Command line switch:
;               C:\ MPASM MYFILE.ASM /P17CXX
;       2. LIST directive in the source file
;               LIST   P=17CXX
;       3. Processor Type entry in the MPASM full-screen interface

;==========================================================================
;
;	   Revision History
;
;==========================================================================

;Rev:	Date:	Reason:
;2.01	5/25/95	Added 17C43, 17C44

;==========================================================================
;
;       Generic Definitions
;
;==========================================================================

;----- ALUSTA Short Cuts --------------------------------------------------

   #define OVERFLOW                     ALUSTA,OV
   #define ZERO_BIT                     ALUSTA,Z
   #define DIGIT_CARRY_BIT              ALUSTA,DC
   #define CARRY_BIT                    ALUSTA,C

;----- CPUSTA Short Cuts --------------------------------------------------

   #define STACK_AVAIL                  CPUSTA,STKAV
   #define GLOBAL_INTERRUPT             CPUSTA,GLINTD
   #define TIMEOUT                      CPUSTA,NOT_TO
   #define POWERDOWN                    CPUSTA,NOT_PD

;----- INTSTA Short Cuts --------------------------------------------------

   #define PERIPH_FLAG                  INSTA,PEIR
   #define T0CKI_FLAG                   INSTA,T0CKIF
   #define TMR0_FLAG                    INSTA,T0IR
   #define INT_FLAG                     INSTA,INTIR
   #define PERIPH_INTERRUPT             INSTA,PEIE
   #define T0CKI_INTERRUPT              INSTA,T0CKIE
   #define INT_INTERRUPT                INSTA,INTIE
   #define TMR0_INTERRUPT               INSTA,T0IE

;----- PIE Short Cuts -----------------------------------------------------

   #define PORTB_INTERRUPT              PIE,IEB
   #define TIMER3_INTERRUPT             PIE,TM3IE
   #define TIMER2_INTERRUPT             PIE,TM2IE
   #define TIMER1_INTERRUPT             PIE,TM1IE
   #define CAPTURE2_INTERRUPT           PIE,CA2IE
   #define CAPTURE1_INTERRUPT           PIE,CA1IE
   #define TRANSMIT_INTERRUPT           PIE,TXIE
   #define RECEIVE_INTERRUPT            PIE,RCIE

;----- PIR Short Cuts -----------------------------------------------------

   #define PORTB_FLAG                   PIR,IRB
   #define TIMER3_FLAG                  PIR,TM3IR
   #define TIMER2_FLAG                  PIR,TM2IR
   #define TIMER1_FLAG                  PIR,TM1IR
   #define CAPTURE2_FLAG                PIR,CA2IR
   #define CAPTURE1_FLAG                PIR,CA1IR
   #define TRANSMIT_FLAG                PIR,TBMT
   #define RECEIVE_FLAG                 PIR,RBFL

;----- RCSTA Short Cuts ---------------------------------------------------

   #define SERIAL_ENABLE                RCSTA,SPEN
   #define RCV_DATA_LENGTH              RCSTA,RC8_9
   #define SINGLE_RECEIVE               RCSTA,SREN
   #define CONTIN_RECEIVE               RCSTA,CREN
   #define FRAMING_ERROR                RCSTA,FERR
   #define OVERRUN_ERROR                RCSTA,OERR
   #define RCV_BIT9                     RCSTA,RCD8

;----- RTCSTA Short Cuts --------------------------------------------------

   #define INT_EDGE                     RTCSTA,INTEDG
   #define TIMER0_EDGE                  RTCSTA,RTEDG
   #define RTC_MODE                     RTCSTA,T_C

;----- TCON1 Short Cuts ---------------------------------------------------

   #define TIMER_SIZE                   TCON1,T16_8
   #define TIMER3_SOURCE                TCON1,TMR3C
   #define TIMER2_SOURCE                TCON1,TMR2C
   #define TIMER1_SOURCE                TCON1,TMR1C

;----- TCON2 Short Cuts ---------------------------------------------------

   #define CAPTURE2_OVERFLOW            TCON2,CA2OVF
   #define CAPTURE1_OVERFLOW            TCON2,CA1OVF
   #define PWM2_OUTPUT                  TCON2,PWM2ON
   #define PWM1_OUTPUT                  TCON2,PWM1ON
   #define CAPTURE1_MODE                TCON2,CA1_PR3
   #define TIMER3_ENABLE                TCON2,TMR3ON
   #define TIMER2_ENABLE                TCON2,TMR2ON
   #define TIMER1_ENABLE                TCON2,TMR1ON

;----- TXSTA Short Cuts ---------------------------------------------------

   #define CLOCK_SOURCE                 TXSTA,CSRC
   #define XMT_DATA_LENGTH              TXSTA,TX8_9
   #define TRANSMIT_ENABLE              TXSTA,TXEN
   #define SYNC_MODE                    TXSTA,SYNC
   #define TRANSMIT_SHIFT               TXSTA,TRMT
   #define XMT_BIT9                     TXSTA,TXD8

	LIST
