	LIST
; P17CXX.INC  Standard Header File, Version 2.01     Microchip Technology, Inc.
	NOLIST

; This header file defines configurations, registers, and other useful bits of
; information for the 17CXX microcontrollers.  These names are taken to match 
; the data sheets as closely as possible.  The microcontrollers included
; in this file are:

; 17C42
; 17C43
; 17C44

; There is one group of defines that is valid for all microcontrollers.  
; Each microcontroller in this family also has its own section of special 
; defines.  Note that the processor must be selected before this file is 
; included.  The processor may be selected the following ways:

;       1. Command line switch:
;               C:\ MPASM MYFILE.ASM /P17C42
;       2. LIST directive in the source file
;               LIST   P=17C42
;       3. Processor Type entry in the MPASM full-screen interface

;==========================================================================
;
;	   Revision History
;
;==========================================================================

;Rev:	Date:	Reason:
;2.01	5/25/95	Added 17C43, 17C44

;==========================================================================
;
;       Generic Definitions
;
;==========================================================================

   W                            EQU     H'0000'
   F                            EQU     H'0001'

   CBLOCK               H'0000'
      BANK0
      BANK1
      BANK2
      BANK3
   ENDC

;----- Register Files -----------------------------------------------------

   CBLOCK               H'0000'                 ; Bank 0
      INDF0
      FSR0      
      PCL       
      PCLATH
      ALUSTA
      T0STA
      CPUSTA
      INTSTA
      INDF1
      FSR1      
      WREG
      TMR0L
      TMR0H
      TBLPTRL
      TBLPTRH
      BSR       
      PORTA
      DDRB      
      PORTB
      RCSTA
      RCREG
      TXSTA
      TXREG
      SPBRG
   ENDC

   CBLOCK               H'0010'                 ; Bank 1
      DDRC      
      PORTC
      DDRD      
      PORTD
      DDRE      
      PORTE
      PIR       
      PIE       
   ENDC

   CBLOCK               H'0010'                 ; Bank 2
      TMR1      
      TMR2      
      TMR3L
      TMR3H
      PR1       
      PR2       
      PR3L      
      PR3H      
   ENDC

   CBLOCK               H'0016'                 ; Bank 2 - alternate
      CAL1L
      CAL1H
   ENDC

   CBLOCK               H'0010'                 ; Bank 3
      PW1DCL
      PW2DCL
      PW1DCH
      PW2DCH
      CA2L      
      CA2H      
      TCON1
      TCON2
   ENDC

;----- ALUSTA Bits --------------------------------------------------------

   FS3                          EQU     H'0007'
   FS2                          EQU     H'0006'
   FS1                          EQU     H'0005'
   FS0                          EQU     H'0004'
   OV                           EQU     H'0003'
   Z                            EQU     H'0002'
   DC                           EQU     H'0001'
   C                            EQU     H'0000'

;----- CPUSTA Bits --------------------------------------------------------

   STKAV                        EQU     H'0005'
   GLINTD                       EQU     H'0004'
   NOT_TO                       EQU     H'0003'
   NOT_PD                       EQU     H'0002'

;----- INTSTA Bits --------------------------------------------------------

   PEIF                         EQU     H'0007'
   T0CKIF                       EQU     H'0006'
   T0IF                         EQU     H'0005'
   INTF                         EQU     H'0004'
   PEIE                         EQU     H'0003'
   T0CKIE                       EQU     H'0002'
   T0IE                         EQU     H'0001'
   INTE                         EQU     H'0000'

;----- PIE Bits -----------------------------------------------------------

   RBIE                         EQU     H'0007'
   TMR3IE                       EQU     H'0006'
   TMR2IE                       EQU     H'0005'
   TMR1IE                       EQU     H'0004'
   CA2IE                        EQU     H'0003'
   CA1IE                        EQU     H'0002'
   TXIE                         EQU     H'0001'
   RCIE                         EQU     H'0000'

;----- PIR Bits -----------------------------------------------------------

   RBIF                         EQU     H'0007'
   TMR3IF                       EQU     H'0006'
   TMR2IF                       EQU     H'0005'
   TMR1IF                       EQU     H'0004'
   CA2IF                        EQU     H'0003'
   CA1IF                        EQU     H'0002'
   TXIF                         EQU     H'0001'
   RCIF                         EQU     H'0000'

;----- PORTA Bits ---------------------------------------------------------

   NOT_RBPU			EQU	H'0007'
   T0CKI			EQU	H'0001'
   INT				EQU	H'0000'

;----- RCSTA Bits ---------------------------------------------------------

   SPEN                         EQU     H'0007'
   RC9                          EQU     H'0006'
   NOT_RC8                      EQU     H'0006'
   RC8_9                        EQU     H'0006'
   SREN                         EQU     H'0005'
   CREN                         EQU     H'0004'
   FERR                         EQU     H'0002'
   OERR                         EQU     H'0001'
   RCD8                         EQU     H'0000'

;----- T0STA Bits --------------------------------------------------------

   INTEDG                       EQU     H'0007'
   T0SE                         EQU     H'0006'
   T0CS                         EQU     H'0005'
   T0PS3                        EQU     H'0004'
   T0PS2                        EQU     H'0003'
   T0PS1                        EQU     H'0002'
   T0PS0                        EQU     H'0001'

;----- TCON1 Bits ---------------------------------------------------------

   CA2ED1                       EQU     H'0007'
   CA2ED0                       EQU     H'0006'
   CA1ED1                       EQU     H'0005'
   CA1ED0                       EQU     H'0004'
   T16                          EQU     H'0003'
   TMR3CS                       EQU     H'0002'
   TMR2CS                       EQU     H'0001'
   TMR1CS                       EQU     H'0000'

;----- TCON2 Bits ---------------------------------------------------------

   CA2OVF                       EQU     H'0007'
   CA1OVF                       EQU     H'0006'
   PWM2ON                       EQU     H'0005'
   PWM1ON                       EQU     H'0004'
   CA1                          EQU     H'0003'
   NOT_PR3                      EQU     H'0003'
   CA1_PR3                      EQU     H'0003'
   TMR3ON                       EQU     H'0002'
   TMR2ON                       EQU     H'0001'
   TMR1ON                       EQU     H'0000'

;----- TXSTA Bits ---------------------------------------------------------

   CSRC                         EQU     H'0007'
   TX9                          EQU     H'0006'
   NOT_TX8                      EQU     H'0006'
   TX8_9                        EQU     H'0006'
   TXEN                         EQU     H'0005'
   SYNC                         EQU     H'0004'
   TRMT                         EQU     H'0001'
   TXD8                         EQU     H'0000'

;==========================================================================
;
;       Configuration Bits - Generic
;
;==========================================================================

   _XMC_MODE                    EQU     H'FFBF'
   _MC_MODE                     EQU     H'FFEF'
   _MP_MODE                     EQU     H'FFFF'
   _WDT_NORM                    EQU     H'FFF3'
   _WDT_64                      EQU     H'FFF7'
   _WDT_256                     EQU     H'FFFB'
   _WDT_1                       EQU     H'FFFF'
   _LF_OSC                      EQU     H'FFFC'
   _RC_OSC                      EQU     H'FFFD'
   _XT_OSC                      EQU     H'FFFE'
   _EC_OSC                      EQU     H'FFFF'

;==========================================================================
;
;       Processor-dependent Definitions
;
;==========================================================================

 IFDEF __17C42
   ; Nothing else needs to be defined
	__MAXRAM H'0FF'
;   	__BADRAM 						;No Badram addresses
    #define __CONFIG_0
 ENDIF

 IFDEF __17C43
   ;----- Register Files --------------------------------------------------
      PRODL                     EQU     H'0018'
      PRODH                     EQU     H'0019'
	__MAXRAM H'0FF'
;   	__BADRAM 						;No Badram addresses
   #define __CONFIG_1
 ENDIF

 IFDEF __17C44
   ;----- Register Files --------------------------------------------------
      PRODL                     EQU     H'0018'
      PRODH                     EQU     H'0019'
	__MAXRAM H'0FF'
;   	__BADRAM 						;No Badram addresses
   #define __CONFIG_1
 ENDIF

;==========================================================================
;
;       Configuration Bits - Specific
;
;==========================================================================

 IFDEF __CONFIG_0
   _PMC_MODE                    EQU     H'FFAF'

   #undefine __CONFIG_0
 ENDIF

 IFDEF __CONFIG_1
   _PMC_MODE                    EQU     H'00AF'

   #undefine __CONFIG_1
 ENDIF

	LIST
