	LIST
; P16CXXD.INC  Defines Header File, Version 2.01    Microchip Technology, Inc.
	NOLIST

; This header file defines short cuts for register bits for the 16CXX 
; microcontrollers.  This is an optional file for users and may not
; be fully supported by Microchip. The user however, can modify 
; and utilize this file as required.
; The microcontrollers included in this file are:

;    16C61
;    16C62
;    16C620
;    16C621
;    16C622
;    16C63
;    16C64
;    16C65
;    16C71
;    16C73
;    16C74
;    16C84

; There is one group of defines that is valid for all microcontrollers.  
; Each microcontroller in this family also has its own section of special 
; defines.  Note that the processor must be selected and the file P16CXX.INC
; included before this file is included.  The processor may be selected the 
; following ways:

;       1. Command line switch:
;               C:\ MPASM MYFILE.ASM /P16C71
;       2. LIST directive in the source file
;               LIST   P=16C71
;       3. Processor Type entry in the MPASM full-screen interface

;==========================================================================
;
;	   Revision History
;
;==========================================================================

;Rev:	Date:	Reason:
;2.03	5/25/95	Added 16C6XX, 16C65A, 16C70A, 16C71A, 16C73A, 16C74A

;==========================================================================
;
;       Generic Definitions
;
;==========================================================================


;----- INTCON Short Cuts (except ADC/Periph) ------------------------------

   #define GLOBAL_INTERRUPT             INTCON,GIE
   #define TIMER0_INTERRUPT             INTCON,T0IE
   #define INT_INTERRUPT                INTCON,INTE
   #define RB_INTERRUPT                 INTCON,RBIE
   #define TIMER0_FLAG                  INTCON,T0IF
   #define INT_FLAG                     INTCON,INTF
   #define RB_FLAG                      INTCON,RBIF

;----- OPTION Short Cuts --------------------------------------------------

   #define PRESCALER                    OPTION_REG,PSA
   #define TMR0_EDGE                    OPTION_REG,T0SE
   #define TMR0_SOURCE                  OPTION_REG,T0CS

;----- PORTA Short Cuts ---------------------------------------------------

   #define RA7                          PORTA,H'0007'
   #define RA6                          PORTA,H'0006'
   #define RA5                          PORTA,H'0005'
   #define RA4                          PORTA,H'0004'
   #define RA3                          PORTA,H'0003'
   #define RA2                          PORTA,H'0002'
   #define RA1                          PORTA,H'0001'
   #define RA0                          PORTA,H'0000'

;----- PORTB Short Cuts ---------------------------------------------------

   #define RB7                          PORTB,H'0007'
   #define RB6                          PORTB,H'0006'
   #define RB5                          PORTB,H'0005'
   #define RB4                          PORTB,H'0004'
   #define RB3                          PORTB,H'0003'
   #define RB2                          PORTB,H'0002'
   #define RB1                          PORTB,H'0001'
   #define RB0                          PORTB,H'0000'

;----- STATUS Short Cuts --------------------------------------------------

   #define CARRY_BIT                    STATUS,C
   #define DIGIT_CARRY_BIT              STATUS,DC
   #define POWER_DOWN_BIT               STATUS,NOT_PD
   #define TIMEOUT_BIT                  STATUS,NOT_TO
   #define ZERO_BIT                     STATUS,Z

;==========================================================================
;
;       Processor-dependent Definitions
;
;==========================================================================

 IFDEF __16C71
   #define __ADC_CONFIG_0D
 ENDIF

 IFDEF __16C73
   #define __ADC_CONFIG_1D
 ENDIF

 IFDEF __16C74
   #define __ADC_CONFIG_1D
 ENDIF

;==========================================================================
;
;       More Handy Short-cuts
;
;==========================================================================

 IFDEF __ADC_CONFIG_0D
   #define ADC_FLAG                     ADCON0,ADIF
   #define ADC_ON                       ADCON0,ADON
   #define ADC_INTERRUPT                INTCON,ADIE
   #define START_ADC                    ADCON0,GO_DONE

   ;#undefine __ADC_CONFIG_0D
 ELSE
   #define PERIPH_INTERRUPT             INTCON,PEIE
 ENDIF


 IFDEF __ADC_CONFIG_1D
   #define ADC_FLAG                     PIR1,ADIF
   #define ADC_INTERRUPT                PIE1,ADIE
   #define ADC_ON                       ADCON0,ADON
   #define START_ADC                    ADCON0,GO_DONE

   ;#undefine __ADC_CONFIG_1D
 ENDIF


 IFDEF CMCON
   #define COMP2_OUTPUT                 CMCON,C2OUT
   #define COMP1_OUTPUT                 CMCON,C1OUT
   #define COMP_SELECT                  CMCON,S1
   #define COMPARE_INTERRUPT            PIE1,CMIE
   #define COMPARE_FLAG                 PIR1,CMIF
 ENDIF


 IFDEF EECON1
   #define EEPROM_FLAG                  EECON1,EEIF
   #define EEPROM_ERROR                 EECON1,WRERR
   #define EEPROM_WRITE                 EECON1,WR
   #define EEPROM_READ                  EECON1,RD
 ENDIF


 IFDEF PCON
   #define POWER_ON_RESET               PCON,NOT_POR
 ENDIF


 IFDEF PIE1
   #define PSP_INTERRUPT                PIE1,PSPIE
   #define SSP_INTERRUPT                PIE1,SSPIE
   #define CCP1_INTERRUPT               PIE1,CCP1IE
   #define TIMER2_INTERRUPT             PIE1,TMR2IE
   #define TIMER1_INTERRUPT             PIE1,TMR1IE
 ENDIF


 IFDEF PIR1
   #define PSP_FLAG                     PIR1,PSPIF
   #define SSP_FLAG                     PIR1,SSPIF
   #define CCP1_FLAG                    PIR1,CCP1IF
   #define TIMER2_FLAG                  PIR1,TMR2IF
   #define TIMER1_FLAG                  PIR1,TMR1IF
 ENDIF


 IFDEF PIE2                                             ; Assumes PIE2 and PIR2
   #define CCP2_INTERRUPT               PIE2,CCP2IE
   #define CCP2_FLAG                    PIR2,CCP2IF
 ENDIF


 IFDEF PORTC
   #define RC7                          PORTC,H'0007'
   #define RC6                          PORTC,H'0006'
   #define RC5                          PORTC,H'0005'
   #define RC4                          PORTC,H'0004'
   #define RC3                          PORTC,H'0003'
   #define RC2                          PORTC,H'0002'
   #define RC1                          PORTC,H'0001'
   #define RC0                          PORTC,H'0000'
 ENDIF


 IFDEF PORTD
   #define RD7                          PORTD,H'0007'
   #define RD6                          PORTD,H'0006'
   #define RD5                          PORTD,H'0005'
   #define RD4                          PORTD,H'0004'
   #define RD3                          PORTD,H'0003'
   #define RD2                          PORTD,H'0002'
   #define RD1                          PORTD,H'0001'
   #define RD0                          PORTD,H'0000'
 ENDIF


 IFDEF PORTE
   #define RE7                          PORTE,H'0007'
   #define RE6                          PORTE,H'0006'
   #define RE5                          PORTE,H'0005'
   #define RE4                          PORTE,H'0004'
   #define RE3                          PORTE,H'0003'
   #define RE2                          PORTE,H'0002'
   #define RE1                          PORTE,H'0001'
   #define RE0                          PORTE,H'0000'
 ENDIF


 IFDEF RCSTA
   #define RECEIVE_ENABLE               RCSTA,SPEN
   #define RCV_DATA_LENGTH              RCSTA,RC8_9
   #define SINGLE_RECEIVE               RCSTA,SREN
   #define CONTIN_RECEIVE               RCSTA,CREN
   #define FRAMING_ERROR                RCSTA,FERR
   #define OVERRUN_ERROR                RCSTA,OERR
   #define RCV_BIT9                     RCSTA,RCD8

   #define RECEIVE_INTERRUPT            PIE1,RCIE
   #define RECEIVE_FLAG                 PIR1,RBFL
 ENDIF


 IFDEF SSPCON
   #define WRITE_COLLISION              SSPCON,WCOL
   #define RCV_OVERFLOW                 SSPCON,SSPOV
   #define SERIAL_ENABLE                SSPCON,SSPEN
   #define CLOCK_POLARITY               SSPCON,CKP
 ENDIF


 IFDEF SSPSTAT
   #define DATA_NOT_ADDRESS             SSPSTAT,D_A
   #define STOP_BIT                     SSPSTAT,P
   #define START_BIT                    SSPSTAT,S
   #define READ_NOT_WRITE               SSPSTAT,R_W
   #define UPDATE_ADDRESS               SSPSTAT,UA
   #define BUFFER_FULL                  SSPSTAT,BF
 ENDIF


 IFDEF T1CON
   #define TIMER1_OSC                   T1CON,T1OSCEN
   #define TIMER1_SYNC                  T1CON,T1INSYNC
   #define TIMER1_CLOCK                 T1CON,TMR1CS
   #define TIMER1_ENABLE                T1CON,TMR1ON
 ENDIF


 IFDEF T2CON
   #define TIMER2_ENABLE                T2CON,TMR2ON
 ENDIF


 IFDEF TRISE
   #define IN_BUFFER_FULL               TRISE,IBF
   #define OUT_BUFFER_FULL              TRISE,OBF
   #define IN_BUFFER_OVERFLOW           TRISE,IBOV
   #define PSP_MODE                     TRISE,PSPMODE
 ENDIF


 IFDEF TXSTA
   #define CLOCK_SOURCE                 TXSTA,CSRC
   #define XMT_DATA_LENGTH              TXSTA,TX8_9
   #define TRANSMIT_ENABLE              TXSTA,TXEN
   #define SYNC_MODE                    TXSTA,SYNC
   #define HIGH_BAUD_RATE               TXSTA,BRGH
   #define TRANSMIT_SHIFT               TXSTA,TRMT
   #define XMT_BIT9                     TXSTA,TXD8

   #define TRANSMIT_INTERRUPT           PIE1,TXIE
   #define TRANSMIT_FLAG                PIR1,TXIF
 ENDIF


 IFDEF VRCON
   #define VREF_POWER                   VRCON,VREN
   #define VREF_OUTPUT                  VRCON,VROE
   #define VREF_RANGE                   VRCON,VRR
 ENDIF

	LIST
