	LIST
; P16C5XD.INC  Defines Header File, Version 2.01     Microchip Technology, Inc.
	NOLIST

; This header file defines short cuts for register bits for the 16C5X 
; microcontrollers.  This is an optional file for users and may not
; be fully supported by Microchip. The user however, can modify 
; and utilize this file as required.
; The microcontrollers included in this file are:

;    16C54
;    16C54A
;    16C55
;    16C56
;    16C57
;    16C58A

; There is one group of defines that is valid for all microcontrollers.  
; Each microcontroller in this family also has its own section of special 
; defines.  Note that the processor must be selected and the file P16C5X.INC
; included before this file is included.  The processor may be selected the 
; following ways:

;       1. Command line switch:
;               C:\ MPASM MYFILE.ASM /P16C54A
;       2. LIST directive in the source file
;               LIST   P=16C54A
;       3. Processor Type entry in the MPASM full-screen interface

;==========================================================================
;
;	   Revision History
;
;==========================================================================

;Rev:	Date:	Reason:
;2.01	5/25/95	Added 16C54A

;==========================================================================
;
;       Generic Definitions
;
;==========================================================================

;----- PORTA Short Cuts ---------------------------------------------------

   #define RA3                          PORTA,H'0003'
   #define RA2                          PORTA,H'0002'
   #define RA1                          PORTA,H'0001'
   #define RA0                          PORTA,H'0000'

;----- PORTB Short Cuts ---------------------------------------------------

   #define RB7                          PORTB,H'0007'
   #define RB6                          PORTB,H'0006'
   #define RB5                          PORTB,H'0005'
   #define RB4                          PORTB,H'0004'
   #define RB3                          PORTB,H'0003'
   #define RB2                          PORTB,H'0002'
   #define RB1                          PORTB,H'0001'
   #define RB0                          PORTB,H'0000'

;----- STATUS Short Cuts --------------------------------------------------

   #define CARRY_BIT                    STATUS,C
   #define DIGIT_CARRY_BIT              STATUS,DC
   #define POWER_DOWN_BIT               STATUS,NOTPD
   #define TIMEOUT_BIT                  STATUS,NOTTO
   #define ZERO_BIT                     STATUS,Z

;----- OPTION Short Cuts --------------------------------------------------

   #define PRESCALER                    OPTION_REG,PSA
   #define RTCC_EDGE                    OPTION_REG,T0SE
   #define RTCC_SOURCE                  OPTION_REG,T0CS

;==========================================================================
;
;       More Handy Short-cuts
;
;==========================================================================

 IFDEF PORTC
   ;----- PORTC Short Cuts ---------------------------------------------------
      #define RC7                               PORTC,H'0007'
      #define RC6                               PORTC,H'0006'
      #define RC5                               PORTC,H'0005'
      #define RC4                               PORTC,H'0004'
      #define RC3                               PORTC,H'0003'
      #define RC2                               PORTC,H'0002'
      #define RC1                               PORTC,H'0001'
      #define RC0                               PORTC,H'0000'
 ENDIF

	LIST
