;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10; Package: CL-USER; Lowercase: Yes -*-

(in-package #-ansi-90 "USER" #+ansi-90 "COMMON-LISP-USER")

"Copyright (c) 1990 International Lisp Associates.  All rights reserved."

;;; Define the CLIM-LISP package, a package designed to mimic ANSI Common Lisp
;;; as closely as possible (including CLOS).
;;; For the Macintosh, that's pretty much a noop, except for adding the Grey stream
;;; proposal.

(#-ansi-90 clim-lisp::defpackage #+ansi-90 defpackage CLIM-LISP

  (:use #-ansi-90 LISP #+ansi-90 COMMON-LISP
	#+(and ansi-90 Allegro) CLOS		       ; Get CLOS symbols not yet in CL
	#+(and clim-uses-lisp-streams Allegro) STREAM) ; Ditto for Gray stream symbols 
 
 #-ansi-90
 (:shadowing-import-from
   #+PCL PCL #-PCL CLOS
   DEFSTRUCT
   DOCUMENTATION
   SETF
   )

 #+(or Genera CLOE-Runtime)
 (:import-from CLOS-INTERNALS
   compile-file-environment-p)

 #+(and genera ansi-90)
 (:import-from LISP GET-SETF-METHOD-MULTIPLE-VALUE DEFINE-SETF-METHOD)

 ;; ANSI conditions spec
 #-ansi-90
 (:import-from
   #-Lucid conditions
   #+Lucid LUCID-COMMON-LISP
   #-CLIM-Conditions DEFINE-CONDITION
   HANDLER-BIND
   HANDLER-CASE
   SIGNAL
   
   RESTART-CASE
   INVOKE-RESTART
   FIND-RESTART

   ABORT
   CONTINUE
   MUFFLE-WARNING
   STORE-VALUE
   USE-VALUE

   SIMPLE-CONDITION
   WITH-SIMPLE-RESTART
   ;RESTART-BIND --- doesn't appear to work properly in Genera.
   )

 #+(and Lucid CLIM-Conditions)
 (:shadow DEFINE-CONDITION)

 (:export
   DEFINE-CONDITION
   HANDLER-BIND
   HANDLER-CASE
   SIGNAL
   
   RESTART-CASE
   INVOKE-RESTART
   FIND-RESTART

   ABORT
   CONTINUE
   MUFFLE-WARNING
   STORE-VALUE
   USE-VALUE

   SIMPLE-CONDITION
   WITH-SIMPLE-RESTART
   ;RESTART-BIND --- doesn't appear to work properly in Genera.
   )

 #-ansi-90
 (:import-from
   #+PCL PCL #-PCL CLOS
   ADD-METHOD					
   ALLOCATE-INSTANCE				
   BUILT-IN-CLASS				
   CALL-METHOD					
   CALL-NEXT-METHOD				
   CHANGE-CLASS				
   CLASS					
   #+PCL CLASSP
   CLASS-NAME					
   CLASS-OF					
   COMPUTE-APPLICABLE-METHODS			
   DESCRIBE-OBJECT
   DEFCLASS					
   DEFGENERIC					
   DEFINE-METHOD-COMBINATION			
   DEFMETHOD					
   ENSURE-GENERIC-FUNCTION			
   FIND-CLASS					
   FIND-METHOD					
   FUNCTION-KEYWORDS				
   GENERIC-FLET				
   GENERIC-FUNCTION				
   GENERIC-LABELS				
   INITIALIZE-INSTANCE				
   INVALID-METHOD-ERROR			
   MAKE-INSTANCE				
   MAKE-INSTANCES-OBSOLETE			
   MAKE-LOAD-FORM
   MAKE-LOAD-FORM-SAVING-SLOTS
   MAKE-METHOD					
   METHOD					
   METHOD-COMBINATION				
   METHOD-COMBINATION-ERROR			
   METHOD-QUALIFIERS				
   NEXT-METHOD-P				
   NO-APPLICABLE-METHOD			
   NO-NEXT-METHOD				
   PRINT-OBJECT				
   REINITIALIZE-INSTANCE			
   REMOVE-METHOD				
   SHARED-INITIALIZE				
   SLOT-BOUNDP					
   SLOT-EXISTS-P				
   SLOT-MAKUNBOUND				
   SLOT-MISSING				
   SLOT-UNBOUND				
   SLOT-VALUE					
   STANDARD					
   STANDARD-CLASS				
   STANDARD-GENERIC-FUNCTION			
   STANDARD-METHOD				
   STANDARD-OBJECT				
   STRUCTURE-CLASS				
   STRUCTURE-OBJECT				
   SYMBOL-MACROLET				
   UPDATE-INSTANCE-FOR-DIFFERENT-CLASS		
   UPDATE-INSTANCE-FOR-REDEFINED-CLASS		
   WITH-ACCESSORS				
   WITH-ADDED-METHODS				
   WITH-SLOTS					
   ;; Non-standard
   CLASS-PRECEDENCE-LIST
   CLASS-PROTOTYPE
   class-direct-subclasses
   class-direct-superclasses
   #-Genera ensure-class
   )

 #+(and Genera (not ANSI-90))
 (:import-from clos-internals ensure-class) ;; Grrr

 #+(and ansi-90 (not ccl-2))
 (:import-from #+PCL PCL #-PCL CLOS
   class-direct-subclasses 
   class-direct-superclasses 
   #-Genera ensure-class
   class-precedence-list 
   class-prototype
   funcallable-standard-class)

 #+ccl-2
 (:import-from ccl
   class-precedence-list
   class-prototype
   class-direct-subclasses
   class-direct-superclasses
   #+Ignore ;; Not there yet.  Maybe we should implement it?
   ensure-class)

 #+Genera-Release-8
 (:import-from FUTURE-COMMON-LISP defpackage print-unreadable-object)

 ;; Stream Proposal -- Classes and class predicates.
 ;; If the Lisp has the classes as specified in the Gray proposal (e.g. MCL)
 ;; then use them.  Otherwise, we have to define our own, so shadow.
 #-CLIM-uses-Lisp-stream-classes
 (:shadow
   ;; Class names
   fundamental-stream
   fundamental-input-stream
   fundamental-output-stream
   fundamental-character-stream
   fundamental-binary-stream
   fundamental-character-input-stream
   fundamental-character-output-stream
   fundamental-binary-input-stream
   fundamental-binary-output-stream

   ;; Function names
   input-stream-p
   output-stream-p
   open-stream-p
   streamp)

 ;; If the Lisp is set up so that WRITE-STRING and friends eventually invoke
 ;; their generic counterparts (e.g. STREAM-WRITE-STRING), then use the Lisp's
 ;; stream functions.  Otherwise, shadow and define our own.
 ;; --- Removed: PATHNAME and TRUENAME: We don't care if they don't work
 ;; --- on CLIM streams.
 #-CLIM-uses-Lisp-stream-functions
 (:shadow
   ;; CL stream input functions
   read-byte
   read-char
   unread-char
   read-char-no-hang
   peek-char
   listen
   read-line
   clear-input
   ;; CL stream output functions
   write-byte
   write-char
   write-string
   terpri
   fresh-line
   force-output
   finish-output
   clear-output
   format
   ;; Miscellaneous CL stream functions and macros
   stream-element-type
   close
   with-open-stream)

 (:export   

   ;; Random

   defpackage
   print-unreadable-object

   ;; Stream Proposal

   fundamental-stream
   fundamental-input-stream
   fundamental-output-stream
   fundamental-character-stream
   fundamental-binary-stream
   fundamental-character-input-stream
   fundamental-character-output-stream
   fundamental-binary-input-stream
   fundamental-binary-output-stream

   stream-read-char
   stream-unread-char
   stream-read-char-no-hang
   stream-peek-char
   stream-listen
   stream-read-line
   stream-clear-input

   stream-write-char
   stream-line-column
   stream-start-line-p
   stream-write-string
   stream-terpri
   stream-fresh-line
   stream-finish-output
   stream-force-output
   stream-clear-output
   stream-advance-to-column

   stream-read-byte
   stream-write-byte
   
   ;; CLOS

   ;; Symbols from chapter 2
   add-method
   allocate-instance
   built-in-class
   call-method
   call-next-method
   change-class
   class
   classp
   class-name
   class-of
   compute-applicable-methods
   defclass
   defgeneric
   define-method-combination
   defmethod
   ;; Not new, covered below.  Mac doesn't allow duplicates. -RWK
   ;documentation
   ensure-generic-function
   find-class
   find-method
   function-keywords
   generic-flet
   generic-function
   generic-labels
   initialize-instance
   invalid-method-error
   make-instance
   make-instances-obsolete
   make-method
   method
   method-combination
   method-combination-error
   method-qualifiers
   next-method-p
   no-applicable-method
   no-next-method
   print-object
   reinitialize-instance
   remove-method
   shared-initialize
   slot-boundp
   slot-exists-p
   slot-makunbound
   slot-missing
   slot-unbound
   slot-value
   standard-class
   standard-generic-function			
   standard-method				
   standard-object				
   structure-class				
   symbol-macrolet
   update-instance-for-different-class
   update-instance-for-redefined-class
   with-accessors
   with-added-methods
   with-slots
   ;; Post-88-002R additions that would have been in chapter 2
   describe-object
   make-load-form
   make-load-form-saving-slots
   ;; Not in Hornig's Chapter 2 list (?) but in both PCL and Genera CLOS, and
   ;; used by Silica
   class-precedence-list
   class-prototype
   class-direct-subclasses
   class-direct-superclasses
   ensure-class

   ;; CLtL

   &allow-other-keys
   &aux
   &body
   &environment
   &key
   &optional
   &rest
   &whole
   *
   **
   ***
   #-ansi-90 *applyhook*
   #-ansi-90 *break-on-warnings*
   *debug-io*
   *default-pathname-defaults*
   *error-output*
   #-ansi-90 *evalhook*
   *features*
   *load-verbose*
   *macroexpand-hook*
   #-ansi-90 *modules*
   *package*
   *print-array*
   *print-base*
   *print-case*
   *print-circle*
   *print-escape*
   *print-gensym*
   *print-length*
   *print-level*
   *print-pretty*
   *print-radix*
   *query-io*
   *random-state*
   *read-base*
   *read-default-float-format*
   *read-suppress*
   *readtable*
   *standard-input*
   *standard-output*
   *terminal-io*
   *trace-output*
   +
   ++
   +++
   -
   //
   ///
   /=
   /
   1+
   1-
   <
   <=
   =
   >
   >=
   abs
   acons
   acos
   acosh
   adjoin
   adjust-array
   adjustable-array-p
   alpha-char-p
   alphanumericp
   and
   append
   #-ansi-90 applyhook
   apply
   apropos
   apropos-list
   aref
   array-dimension
   array-dimension-limit
   array-dimensions
   array-element-type
   array-has-fill-pointer-p
   array-in-bounds-p
   array-rank-limit
   array-rank
   array-row-major-index
   array-total-size-limit
   array-total-size
   arrayp
   array
   ash 
   asin
   asinh
   assert
   assoc-if
   assoc-if-not
   assoc
   atanh
   atan
   atom
   bignum
   bit-and bit-ior bit-xor bit-eqv bit-nand bit-nor
   bit-andc1 bit-andc2 bit-orc1 bit-orc2 bit-not
   bit-vector-p
   bit-vector
   bit
   block
   boole-clr boole-set boole-1 boole-2 boole-c1 boole-c2 boole-and boole-ior
   boole-xor boole-eqv boole-nand boole-nor boole-andc1 boole-andc2 boole-orc1 boole-orc2
   boole
   both-case-p
   boundp
   break
   butlast
   byte
   byte-position
   byte-size
   caaaar
   caaadr
   caaar
   caadar
   caaddr
   caadr
   caar
   cadaar
   cadadr
   cadar
   caddar
   cadddr
   caddr
   cadr
   call-arguments-limit
   car
   case
   catch
   ccase
   cdaaar
   cdaadr
   cdaar
   cdadar
   cdaddr
   cdadr
   cdar
   cddaar
   cddadr
   cddar
   cdddar
   cddddr
   cdddr
   cddr
   cdr
   ceiling
   cerror
   #-ansi-90 char-bit
   #-ansi-90 char-bits
   #-ansi-90 char-bits-limit
   char-code
   char-code-limit
   #-ansi-90 char-control-bit
   char-downcase
   char-equal
   #-ansi-90 char-font
   #-ansi-90 char-font-limit
   char-greaterp
   #-ansi-90 char-hyper-bit
   char-int
   char-lessp
   #-ansi-90 char-meta-bit
   char-name
   char-not-equal
   char-not-greaterp
   char-not-lessp
   #-ansi-90 char-super-bit
   char-upcase
   char/=
   char<
   char<=
   char=
   char>
   char>=
   character
   characterp
   char
   check-type
   cis
   clear-input
   clear-output
   close
   clrhash
   code-char
   coerce
   #-ansi-90 commonp
   #-ansi-90 common
   compilation-speed
   compile
   compile-file
   compiled-function-p
   compiled-function
   #-ansi-90 compiler-let
   complex
   complexp
   concatenate
   cond
   conjugate
   cons
   consp
   constantp
   copy-alist
   copy-list
   copy-readtable
   copy-seq
   copy-symbol
   copy-tree
   cos
   cosh
   count
   count-if
   count-if-not
   ctypecase
   decf
   declaration
   declare
   decode-float
   decode-universal-time
   defconstant
   define-modify-macro
   define-setf-method
   defmacro
   defparameter
   defsetf
   defstruct
   deftype
   defun
   defvar
   delete-duplicates
   delete-file
   delete-if
   delete-if-not
   delete
   denominator
   deposit-field
   describe
   digit-char
   digit-char-p
   directory-namestring
   directory
   disassemble
   do
   do*
   do-all-symbols
   do-external-symbols
   do-symbols
   documentation
   dolist
   dotimes
   double-float-epsilon
   double-float-negative-epsilon
   double-float
   dpb
   dribble
   ecase
   ed
   eighth 
   elt
   encode-universal-time
   endp
   enough-namestring
   eq
   eql
   equalp
   equal
   error
   etypecase
   eval
   eval-when
   #-ansi-90 evalhook
   evenp
   every
   exp
   export
   expt
   fboundp
   fceiling
   ffloor
   fifth
   file-author
   file-length
   file-namestring
   file-position
   file-write-date
   fill
   fill-pointer
   find
   find-all-symbols
   find-if
   find-if-not
   find-package
   find-symbol
   finish-output
   first
   fixnum
   flet
   float-digits
   float-precision
   float-radix
   float-sign
   floatp
   float
   floor
   fmakunbound
   force-output
   format
   fourth
   fresh-line
   fround
   ftruncate
   ftype
   funcall
   function
   functionp
   gcd
   gensym
   gentemp
   get-decoded-time 
   get-dispatch-macro-character
   get-internal-real-time
   get-internal-run-time
   get-macro-character
   get-output-stream-string
   get-properties
   get-setf-method
   get-setf-method-multiple-value
   get-universal-time
   getf
   gethash
   get
   go
   graphic-char-p
   hash-table-count
   hash-table-p
   hash-table
   host-namestring
   identity

   if
   ignore
   imagpart
   import
   in-package
   incf
   inline
   input-stream-p
   inspect
   #-ansi-90 int-char
   integer-decode-float
   integer-length
   integerp
   integer
   internal-time-units-per-second
   intern
   intersection
   isqrt
   keywordp
   keyword
   labels
   lambda
   lambda-list-keywords
   lambda-parameters-limit
   last
   lcm
   ldb
   ldb-test
   ldiff
   least-negative-double-float
   least-negative-long-float
   least-negative-short-float
   least-negative-single-float
   least-positive-double-float
   least-positive-long-float
   least-positive-short-float
   least-positive-single-float
   length
   let
   let*
   lisp-implementation-type
   lisp-implementation-version
   list
   list*
   list-all-packages
   list-length
   listen
   listp
   load
   locally
   logandc1
   logandc2
   logand
   logbitp
   logcount
   logeqv
   logior
   lognand
   lognor
   lognot
   logorc1
   logorc2
   logtest
   logxor
   log
   long-float-epsilon
   long-float-negative-epsilon
   long-float
   long-site-name
   loop
   lower-case-p
   machine-instance
   machine-type
   machine-version
   macro-function
   macroexpand-1
   macroexpand
   macrolet
   make-array
   make-broadcast-stream
   #-ansi-90 make-char
   make-concatenated-stream
   make-dispatch-macro-character
   make-echo-stream
   make-hash-table
   make-list
   make-package
   make-pathname
   make-random-state
   make-sequence
   make-string
   make-string-input-stream
   make-string-output-stream
   make-symbol
   make-synonym-stream
   make-two-way-stream
   makunbound
   mapc
   mapcan
   mapcar
   mapcon
   maphash
   maplist
   mapl
   map
   mask-field
   max
   member-if
   member-if-not
   member
   merge
   merge-pathnames
   min
   minusp
   mismatch
   mod
   most-negative-double-float
   most-negative-fixnum
   most-negative-long-float
   most-negative-short-float
   most-negative-single-float
   most-positive-double-float
   most-positive-fixnum
   most-positive-long-float
   most-positive-short-float
   most-positive-single-float
   multiple-value-bind
   multiple-value-call
   multiple-value-list
   multiple-value-prog1
   multiple-value-setq
   multiple-values-limit
   name-char
   namestring
   nbutlast
   nconc
   nil
   nintersection
   ninth
   not
   notany
   notevery
   notinline
   nreconc
   nreverse
   nset-difference
   nset-exclusive-or
   nstring-capitalize
   nstring-downcase
   nstring-upcase
   nsublis
   nsubst-if
   nsubst-if-not
   nsubstitute
   nsubstitute-if
   nsubstitute-if-not
   nsubst
   nth
   nthcdr
   null
   numberp
   number
   numerator
   nunion
   oddp
   open
   open-stream-p
   optimize
   or
   otherwise
   output-stream-p
   package-name
   package-nicknames
   package-shadowing-symbols
   package-use-list
   package-used-by-list
   packagep
   package
   pairlis
   parse-integer
   parse-namestring
   pathname-device
   pathname-directory
   pathname-host
   pathname-name
   pathname-type
   pathname-version
   pathnamep
   pathname
   peek-char
   phase
   pi
   plusp
   pop
   position
   position-if
   position-if-not
   pprint
   prin1-to-string
   prin1
   princ-to-string
   princ
   print
   probe-file
   proclaim
   prog
   prog*
   prog1
   prog2
   progn
   progv
   #-ansi-90 provide
   psetf
   psetq
   push
   pushnew
   quote
   random
   random-state-p
   random-state
   rassoc-if
   rassoc-if-not
   rassoc
   rationalize
   rationalp
   rational
   ratio
   read-byte
   read-char
   read-char-no-hang
   read-delimited-list
   read-from-string
   read-line
   read-preserving-whitespace
   readtablep
   readtable
   read
   realpart
   reduce
   remf
   remhash
   remove-duplicates
   remove-if 
   remove-if-not
   remove
   remprop
   rem
   rename-file
   rename-package
   replace
   #-ansi-90 require
   rest
   return-from
   return
   revappend
   reverse
   room
   rotatef
   round
   rplaca
   rplacd
   safety
   satisfies
   sbit
   scale-float
   schar
   search
   second 
   sequence
   set
   #-ansi-90 set-char-bit
   set-difference
   set-dispatch-macro-character
   set-exclusive-or
   set-macro-character
   set-syntax-from-char
   setf
   setq
   seventh
   shadow
   shadowing-import
   shiftf
   short-float-epsilon
   short-float-negative-epsilon
   short-float
   short-site-name
   signed-byte
   signum
   simple-array
   simple-bit-vector-p
   simple-bit-vector
   simple-string-p
   simple-string
   simple-vector-p
   simple-vector
   sin
   single-float-epsilon
   single-float-negative-epsilon
   single-float
   sinh
   sixth
   sleep
   software-type
   software-version
   some
   sort
   space
   special-form-p
   special
   speed
   sqrt
   stable-sort
   standard-char-p
   standard-char
   step
   stream-element-type
   streamp
   stream
   string
   string-capitalize
   #-ansi-90 string-char-p
   #-ansi-90 string-char
   string-downcase
   string-equal
   string-greaterp
   string-left-trim
   string-lessp
   string-not-equal
   string-not-greaterp
   string-not-lessp
   string-right-trim
   string-trim
   string-upcase
   string/=
   string<
   string<=
   string=
   string>
   string>=
   stringp
   structure
   sublis
   subseq
   subsetp
   subst-if
   subst-if-not
   substitute
   substitute-if
   substitute-if-not
   subst
   subtypep
   svref
   sxhash
   symbol-function
   symbol-name
   symbol-package
   symbol-plist
   symbol-value
   symbolp
   symbol
   t
   tagbody
   tailp
   tan
   tanh
   tenth
   terpri
   the
   third
   throw
   time
   trace
   tree-equal
   truename
   truncate
   type-of
   typecase
   typep
   type
   unexport
   unintern
   union
   unless
   unread-char
   unsigned-byte
   untrace
   unuse-package
   unwind-protect
   upper-case-p
   use-package
   user-homedir-pathname
   values
   values-list
   variable
   vector
   vector-pop
   vector-push-extend
   vector-push
   vectorp
   warn
   when
   with-input-from-string
   with-open-file
   with-open-stream
   with-output-to-string
   write
   write-byte
   write-char
   write-line
   write-string
   write-to-string
   y-or-n-p
   yes-or-no-p
   zerop
   )
 #+ansi-90
 (:export abort
          arithmetic-error-operands
          arithmetic-error-operation
          augment-environment
          base-character
          base-string
          *break-on-signals*
          broadcast-stream
          broadcast-stream-streams
          cell-error
          cell-error-name
          *compile-file-pathname*
          compile-file-pathname
          *compile-print*
          compiler-macroexpand
          compiler-macroexpand-1
          compiler-macro-function
          *compile-verbose*
          compute-restarts
          concatenated-stream
          concatenated-stream-streams
          continue
          control-error
          copy-pprint-dispatch
          debug
          declaim
          declaration-information
          define-compiler-macro
          *debugger-hook*
          ;  define-condition
          define-declaration
          ;  defpackage
          destructuring-bind
          division-by-zero
          dynamic-extent
          echo-stream
          echo-stream-input-stream
          echo-stream-output-stream
          encapsulated
          enclose
          extended-character
          fdefinition
          file-error
          file-error-pathname
          file-stream
          file-string-length
          find-restart
          floating-point-overflow
          floating-point-underflow
          formatter
          function-information
          *gensym-counter*
          ; handler-bind
          ; handler-case
          invoke-debugger
          invoke-restart
          invoke-restart-interactively
          load-logical-pathname-translations
          *load-pathname*
          *load-print*
          load-time-value
          *load-truename*
          logical-pathname
          logical-pathname-translations
          loop-finish
          make-condition
          muffle-warning
          nth-value
          package-error
          package-error-package
          pathname-match-p
          pprint-dispatch
          pprint-exit-if-list-exhausted
          pprint-fill
          pprint-indent
          pprint-linear
          pprint-logical-block
          pprint-newline
          pprint-pop
          pprint-tab
          pprint-tabular
          *print-lines*
          *print-miser-width*
          print-not-readable
          *print-pprint-dispatch*
          *print-readably*
          *print-right-margin*
          ; print-unreadable-object
          program-error
          readtable-case
          restart-bind
          restart-case
          restart-name
          restart
          row-major-aref
          set-pprint-dispatch
          ; signal
          simple-condition
          simple-array-base-character
          simple-base-string
          simple-condition-format-arguments
          simple-condition-format-string
          simple-error
          simple-type-error
          simple-warning
          storage-condition
          store-value
          stream-error
          stream-error-stream
          stream-external-format
          string-stream
          style-warning
          synonym-stream
          synonym-stream-symbol
          translate-logical-pathname
          translate-pathname
          two-way-stream
          two-way-stream-input-stream
          two-way-stream-output-stream
          type-error
          type-error-datum
          type-error-expected-type
          unbound-variable
          undefined-function
          upgraded-array-element-type
          upgraded-complex-part-type
          variable-information
          warning
          wild-pathname-p
          with-compilation-unit
          with-condition-restarts
          with-hash-table-iterator
          with-package-iterator
          with-standard-io-syntax
))

;;; Get around a CCL-2 bug with DEFPACKAGE
#+ccl-2
(eval-when (eval compile load)
  (export '(()) "CLIM-LISP"))

#+Genera
(pushnew (find-package "CLIM-LISP") si:*reasonable-packages*)

(#-ansi-90 clim-lisp::defpackage #+ansi-90 defpackage CLIM-UTILS
  (:use		CLIM-LISP)

  #+Genera (:import-from SYSTEM ARGLIST)
  #+Genera (:import-from ZWEI INDENTATION)

  #+LCL3.0 (:import-from LCL ARGLIST)
  #+(and Lucid (not LCL3.0)) (:import-from SYSTEM ARGLIST)
  
  #+excl (:import-from excl arglist)

  #+ansi-90 (:import-from "COMMON-LISP" 
                "WITH-STANDARD-IO-SYNTAX")
  #+(or Genera (not ansi-90))
  (:shadow
    defun
    flet labels
    defgeneric defmethod)

  ;; --- X3J13 decided these were not part of the language any more.
  ;; Franz took them out of their LISP package in 4.0.  We still use some 
  ;; of them.  They are exported from CLIM-UTILS instead of from CLIM-Lisp
  ;; so the CLIM-Lisp package resembles (as much as possible) the
  ;; COMMON-LISP package.
  ;; --- rsl 26 November 1990}
  #+(and Allegro ansi-90)
  (:import-from CLTL1
		*applyhook*
		*break-on-warnings*
		*evalhook*
		*modules*
		applyhook
		char-bit
		char-bits
		char-bits-limit
		char-control-bit
		char-font
		char-font-limit
		char-hyper-bit
		char-meta-bit
		char-super-bit
;;;		common   ; ^%$!@# Franz
;;;		commonp
		compiler-let
		evalhook
		int-char
		make-char
		provide
		require
		set-char-bit
		string-char
		string-char-p)
  
  #+(and Allegro ansi-90)
  (:export *applyhook*
	   *break-on-warnings*
	   *evalhook*
	   *modules*
	   applyhook
	   char-bit
	   char-bits
	   char-bits-limit
	   char-control-bit
	   char-font
	   char-font-limit
	   char-hyper-bit
	   char-meta-bit
	   char-super-bit
;;;	   common   ; ^%$!@# Franz
;;;	   commonp
	   compiler-let
	   evalhook
	   int-char
	   make-char
	   provide
	   require
	   set-char-bit
	   string-char
	   string-char-p)

  (:export
    arglist

    ;; From defun --- Moved to LISP-UTILITIES 14 January 1991 by rsl.
    *keyword-package*
    extract-declarations
    named-lambda named-continuation non-dynamic-extent

    +string-array-element-type+

    ;; From utilities
    boolean
    with-collection collect
    with-gensyms
    integerize-coordinate
    my-round
    multiple-value-second
    with-fast-vector-references
    defmethod* defgeneric* do-defsetf* setf*
    ignore-errors
    maxf minf
    def-property-slot-macros
    def-property-slot-accessors
    define-unimplemented-protocol-method
    unimplemented warn-obsolete
    with-lockf initial-lock-value
    with-recursive-lockf initial-recursive-lock-value
    without-scheduling 
    *multiprocessing-p*
    make-process destroy-process
    processp
    current-process all-processes
    process-yield process-wait process-wait-with-timeout
    show-processes process-interrupt
    make-setf-function-name

    ;; From lisp-utilities
    without-interrupts
    funcallable-p
    standard-io-environment-vars-and-vals 
    with-standard-io-environment 
    with-standard-io-syntax ;; New ANSI name for this.
    follow-synonym-stream
    default-output-stream default-input-stream
    fintern
    gensymbol 
    remove-word-from-string
    push-unique
    catch-if
    letf-globally
    letf-globally-if
    time-elapsed-p
    ;; ignore
    with-stack-list
    with-stack-list*
    with-rem-keywords
    rem-keywords
    with-stack-copy-of-list
    define-keywords
    dovector
    doseq
    dorest
    define-group
    defun-property
    defun-inline
    writing-clauses
    clause
    flatten-arglist
    make-pass-on-arglist
    ignore-arglist
    canonicalize-and-match-lambda-lists	 
    define-class-mixture
    do-delimited-substrings
    with-compile-time-local-property
    get-compile-time-local-property
    define-compiler-macro
    define-constructor
    with-lock-held
    make-lock
    once-only
    with-simple-abort-restart
    with-simple-abort-restart-if

    ;; From defresource.lisp
    ;; with-resource-rd     ;; used by temporary-string-p --- not exported yet.
    ;; rd-objects os-object ;; used by temporary-string-p
    describe-resource
    clear-resource
    defresource
    allocate-resource
    deallocate-resource
    using-resource
    letf-using-resource

    ;; From clos.lisp
    find-dynamic-class
    copy-instance

    ;; From protocols.lisp
    protocol role operation find-protocol find-role 
    protocol-name protocol-roles protocol-operations
    role-slots
    operation-name 
    operation-required-args operation-specs operation-extra-args
    defprotocol defrole defoperation
	  
    *outer-self* *original-stream*
    generate-trampolines
    define-trampoline-template define-slot-trampoline-template

    ;; From autoconstructor.lisp
    fast-make-instance
    defautoconstructor
    autoconstructor
    disable-autoconstructors
    enable-autoconstructors

    ;; From QUEUE.LISP
    make-queue queue locking-queue
	  
    queue-contents-list queue-contents-type queue-empty-p queue-flush queue-full-p
    queue-last queue-length queue-next queue-pop queue-push queue-put queue-get
    queue-unget queue-size
	  
    with-queue-locked
	  
    )
  )

