;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-LISP; Base: 10; Lowercase: Yes -*-

(in-package "CLIM-LISP")

"Copyright (c) 1990, 1991 Symbolics, Inc.  All rights reserved."

;; Genera doesn't define STREAM-ELEMENT-TYPE as a generic function, so
;; we need to shadow it here.
(defgeneric stream-element-type (stream)
  (:selector :stream-element-type))

(defmethod stream-element-type ((stream si:stream))
  (common-lisp:stream-element-type stream))

;; Ditto, CLOSE
(defgeneric close (stream &key abort))

(defmethod close ((stream t) &key abort)
  (common-lisp:close stream :abort abort))


;;; Define the "reverse trampolines" for Genera, that is, stream methods on
;;; non-CLIM streams that trampoline back into Genera stream operations.

(defmethod stream-read-byte ((stream t))
  (or (scl:send stream :tyi nil)
      :eof))

(defmethod stream-read-char ((stream t))
  (or (scl:send stream :tyi nil)
      :eof))

(defmethod stream-unread-char ((stream t) character)
  (scl:send stream :untyi character))

(defmethod stream-read-char-no-hang ((stream t))
  (or (scl:send stream :tyi-no-hang nil)
      :eof))

(defmethod stream-peek-char ((stream t))
  (or (scl:send stream :tyipeek nil)
      :eof))

(defmethod stream-listen ((stream t))
  (scl:send stream :listen))

(defmethod stream-read-line ((stream t))
  (read-line stream nil :eof)) ;; Doesn't map well into :LINE-IN.

(defmethod stream-clear-input ((stream t))
  (scl:send stream :clear-input))

(defmethod stream-write-byte ((stream t) integer)
  (scl:send stream :tyo integer))

(defmethod stream-write-char ((stream t) character)
  (scl:send stream :tyo character))

(defmethod stream-write-string ((stream t) string &optional (start 0) end)
  (scl:send stream :string-out string start end))

(defmethod stream-terpri ((stream t))
  (scl:send stream :tyo #\Newline))

(defmethod stream-fresh-line ((stream t))
  (scl:send stream :fresh-line))

(defmethod stream-force-output ((stream t))
  (scl:send stream :force-output))

(defmethod stream-finish-output ((stream t))
  (scl:send stream :finish))

(defmethod stream-clear-output ((stream t))
  (scl:send stream :clear-output))
