;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10; Lowercase: Yes -*-

(in-package :user)

"Copyright (c) 1990, 1991 by International Lisp Associates.  All rights reserved.
Portions copyright (c) 1990 by Franz, Inc.  All rights reserved."

;;; This file is all #+EXCL.

;;; Make sure CLIM is actually going to load into this environment.
(when (null excl:*ignore-package-name-case*)
  (setf excl:*ignore-package-name-case* t)
  (warn "Package name case will be ignored henceforth."))

(unless (eql excl:*current-case-mode* ':case-insensitive-upper)
  (excl:set-case-mode :case-insensitive-upper)
  (warn "Symbol case mode set to ~S" ':case-insensitive-upper))

;;; Load software required for proper operation of CLIM.
(eval-when (compile load eval)
  (require :clx))

#+Allegro-v3.1
(progn

  (let* ((patch-package (find-package ':patch))
	 (patches-sym (and patch-package 
			   (find-symbol (string '*patches*) patch-package)))
	 (patches (and patches-sym (boundp patches-sym) 
		       (symbol-value patches-sym))))
    (unless (and (assoc 26. patches)
		 #+Sparc (assoc 28. patches))
      (error "CLIM requires patches 26 and 28 in Allegro V3.1")))

;;; In Allegro-v3.1, we have to make sure we have the right version of
;;; PCL loaded.  This is either one which has the :NEW-CACHE feature
;;; asserted, or which has the string "May Day PCL" somewhere in its
;;; name.  Ramana has an Allegro 3.1 world which has PCL loaded but not
;;; PROVIDEd, which I completely don't understand, but that's the way
;;; things are...
  (unless (member ':new-cache *features*)
    (let* ((pcl-package (find-package ':pcl))
	   (pcl-version-sym
	    (and pcl-package 
		 (find-symbol (string '*pcl-system-date*) pcl-package)))
	 (pcl-version (and pcl-version-sym (boundp pcl-version-sym) 
			   (symbol-value pcl-version-sym))))
      ;; --- Kludge for Ramana -- he has PCL loaded without it being provided.
      (when (stringp pcl-version)
	(provide :pcl))

      (require :pcl "clim-pcl.fasl")		; --- Jim Veitch says this is right.

      ;; Verify:
      (unless (search "May Day PCL" pcl-version)
	(error "CLIM requires New Caching PCL"))))

  (eval-when (compile load eval)
    (require "PCL" "clim-pcl.fasl")))	; --- Jim Veitch says this is right.




