;;; -*- Base: 10; Package: CLIM-UTILS; Mode: LISP; Syntax: Common-Lisp; Lowercase: Yes -*-

(in-package "CLIM-UTILS")

"Copyright (c) 1990 International Lisp Associates.  All rights reserved."

;;; Lucid and Franz have an old syntax for defining conditions.  We define
;;; a macro here which supports [a subset of] the ANSI syntax and which
;;; forwards to their syntax.  Then we can just write DEFINE-CONDITION
;;; with [relative] impunity.  I suppose there is some question about
;;; whether this macro should be in all implementations so that we can
;;; detect the non-portable cases more easily.  I'll think about it.
(defmacro define-condition (name parent-types &optional slots &rest options)
  (let ((readers nil)
	(real-slots slots)
	(trampoline-define-condition
	  (intern "DEFINE-CONDITION"
		  (find-package #+Lucid 'lucid-common-lisp
				#-Lucid 'conditions)))
	(conc-name (format nil "~A-~A-" name 'accessor-for)))
    (unless (keywordp (first slots))
      (setq real-slots nil)
      (dolist (slot slots)
	(let ((reader (getf (rest slot) ':reader)))
	  (when reader
	    (let ((trampoline (intern (format nil "~A~A" conc-name (first slot)))))
	      ;; Not likely to be EQL, but can causes an infinite loop
	      ;; in Lucid if it is...
	      (unless (eql trampoline reader)
		(push `(defun-inline ,reader (condition)
			 (,trampoline condition)) readers)))))
	(let ((initarg (getf (rest slot) ':initarg)))
	  (unless (eq initarg (intern (symbol-name (first slot)) *keyword-package*))
	    (error "We can't support initargs to DEFINE-CONDITION that ~
                    don't match the slot name.")))
	(let ((initform (getf (rest slot) ':initform)))
	  (if initform
	      (push `(,(first slot) ,initform) real-slots)
	      (push `(,(first slot)) real-slots)))))
    (setq real-slots (nreverse real-slots))
    `(progn ,@readers
	    (,trampoline-define-condition ,name ,parent-types ,real-slots
	     (:conc-name ,conc-name)
	     ,@options))))
