;;; -*- Mode: LISP; Syntax: Common-LISP; Package: (CLIM-CONDITIONS :USE (CLIM-LISP CLIM CLIM-SHARED CLIM-UTILS)); Base: 10; Lowercase: Yes -*-

"Copyright (c) 1988, 1989, 1990, 1991 International Lisp Associates.  All rights reserved."

;;; This file needs to go into the newly-created CLIM-CONDITIONS because there isn't
;;; another package which exists at the time you load this file, and which is
;;; appropriate.  It can't be CLIM-SHARED because that package is locked.

;;; We didn't create a separate file for the package declaration, so we pay the price
;;; by having that ridiculuous package declaration in the file attribute list.

(in-package "USER") ;; Sigh

;;; Anything we want exported from here is already exported from CLIM-LISP, CLIM or CLIM-SHARED.

(clim-lisp::defpackage clim-conditions 
  (:use clim-lisp clim clim-shared clim-utils)
  #-ccl-2
  (:shadowing-import-from CLIM-UTILS
   DEFMETHOD DEFUN FLET LABELS DYNAMIC-EXTENT NON-DYNAMIC-EXTENT))

;;; This time for sure!
(in-package "CLIM-CONDITIONS")

(define-condition parse-error (error) ())

;;; This should include SIMPLE-CONDITION, in CLOS-based (i.e. ANSI)
;;; condition systems.

(define-condition simple-parse-error (parse-error)
  ((format-string :reader parse-error-format-string :initarg :format-string)
   (format-arguments :reader parse-error-format-arguments :initarg :format-arguments))
  (:report (lambda (condition stream)
	     (apply #'format stream (parse-error-format-string condition)
				    (parse-error-format-arguments condition)))))

(define-condition input-not-of-required-type (parse-error)
  ((string :reader input-not-of-required-type-string :initarg :string)
   (type :reader input-not-of-required-type-type :initarg :type))
  (:report (lambda (condition stream)
	     (let ((string (input-not-of-required-type-string condition)))
	       (format stream "The input read, ~A, was not "
		       (if (equal string "") '|""| string))
	       (describe-presentation-type (input-not-of-required-type-type condition)
					   stream)
	       (write-char #\. stream)))))

(defun parse-error (format-string &rest format-arguments)
  (declare (dynamic-extent format-arguments))
  ;; why did SMBX do it this way, rather than calling ERROR?
  (signal 'simple-parse-error
	  :format-string format-string
	  :format-arguments (copy-list format-arguments))
  (error "parse-error signalled outside of ACCEPT."))

(defun input-not-of-required-type (object type)
  ;; why did SMBX do it this way, rather than calling ERROR?
  (signal 'input-not-of-required-type :string object :type type)
  (error "input-not-of-required-type signalled outside of ACCEPT."))

;;; Genera name...   Also, ANSI-90 name.  --RWK
#-(and ANSI-90 (not Allegro))
(define-condition print-not-readable (error)
  ((object :initarg :object :reader print-not-readable-object))
  (:report (lambda (condition stream)
	     (format stream "Can't print ~S readably" (print-not-readable-object condition)))))

(define-condition frame-exit (error)
  ((frame :initarg :frame :reader frame-exit-frame))
  (:report (lambda (condition stream)
	     (format stream "(Internal condition)  Exiting frame ~S."
		     (frame-exit-frame condition)))))

(defun frame-exit-internal (frame)
  ;; Copying the SMBX technique for now, although it
  ;; seems as if calling the real ERROR function should suffice...
  (signal 'frame-exit :frame frame)
  (error "(Internal error) FRAME-EXIT of ~S not handled." frame))
