;;; -*- Mode: LISP; Syntax: Common-lisp; Package: (CONDITIONS :use CL); Base: 10 -*-

(export '(
	  DEFINE-CONDITION
	  HANDLER-BIND
	  HANDLER-CASE
	  SIGNAL
	  ))

(eval-when (eval compile load)

(defun condition-typespec-to-scl-types (typespec)
  (cond ((symbolp typespec) typespec)
	((and (listp typespec)
	      (eq (first typespec) 'or)
	      (every #'symbolp (rest typespec)))
	 (rest typespec))
	(t
	 (scl:error "Can't decode typespec ~S" typespec))))

)



(defmacro define-condition (name
			    (&rest parent-types)
			    &optional
			    ((&rest slot-specifiers))
			    &body options)
  (let* ((instance-variables '())
	 (flavor-options (copy-tree '((:initable-instance-variables)
				      (:readable-instance-variables)
				      (:writable-instance-variables))))
	 (other-forms '()))
    (labels ((process-slot-specifier (slot-specifier)
	       (etypecase slot-specifier
		 (symbol
		   (push `(,slot-specifier) instance-variables)
		   (push slot-specifier (cdr (assoc :initable-instance-variables
						    flavor-options))))
		 (cons
		   (scl:destructuring-bind (slot-name . slot-options) slot-specifier
		     (let ((iv (list* slot-name nil))
			   (initarg-specified nil))
		       (scl:loop for (opt val) on slot-options by 'cddr do
			 (ecase opt
			   (:initarg
			     (push `(,val ,slot-name)
				   (cdr (assoc :initable-instance-variables flavor-options)))
			     (setq initarg-specified t))
			   (:reader
			     (push `(,val ,slot-name)
				   (cdr (assoc :readable-instance-variables flavor-options))))
			   (:writer
			     (push `(,val ,slot-name)
				   (cdr (assoc :writable-instance-variables flavor-options))))
			   (:accessor
			     (push `(,val ,slot-name)
				   (cdr (assoc :readable-instance-variables flavor-options)))
			     (push `((setf ,val) ,slot-name)
				   (cdr (assoc :writable-instance-variables flavor-options))))
			   ))
		       ;; probably should do it all the time...
		       (unless initarg-specified
			 (push slot-name (cdr (assoc :initable-instance-variables
							  flavor-options))))
		       (push iv instance-variables))))))
	     (process-option (option)
	       (scl:destructuring-bind (option . stuff) option
		 (ecase option
		   (:documentation)
		   (:report
		     (let ((exp (first stuff)))
		       (push `(scl:defmethod (dbg:report ,name) (stream)
				,(if (stringp exp)
				     `(write-string ,exp stream)
				     `(funcall #',exp scl:self stream)))
			     other-forms))))))
	     )
      (mapc #'process-slot-specifier slot-specifiers)
      (mapc #'process-option options))
    `(progn (scl:defflavor ,name ,(reverse instance-variables)
	       (,@parent-types)
	       ,@flavor-options)
	    ,@(reverse other-forms))))

#||

(define-condition my-condition (error)
		  (slot1
		    (slot2 :initarg :foo :reader slot2 :writer set-slot2)
		    (slot3 :accessor slot3))
  (:report "foobar")
  (:report foobar)
  (:report (lambda (cond str) (format str "cond ~S" cond))))

||#



(defmacro handler-bind (clauses &body body)
  ;; --- doesn't manage to remove this list of handlers when the clause bodies are executing.
  `(progn					;stop Zwei c-sh-M descent
     (scl:condition-bind ,(scl:loop for clause in clauses
			      collect
				(scl:destructuring-bind (typespec handler) clause
				  `(,(condition-typespec-to-scl-types typespec)
				    ,handler)))
       ,@body)))


#||

(handler-bind ((foo #'(lambda (cond) cond))
	       (bar #'(lambda (f) f))
	       ((or baz quux) #'(lambda (q) (+ q 3))))
  (quux))

||#



(defmacro handler-case (expression &body clauses)
  (let ((last-clause (first (last clauses))))
    (if (and last-clause
	     (listp last-clause)
	     (eq (first last-clause) :no-error))
	(scl:destructuring-bind (colon-no-error arglist . body) last-clause
	  (declare (ignore colon-no-error))
	  (let ((all-return (gensym))
		(normal-return (gensym)))
	    `(block ,all-return
	       (multiple-value-call
		 #'(lambda ,arglist ,@body)
		 (block ,normal-return
		   (return-from ,all-return
		     (handler-case (return-from ,normal-return
				     ,expression)
		       ,@(butlast clauses))))))))
	(let ((error-var (gensym)))
	  `(progn				;so Zwei's c-sh-M will stop
	     (scl:condition-case (,error-var) ,expression
	      ,@(scl:loop for clause in clauses
		    collect
		  (scl:destructuring-bind (type (&optional (var nil var-p)) . body)
		      clause
		    (let* ((scl-types (cond ((symbolp type) type)
					    ((and (listp type)
						  (eq (first type) 'or)
						  (every #'symbolp type))
					     (cdr type))
					    (t (scl:error "Can't decode type ~S" type)))))
		      `(,scl-types (let ,(when var-p `((,var ,error-var)))
				     ,@body)))))))))))

#||

(handler-case (foo)
  (bar () 3)
  (baz (nil) 4)
  (quux (mumble) (+ mumble 5))
  ((or t1 t2 t3) () 99)
  #+ignore
  (:no-error (a b c) (list a b c)))

||#



(defun signal (datum &rest arguments)
  (apply #'scl:signal datum arguments))
