;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10; Package: USER; Lowercase: Yes -*-

(in-package #-ansi-90 "USER" #+ansi-90 "COMMON-LISP-USER")

"Copyright (c) 1991 by International Lisp Associates.  All rights reserved.

 Portions derived from CLIM 1.0 file SYS:CLIM;UTILS;PACKAGES.LISP:
   Copyright (c) 1990, 1991 Symbolics, Inc.  All rights reserved.
   Portions copyright (c) 1990, 1991 International Lisp Associates.  All rights reserved."

(clim-lisp:defpackage clim2
  (:use	CLIM-LISP CLIM-UTILS)
  
  (:nicknames "CLIM" "CLIM-PORT" "CLIM-SHARED"
	      "SILICA" "W" "SIO2" "WINDSHIELD"
	      "WS" "CLIM-INTERNALS" "CI" "CLIM-STREAM"
	      "ON-X" "CLX-UTILS" "ON-GENERA" "ON-MCL"
	      "CLIM-CONDITIONS")

;;  #+Genera (:colon-mode :internal)
  #+Genera (:import-from SYSTEM ARGLIST)
  #+Genera (:import-from ZWEI INDENTATION)

  #-ccl-2
  (:shadowing-import-from CLIM-UTILS
    defun
    flet labels
    defgeneric defmethod
    dynamic-extent
    #-excl non-dynamic-extent)

  #+(or Lucid excl)
  (:shadowing-import-from CLIM-UTILS
    with-slots)

  ;; add the exports from clim-packages.  9/29/91 doughty

  (:export
  
    CLIM-VERSION
    DEFINE-CLIM-PACKAGE

    ;; From CONDITIONS
    PARSE-ERROR SIMPLE-PARSE-ERROR INPUT-NOT-OF-REQUIRED-TYPE
    #-ANSI-90 PRINT-NOT-READABLE ;; This is in CLIM-LISP under #+ANSI-90
    FRAME-EXIT

    ;; Region protocol
    region copy-region regionp ;;* path area
    point standard-point make-point point-position point-x point-y
;;*    polyline standard-polyline make-polyline make-polyline* polyline-closed
;;*    line standard-line make-line make-line*
;;*    line-start-point line-end-point line-start-point* line-end-point*
;;*    elliptical-arg standard-elliptical-arg make-elliptical-arg make-elliptical-arg*
;;*    polygon standard-polygon make-polygon make-polygon*
;;*    polygon-points map-over-polygon-coordinates map-over-polygon-segments
    rectangle rectanglep standard-rectangle make-rectangle make-rectangle*
    rectangle-min-point rectangle-max-point 
;;* rectangle-edges*
    rectangle-min-x rectangle-min-y rectangle-max-x rectangle-max-y
    rectangle-width rectangle-height rectangle-size
;;*    ellipse standard-ellipse make-ellipse make-ellipse*
    everywhere nowhere
    +everywhere+ +nowhere+
;;*    region-equal
    region-empty-p
    region-contains-region-p region-contains-point*-p region-intersects-region-p
;;*    region-set region-set-function region-set-regions map-over-region-set-regions
    region-union region-intersection region-difference
    rectangle-set rectangle-set-rectangles
    make-rectangle-set make-normalized-rectangle-set
    
    ;; Bounding rectangle protocol
    ;; --- Some of the following is obvious superfluous.  It is derived from the 0.9
    ;; --- spec PLUS the Silica code.  Sigh.
    ;; In other words, Rao has some names in the implementation that are
    ;; different from the last spec.  For now, define synonyms.
    bounding-rectangle bounding-rectangle* with-bounding-rectangle*
    bounding-rectangle-position bounding-rectangle-position*
    bounding-rectangle-left bounding-rectangle-right
    bounding-rectangle-top bounding-rectangle-bottom
    bounding-rectangle-width bounding-rectangle-height bounding-rectangle-size
    bounding-rectangle-dimensions
    bounding-rectangle-min-point bounding-rectangle-min-x bounding-rectangle-min-y
    bounding-rectangle-max-point bounding-rectangle-max-x bounding-rectangle-max-y
    
    ;; Transformation protocol
    transformation transformationp copy-transformation +identity-transformation+
    make-transformation make-translation-transformation
;;; --- The following four functions have been implemented by RSL but not yet tested:
    make-rotation-transformation make-rotation-transformation*
    make-scaling-transformation make-scaling-transformation*
;;; --- The following four are not yet implemented:
    make-reflection-transformation make-reflection-transformation*
    make-3-point-transformation make-3-point-transformation*
    transformation-equal identity-transformation-p translation-transformation-p
    invertible-transformation-p reflection-transformation-p rigid-transformation-p
    even-scaling-transformation-p scaling-transformation-p rectilinear-transformation-p
    compose-transformations invert-transformation
;;; --- The spec says COMPOSE-xxx-TRANSFORMATION; the code says the following.  ???
    compose-translation compose-scaling compose-rotation
;;; --- And yet another set of names from Rao.  Defining all the previous as synonyms
    compose-with-translation compose-with-scaling compose-with-rotation
    ;; we have one name in the document, another in the implementation.
    ;; The implementation has been upgraded to support all three naming schemes
    compose-rotation-transformation compose-scaling-transformation 
    compose-translation-transformation
;;; Macros for use by callers (imported from Silica):
    with-translation with-scaling with-rotation

    transform-region untransform-region
    transform-point* untransform-point*
    ;; These were added as synonyms in the implementation.
    transform-distance* untransform-distance*
;;; --- The following two lines are not in the spec, but ARE in the code:
    transform-rectangle* untransform-rectangle*
    transform-dimensions untransform-dimensions translation-x translation-y
;;; --- The spec doesn't have the following four functions.  Are they exported?
    reset-to-identity reset-to-translation
    reset-to-st-transformation reset-to-srt-transformation
    
    ;; Stream classes
    fundamental-stream fundamental-input-stream fundamental-output-stream
    fundamental-character-stream fundamental-binary-stream
    fundamental-character-input-stream fundamental-character-output-stream
    fundamental-binary-input-stream fundamental-binary-output-stream
    
    ;; Stream operations
    streamp close open-stream-p stream-element-type 
;;*    stream-pathname stream-truename
    input-stream-p output-stream-p
    
    ;; Input stream operations
    stream-clear-input stream-listen

    ;; These may really belong to clim-shared.
    stream-update-region stream-ensure-cursor-visible
    
    ;; Character input stream operations
    stream-read-char stream-unread-char stream-read-char-no-hang
    stream-peek-char stream-read-line
    
    ;; Output stream operations
    stream-finish-output stream-force-output stream-clear-output
;;*    stream-buffering-output-p with-buffered-output
    
    ;; Character output stream operations
    stream-write-char stream-write-string stream-terpri stream-fresh-line
;;*    stream-line-column stream-advance-to-column stream-start-line-p
    stream-text-margin stream-default-text-margin

    ;; Binary stream I/O operations
    stream-read-byte stream-write-byte
    
    ;; Stream extension tests
    extended-output-stream-p extended-input-stream-p
    
    ;; Extended output protocol
;;*    stream-cursor-position
    stream-cursor-position* stream-set-cursor-position*
    stream-increment-cursor-position* stream-advance-cursor-line
    stream-string-width stream-character-width stream-line-height
    stream-baseline stream-current-line-height stream-vsp stream-tab-size
    stream-end-of-line-action stream-end-of-page-action
    stream-foreground stream-background 
    stream-user-transformation
;;*    stream-character-height
    
    with-text-style with-text-family with-text-face with-text-size
    
    ;; Graphics operations
    draw-point draw-point* draw-points draw-points*
    draw-line draw-line* draw-lines draw-lines*
    draw-polygon draw-polygon* draw-rectangle draw-rectangle*
    draw-ellipse draw-ellipse* draw-circle draw-circle* draw-text draw-text*
    pi-single-float 2pi pi/2
    copy-area
    ;; draw-design --- NYI ---

    ;; Printer stream operations
    make-printer-stream show-page


    ;; Drawing options
    with-drawing-options
    medium-foreground medium-background medium-ink
    medium-transformation medium-clipping-region

    ;; Line style drawing options
    medium-line-style line-style make-line-style
    line-style-units line-style-thickness line-style-scale-lines
    line-style-joint-shape line-style-cap-shape line-style-dashed
    line-style-dash-pattern line-style-initial-dash-phase
    *null-line-style*

    ;; Text style drawing options
    medium-text-style medium-default-text-style
    stream-current-text-style stream-default-text-style stream-merged-text-style
;;*    stream-merged-text-style-valid-p
    text-style make-text-style parse-text-style merge-text-styles
    intern-text-style ;; Obsolete.
    text-style-components text-style-family text-style-face text-style-size
;;*    text-style-fixed-width-p text-size
    text-style-mapping
    text-style-mapping-exists-p add-text-style-mapping standardize-text-style
    make-device-font-text-style *standard-character-set*
    *null-text-style* *default-text-style* *undefined-text-style*
    define-text-style-mappings diacritic-char-p char-character-set-and-index
    ;; Do we want to export these?
    define-text-face-class define-text-face define-text-face-added-mappings
    ;; --- And how about these?  The spec doesn't like them for some reason.
    text-style-height text-style-ascent text-style-descent string-width char-width

    ;; PAINTS --- Not yet in API list?
    +foreground+ +background+ +flipping-ink+
    color color-hue color-saturation color-value ;; --- ??
    make-color-rgb make-color-ihs make-gray-color
    color-rgb color-ihs

    ;; Output record protocol
    fundamental-output-record output-record-parent replay
    output-record-hit-detection-extent output-record-refined-sensitivity-test
    add-output-record-element delete-output-record-element clear-output-record
    erase-output-record
    map-over-output-record-elements output-record-elements
    
    ;; Output recording protocol
    output-recording-mixin			;--- Unclear this should be exported
    output-recording-stream-p stream-record-p stream-draw-p
    output-recording-stream-output-record output-recording-stream-replay
    with-output-recording-options with-output-to-output-record with-new-output-record
    
    ;; output record classes
    linear-output-record
    output-record-mixin 
    output-record-element-mixin
    text-output-record-element
    graphic-output-record-element

    ;; Advanced formatting functions
    formatting-table formatting-row formatting-cell formatting-item-list format-items
    format-graph-from-root adjust-table-cells
    surrounding-output-with-border

    ;; Incremental redisplay
    redisplay updating-output inferior-output-record-changed output-record-fixed-position
    output-record-unique-id match-output-records find-inferior-output-record
    decache-inferior-output-record recompute-contents-ok
    cache-output-record find-cached-output-record
    new-output-records compute-differences propagate-inferior-output-record-changes-p
    propagate-output-record-changes stream-redisplayable-p incremental-redisplay
    stream-redisplaying-p
    
    ;; Extended input protocol
    basic-input-stream basic-extended-input-protocol
   ;; Covered above.  Mac doesn't allow duplicates. -RWK
    ;extended-input-stream-p
    stream-input-buffer stream-pointers stream-primary-pointer
    stream-read-gesture stream-unread-gesture stream-input-wait 
    stream-pointer-position* stream-set-pointer-position*
;;*   stream-pointer-position
;;*    gesture-processing-handler
    *input-wait-handler* *input-wait-test* *pointer-button-press-handler*
    
    ;; Input context, context-dependent input
    presentation-type-specifier-p presentation-subtypep define-presentation-type presentation
    presentation-type-name
    with-type-decoded
    presentation-type presentation-object present present-to-string with-input-context
    presentation-p presentation-single-box
    describe-presentation-type
    input-context-button-press-handler accept read-token
    with-blip-characters with-activation-characters
    blip-character-p activation-character-p
    complete-input completing-from-suggestions define-presentation-translator
    remove-presentation-translator
    call-presentation-menu
    pointer-documentation-handler set-pointer-documentation
;;*    no-translation   ; what is this?
     
    ;; more ui symbols
    define-gesture

    ;; Command processor symbols
    ;; --- TBS
    find-command-table define-command command-table define-command-table *command-table*
    add-command-to-command-table remove-command-from-command-table
    find-command-in-command-table find-command-name-in-command-table
    define-menu-group add-menu-group-entry remove-menu-group-entry
    command-enabled-p disable-command enable-command
    frame-read-remaining-arguments-for-partial-command
    process-keyword-args

    menu-group menu-group-element

    ;; Application frames
    *default-frame-manager* find-frame-manager with-frame-manager
    define-application-frame with-frame with-frame-slots *frame*
    frame framep make-frame frame-manager frame-state 
    adopt-frame disown-frame
    frame-pane find-pane-for-frame find-named-pane-for-frame
    launch-frame
    start-frame stop-frame
    enable-frame disable-frame shrink-frame	
    reconfigure-frame client-setting reset-frame
    run-frame-top-level default-frame-top-level read-frame-command
    execute-frame-command
;;*    redisplay-frame
    display-command-menu notify-user pane-frame
    incremental-redisplay-display-function
    frame-props-mixin frame-prop

    define-frame-command

    ;; Panes
    ;; --- TBS

;;; not yet
;;;    ;; Toolkit
;;;    fundamental-gadget make-gadget gadget-owner gadget-port gadget-handle gadget-canonical-type
;;;    enable-gadget disable-gadget gadget-value fundamental-gadget-owner
;;;    gadget-enabled gadget-disabled gadget-activated gadget-deactivated
;;;    port-create-gadget port-enable-gadget port-disable-gadget port-process-gadget-event
;;;    port-gadget-value
;;;    ;; Gadget types?

    ;; Presentation types -- the ones which look like CL types are eventually
    ;; inherited from the CL package (except PATHNAME, which is special).

;;; The spec has these, but the implmenetation doesn't
;;;    t null boolean symbol keyword number complex real rational integer ratio float
;;;    character string pathname completion member member-sequence alist-member subset-completion
;;;    subset subset-sequence subset-alist sequence sequence-enumerated or and
;;;    token-or-type null-or-type type-or-string
;;;    command command-name command-or-form expression form

    ;; The real list
    boolean
    keyword number integer pathname string completion alist-member 
    command command-name command-or-form expression
    )

  #+Silica
  ;; The part of the Silica package which is in the 0.9 spec so far:
  (:export
    ;; Silica port protocol (from spec)
    *default-server-path* *server-path-defaults*
    make-port find-port port *ports* *default-port-type*
    find-graft
    destroy-port restart-port destroy-ports restart-ports

    ;; Silica sheet protocol
    make-sheet define-sheet-class sheet-region sheet-enabled-p
    sheet-parent sheet-children
    sheet-transformation sheet-input-contract sheet-output-contract
    sheet-input-contract-class sheet-output-contract-class
;;*    sheet-adult-contract sheet-youth-contract
    sheet-parent-part sheet-child-part
    enable-sheet disable-sheet adopt-child disown-child
    sheet-enabled sheet-disabled 
    sheet-enabled-children sheet-viewable-p
    fetch-delta-transformation fetch-native-transformation
    fetch-clipping-region fetch-native-clipping-region
    child-at-point* which-descendant children-in-region children-in-rectangle*
;;*    change-input-contract change-output-contract change-windowing-contract

    ;; Silica display medium protocol
    standard-output-contract
    sheet-medium using-display-medium repaint-sheet handle-repaint

    ;; Silica input protocol
    process-next-event distribute-device-event
    distribute-crossing-event			;--- Not in spec
    standard-event-distributor			;--- Why is this an external interface?
    standard-input-contract invoking-input-contract mute-input-contract ; --- Why are these?
    queue-event queue-input
    input-handler				;--- Ditto
    pointer-enter pointer-exit key-press key-release button-press button-release
    button-click button-click-click
    event event-key event-input-state event-time event-x event-y event-native-x event-native-y
    event-char event-keysym event-button event-direction event-sheet
    pointer-motion-event key-press-event key-release-event button-event
    button-press-event button-release-event pointer-enter-event pointer-exit-event
    button-click-event click-hold-event button-click-click-event

;;*    input-state
;    *mouse-left* *mouse-middle* *mouse-right*	;--- Should these be +mouse-XXX+ ?
    +pointer-left+ +pointer-middle+ +pointer-right+
    +hyper-key+ +super-key+ +meta-key+ +control-key+ +shift-key+
    shift-keysym control-keysym meta-keysym super-keysym hyper-keysym lock-keysym
    modifier-keysym
;;*    query-mouse with-mouse-grabbed *mouse-x* *mouse-y*	;--- *pointer-XXX* ???
;;*    *input-state*
    pointer-input-rectangle*)

  ;; Symbols from Windshield to export
  #+Silica
  (:export pane
	   pane-stream pane-scroller scroll-extent update-extent pane-viewport
	   mute-input-mixin to-frame-repainter-mixin 
	   layout-mixin echoing-layout-mixin 
	   viewport-layout-mixin transforming-echoing-layout-mixin
	   space-req-mixin space-req-cache-mixin space-space-req-mixin
	   pane-background-mixin
	   dashboard-windowing-contract xform-pane
	   extended-stream-pane make-clim-pane make-clim-interactor
	   basic-clim-pane
	   leaf-pane
	   allocate-space compose-space
	   ;; Catch tags
	   frame-exit resynchronize
	   *pane* +fill+ scroll-home
	   tabling horizontally vertically
	   spacing vspacing hspacing
	   scrolling vscrolling hscrolling
	   bordering labelling restraining labelled
	   )

  ;; Symbols from CLIM-INTERNALS to export
  (:export process-completions)

  ;; Symbols experimentally found to need exporting
  (:export
    color-blue-value
    color-green-value
    color-red-value
    command-table-name
    realize-pane
    make-pane
    medium-sheet
    select-pane-class
    sheet-child
    using-clim-medium
    window-clear
    with-look-and-feel-realization

    replace-input
    rescanning-p
    input-not-of-required-type

    )

  ;; Symbols that used to be exported but were found to be missing!

  (:export invoke-command-parser-and-collect
    menu-read-remaining-arguments-for-partial-command
    menu-command-parser
    command-line-read-remaining-arguments-for-partial-command
    command-line-command-unparser
    command-line-command-parser
    frame-find-presentation frame-repaint-pane
    redisplay-frame-panes redisplay-frame-pane
    panes-need-redisplay pane-needs-redisplay
    pane-display-function pane-display-time
    clim-top-level
    build-command
    partial-command-p
    unsupplied-argument-p
    *unsupplied-argument*
    *partial-command-parser*
    *command-unparser*
    *command-parser*
    read-command
    dragging-output
    tracking-pointer
    menu-choose-from-drawer
    menu-choose
    item-list-output-record
    table-output-record
    row-output-record
    cell-output-record
    *default-within-generation-separation*
    *default-generation-separation*
    formatting-column
    define-presentation-to-command-translator
    with-input-editing
    input-position
    presentation-replace-input
    with-output-as-presentation
    with-end-of-line-action
    with-end-of-page-action
    with-presentation-type-arguments
    accepting-values
    suggest
    unread-gesture
    read-gesture
    beep)

  ;; old CLIM compatibility
  (:export

    entity-edges
    entity-size
    window-set-visibility
    window-visibility
    window-expose
    )

  ;; colors
  (:export

    +white+
    +black+
    +red+
    +blue+
    +green+
    +cyan+
    +magenta+
    +yellow+

;; Standard Grays

    +dim-gray+
    +gray+
    +light-gray+
    )

  ;; cursors
  (:export
    port-note-cursor-change
    note-cursor-change
    cursor-active
    cursor-state
    cursor-focus
    )

  )

