;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10; Package: USER; Lowercase: Yes -*-

(in-package #-ansi-90 "USER" #+ansi-90 "COMMON-LISP-USER")

"Copyright (c) 1991 by International Lisp Associates.  All rights reserved.

 Portions derived from CLIM 1.0 file SYS:CLIM;UTILS;PACKAGES.LISP:
   Copyright (c) 1990, 1991 Symbolics, Inc.  All rights reserved.
   Portions copyright (c) 1990, 1991 International Lisp Associates.  All rights reserved."

(clim-lisp:defpackage clim
  (:use	CLIM-LISP)

  #+(and ccl-2 ansi-90)
  (:shadowing-import-from CLIM-UTILS
    char=
    standard-char-p
    graphic-char-p
    alpha-char-p)

  #-ccl-2
  (:shadowing-import-from CLIM-UTILS
    defun
    flet labels
    defgeneric defmethod
    dynamic-extent
    #-excl non-dynamic-extent)

  #+(or Lucid excl)
  (:shadowing-import-from CLIM-UTILS
    with-slots)

  ;; Silica names
  (:export
    ;; Protocol classes
    transformation
    region
    port
    sheet
    graft
    medium
    line-style
    text-style  ;; --- device-font-text-style?
    design
    color
    opacity
    pattern
    stencil

    ;; Region classes
    region
    point			standard-point
    path
    line			standard-line
    polyline			standard-polyline
    elliptical-arc		standard-elliptical-arc
    area
    rectangle			standard-rectangle
    polygon			standard-polygon
    ellipse			standard-ellipse

    region-difference		standard-region-difference
    region-intersection		standard-region-intersection
    region-union		standard-region-union

    ;; Region accessors
    point-position* point-x point-y
    line-start-point line-start-point* line-end-point line-end-point*
    polyline-closed
    rectangle-edges*
    rectangle-min-point rectangle-min-x rectangle-min-y
    rectangle-max-point rectangle-max-x rectangle-max-y
    rectangle-size rectangle-width rectangle-height
    polygon-points
    ellipse-center-point ellipse-center-point*
    ellipse-start-angle ellipse-end-angle ellipse-radii

    ;; Region constructors
    make-point
    make-line			make-line*
    make-polyline		make-polyline*
    make-elliptical-arc		make-elliptical-arc*
    make-rectangle		make-rectangle*
    make-polygon		make-polygon*
    make-ellipse		make-ellipse*

    ;; Region arithmetic functions
    region-contains-point*-p
    region-contains-region-p
    region-difference
    regions-equal				;--- Is this REGION-EQUAL?
    region-intersection
    region-intersects-region-p
    region-intersects-rectangle*-p
    region-union

    ;; Transformation functions
    compose-rotation-transformation		;--- Is this name settled?
    compose-scaling-transformation		;--- Is this name settled?
    compose-transformations
    compose-translation-transformation		;--- Is this name settled?
    even-scaling-transformation-p
    identity-transformation-p
    invert-transformation
    invertible-transformation-p
    make-3-point-transformation
    make-3-point-transformation*
    make-reflection-transformation
    make-reflection-transformation*
    make-rotation-transformation
    make-rotation-transformation*
    make-scaling-transformation
    make-scaling-transformation*
    make-transformation
    make-translation-transformation
    rectilinear-transformation-p
    reflection-transformation-p
    rigid-transformation-p
    scaling-transformation-p
    transform-distance				;--- Is this TRANSFORM-DISTANCE*?
    transform-point*
    transform-rectangle*
    transform-region
    transformations-equal			;--- Is this TRANSFORMATION-EQUAL?
    translation-transformation-p
    untransform-distance			;--- Is this UNTRANSFORM-DISTANCE*?
    untransform-point*
    untransform-rectangle*
    untransform-region

    ;; Transformation condition names
    singular-transformation
    transformation-underspecified
    
    ;; Transformation and region constant names
    +identity-transformation+
    +nowhere+
    +everywhere+

    ;; Bounding rectangle functions
    make-bounding-rectangle
    bounding-rectangle
    bounding-rectangle*
    bounding-rectangle-set-edges
    with-bounding-rectangle			;--- Is this WITH-BOUNDING-RECTANGLE*
    bounding-rectangle-min-x
    bounding-rectangle-min-y
    bounding-rectangle-max-x
    bounding-rectangle-max-y
    bounding-rectangle-position
    bounding-rectangle-position*
    bounding-rectangle-set-position*
    bounding-rectangle-shift-position
    bounding-rectangle-position-difference
    bounding-rectangle-position-equal
    bounding-rectangle-edges-equal
    bounding-rectangle-width
    bounding-rectangle-height
    bounding-rectangle-size
    bounding-rectangle-set-size
    bounding-rectangle-size-equal
    bounding-rectangle-center
    bounding-rectangle-center*
;;;--- Unsure about the next six
    bounding-rectangle-ltrb
    with-bounding-rectangle-ltrb
    bounding-rectangle-left
    bounding-rectangle-top
    bounding-rectangle-right
    bounding-rectangle-bottom
;;;--- end of unsure ones.
    position-difference*

    ;; Some random geometry
    pi-single-float
    2pi
    pi/2
    radians->degrees
    degrees->radians

    ;; Port functions
    find-port
    port-server-path
    locking-port
    port-name
    port-type
    port-get
    port-props
    port-cursor
    port-event-distributor
    port-keyboard-input-focus
    ;; Port variables
    *ports*					;--- Export?
    *default-server-path*
    
    ;; Sheet genealogy functions
    sheet-parent
    sheet-children
    sheet-child
    adopt-child
    disown-child
    sheet-siblings
    sheet-enabled-children
    sheet-ancestor-p
    raise-sheet
    bury-sheet
    reorder-sheets
    sheet-enabled-p
    enable-sheet
    disable-sheet
    sheet-viewable-p
    occluding-sheets
    sheet-leaf-mixin

    ;; Sheet genealogy classes
    sheet-single-child-mixin
    sheet-multiple-child-mixin

    ;; Sheet geometry functions
    sheet-transformation
    sheet-region
    map-child-point*-to-parent
    map-parent-point*-to-child
    map-child-bounding-rectangle*-to-parent
    map-parent-bounding-rectangle*-to-child
    child-containing-point
    child-containing-point*
    children-in-region
    children-in-rectangle*
    delta-transformation
    allocated-region

    ;; Sheet geometry classes
    sheet-identity-transformation-mixin
    sheet-translation-mixin
    sheet-inverting-transformation-mixin
    sheet-transformation-mixin

    ;; Mirrored sheet protocol functions
    sheet-native-region
    sheet-native-transformation
    sheet-mirrored-ancestor
    sheet-mirror
    realize-mirror
    enable-mirror
    disable-mirror
    raise-mirror
    bury-mirror
    ;; --- Mirror settings functions?

    ;; Sheet creation functions
    make-sheet
    make-standard-sheet

    ;; Input protocol
    process-next-event
    port-keyboard-input-focus
    distribute-event
    dispatch-event
    queue-event
    handle-event
    event-read
    event-read-no-hang
    event-peek
    event-unread
    event-listen

    ;; Pointer documentation handler functions
    pointer-documentation-handler
    default-pointer-documentation-handler
    pointer-documentation
    
    ;; Event classes
    event
    device-event
    key-event
    key-press-event
    key-release-event
    pointer-event
    button-event
    button-press-event
    button-release-event
    click-event
    click-hold-event
    click-click-event
    pointer-motion-or-boundary-event
    pointer-motion-event
    pointer-enter-event
    pointer-exit-event
    window-event
    configuration-event
    repaint-event

    ;; Event functions
    event-type
    event-modifier-key-state
    event-time
    event-x
    event-y
    event-native-x
    event-native-y
    event-button
    event-direction
    event-pointer
    event-key-name
    event-character
    event-native-region
    event-mirrored-sheet
    key-modifier-state-match-p

    ;; state mask constant names
    +left-button+
    +middle-button+
    +right-button+
    +hyper-key+
    +super-key+
    +meta-key+
    +control-key+
    +shift-key+

    ;; Old 0.9 names, still in the implementation.
    +pointer-left+ +pointer-middle+ +pointer-right+
    shift-keysym control-keysym meta-keysym super-keysym
    hyper-keysym lock-keysym modifier-keysym

    ;; Input protocol class names
    standard-sheet-input-mixin
    immediate-sheet-input-mixin
    delegate-sheet-input-mixin

    delegate-sheet-delegate

    ;; Output protocol functions
    current-ink
    current-transformation
    current-clipping-region
    current-line-style
    current-text-style
    default-text-style
    merged-text-style
    sheet-foreground
    sheet-background

    with-drawing-options
    with-text-style

    ;; The graphics functions
    draw-point	    draw-point*
    draw-points	    draw-points*
    draw-line	    draw-line*
    draw-lines	    draw-lines*
    draw-rectangle  draw-rectangle*
    draw-polygon    draw-polygon*
    draw-circle	    draw-circle*
    draw-ellipse    draw-ellipse*
    draw-text	    draw-text*
    draw-design

    ;; Line style functions
    make-line-style
    line-style-unit
    line-style-thickness
    line-style-joint-shape
    line-style-cap-shape
    line-style-dashes
    line-style-initial-dash-phase

    make-contrasting-dash-patterns

    ;; Text style functions
    make-text-style
    make-device-font-text-style
    text-style-family
    text-style-face
    text-style-size
    parse-text-style
    merge-text-styles
    text-style-mapping
    text-style-ascent
    text-style-descent
    text-style-height

    ;; Ink functions
    make-color-rgb
    make-color-ihs
    make-gray-color
    color-rgb
    color-ihs

    make-contrasting-inks
    make-flipping-ink
    make-design-from-output-record
    
    make-opacity
    opacity-value

    make-pattern
    pattern-width pattern-height

    make-stencil
    stencil-array

    compose-in
    compose-out
    compose-over

    ;; Ink constant names
    +foreground+
    +background+
    +flipping-ink+
    +red+
    +yellow+
    +green+
    +cyan+
    +blue+
    +magenta+
    +black+
    +white+
    +gray+
    ;; --- percent grays?

    ;; Repaint protocol functions
    dispatch-repaint
    queue-repaint
    handle-repaint
    repaint-sheet

    ;; Repaint protocol classes
    standard-repainting-mixin
    immediate-repainting-mixin
    mute-repainting-mixin)
  ;; CLIM functions  TBS
  (:export)
  )

;;; The old CLIM-SHARED package, renamed for CLIM 2.0
(clim-lisp:defpackage clim-port
  ;; old stuff here, too
  (:use CLIM-LISP CLIM-UTILS)

  (:use CLIM)





  ;; --- until all old references are eradicated.
  (:nicknames "CLIM-SHARED")

  (:export
    port-match
    mirror->sheet
    port-force-output
    port-finish-output
    port-ring-bell
    restart-port
    destroy-port
    restart-input
    destroy-input
    port-event-wait
    distribute-event
    port-event-sheet
    display-medium-type
    pixmap-medium-type
    canonicalize-server-path
    port-event-process
    perform-with-port
    perform-do-grafts
    perform-locking-port
    invalidate-gesture-spec-cache
    register-watcher
    unregister-watcher
    reset-watcher
    validate-medium
    medium-force-output
    medium-finish-output
    medium-ring-bell
    scan-string-for-writing
    scan-character-for-writing
    glyph-for-character

    draw-point*-internal
    draw-points*-internal
    draw-line*-internal
    draw-lines*-internal
    draw-rectangle*-internal
    draw-polygon*-internal
    draw-circle*-internal
    draw-ellipse*-internal
    draw-text*-internal
    draw-design-internal			;--- ??? Name

    ;; Discovered while merging CLIM 1.0 and CLIM 0.9 UTILS modules
    *server-path-defaults*

    )

  ;; ---- Yank in a block of text from old CLIM-Shared

  ;; Symbols from CLIM-UTILS:
  (:export defprotocol defrole generate-trampolines)
  
  ;; No symbols from CLIM-LISP to be shared

  ;; CLIM-CONDITIONS symbols
  (:export INPUT-NOT-OF-REQUIRED-TYPE-STRING)
  
  ;; Silica symbols to share
  #+Silica
  (:export
    basic-port basic-medium medium display-medium pixmap-medium make-pixmap
    pixmap-format pixmap-height pixmap-width pixmap-ncolors pixmap-colors
    pixmap-data pixmap-depth
    color-count color-table
    medium-merged-text-style-valid define-text-style-mappings-load-time
    get-transformation
    careful-transform-region careful-transform-rectangle* careful-untransform-rectangle*
    with-new-sheet-transform default-output-sheet saving-graphics-transform
    debug-port
    genera-port x-port ;; Everybody knows the names of all the ports...
    ;; These SHADEs are probably all obsolete
    shade *black* *extra-dark-gray* *dark-gray* *light-dark-gray* *gray*
    *dark-light-gray* *light-gray* *extra-light-gray* *white* *default-shade*
    shade-to-color 

    ;; --- Cursor accessors: check these names out
    width height
    cursor make-cursor *cursors* ;; -- We need FIND-CURSOR-NAMED, no?
    
    ;; These were not exported in the old SILICA-PKG:  x-offset y-offset mask image
    ;; From GRAPHICS-DEFINITIONS
    find-graphics-function find-graphics-spread-function define-graphics-function-method
    gf-unspread-function-name gf-spread-function-name gf-type gf-method-function-name
    gf-unspread-lambda-list gf-method-lambda-list gf-spread-arguments
    gf-method-argument-list define-graphics-function define-graphics-function-compile-time
    ;; From GRAPHICS-FUNCTIONS: Ramana depends on these symbols being EQ in all ports
    draw-rectangle-with-rectangle
    point-sequence coordinate-sequence
    from-point from-x from-y to-point to-x to-y closed filled x1 y1 x2 y2
    center-point center-x center-y radius-1-dx radius-1-dy radius-2-dx radius-2-dy
    radius start-angle end-angle
    string-or-char start end align-x align-y toward-point transform-glyphs    
    ;; From SILICA-SHEET --- Someone besides RSL should check to see if these belong here.
    sheet sheetp define-sheet-class
    sheet-force-output walk-tree walk-sheets count-sheets
    contract sheet-contract output-contract input-contract
    relationship-contract
    sheet-region-fresh sheet-transformation-fresh
    sheet-rectangle-translation-mixin
    
    ;; From SILICA-EVENT --- Someone check these
    event-queue make-event-queue get-next-event peek-event done-with-event
    standard-delivery queue-event allocate-event free-event
    repaint-event
    device-event event-input-state
    pointer-motion-event key-press-event key-release-event button-event
    button-press-event button-release-event pointer-enter-event pointer-exit-event
    button-click-event click-hold-event button-click-click-event
   +pointer-left-bit+ +pointer-middle-bit+ +pointer-right-bit+
   +hyper-key-bit+ +super-key-bit+ +meta-key-bit+
   +control-key-bit+ +shift-key-bit+ +n-shift-keys+
   +pointer-left+ +pointer-middle+ +pointer-right+
   +hyper-key+ +super-key+ +meta-key+ +control-key+ +shift-key+
   
   state->shift-mask 
   shift-code shift-code-shift shift-index shift-index-shift
   make-shift-mask
   parse-gesture-spec print-gesture-spec
   input-matches-gesture-spec-p fast-input-matches-gesture-spec-p
   gesture-case
   get-port-canonical-gesture-spec
   invalidate-gesture-spec-cache
   button-name shift-keysym  
   
    ;; From SILICA-WINDOW --- Someone check these
    windowing-part parent-part child-part
    fetch-mirrored-sheet sheet-siblings
    children-in-region children-in-rectangle* which-descendant
    enabled-slot-mixin
    permanently-enabled-mixin sheet-adopted sheet-disowned
    sheet-grafted sheet-ungrafted sheet-region-changed sheet-transformation-changed
    sheet-mirror sheet-mirror! mirror->sheet occluding-sheets
    native-transformation
    define-windowing-contract simple-parent-part standard-parent-part
    simple-child-part standard-child-part standard-windowing-contract
    ;; From SILICA-PORT --- 
    mirrored-sheet-mixin 
    port-server-path port-match find-port-type
    port-cursor event-process
    port-set-cursor-visibility
    %ncrstamp port-crstamp %ndtstamp port-dtstamp
    restart-input destroy-input port-force-output port-finish-output with-port
  
    realize-mirror destroy-mirror enable-mirror disable-mirror
    sheet-target-native-edges*
    sheet-actual-native-edges* set-sheet-actual-native-edges*
    mirror-origin mirror-inside-region*
    update-mirror-region mirror-region-updated
    sheet-native-transformation update-native-transformation
    mirror-region mirror-region*
    sheet-mirror-resource-id mirror-resource-id

    register-watcher unregister-watcher display-medium-type pixmap-medium-type
    do-with-port port-name
    port-event-wait
    graft graftp graft-origin graft-units
    graft-width-pixel graft-height-pixel graft-width-mm graft-height-mm
    graft-pixels-per-point
    ;; Names used as slot names as well as accessors above:
    origin units width-pixel height-pixel width-mm height-mm pixels-per-point
    to-graft-transformation-pixel to-graft-transformation-mm 
    ;; From RESOURCES --- 
    realize-pixmap unrealize-pixmap realize-shade realize-color screen-color
    ;; From SILICA-INPUT ---
    distributor port-event-distributor
    handle-clicks? distributor-keyboard-focus
    standard-event-distributor-part propagate-events?
    enable-keyboard-focus disable-keyboard-focus
    standard-cursor-support sheet-cursor poll-pointer
    queue-input pointer-motion
    dispatch-event-using-port-keys filter-port-event-keys

    ;; From SILICA-TRACK:
    with-pointer-grab do-with-pointer
    self-distributor-base-mixin
    ;; from SILICA-OUTPUT ---
    medium-force-output medium-finish-output
    ;; From SILICA-AUDIO ---
    beep whistle ring-bell
    ;; From SILICA-ENV, STANDARD: no symbols exported ---
    ;; From SILICA-CLG ---
    basic-clg-medium basic-clg-display-medium basic-clg-pixmap-medium
    with-saved-medium draw-text-rectangle draw-text-rectangle*
    
;;; --- Other symbols which apparently need to be exported for Silica:

    fit-region*-in-region*

    realize-graft raise-mirror bury-mirror	;; Method defined in X-PORT
    warp-cursor cut-buffer install-settings	;; X-WM
    install-mirror-settings			;; X-WM
    do-poll-pointer prompt-for-location		;; X-STDI
    prompt-for-region prompt-for-region-location;; X-STDI
    pixmap medium-pixmap cleanup-display-medium	;; X-MEDIUM
    device-clipping-region			;; X-MEDIUM
    available-cursors realize-cursor		;; X-TYPES
    install-port-cursor set-cursor-location	;; X-TYPES

    do-query-mouse mirror->sheet-table		;; GENERA-PORT
    validate-medium				;; GENERA-MEDIUM
    realize-text-style				;; GENERA-TYPES
    with-output-protection			;; GENERA-CLG

;;; --- Symbols used in PTK:
    trace-stamp keyboard-focus			;; Slot names used in SILICA-TRACKING-POINTER
    port-stamp validate-trace top-of-trace	;; called in SILICA-TRACKING-POINTER
    with-distributor				;; ...
    with-distributor-locked
    distributor-enabled
    
;;; --- printer-stream stuff
    printer-medium printer-stream close-printer-medium
    )

  ;; Windshield symbols to share
  #+Silica
  (:export
    ;; referred to by CLIM-SILICA-MENUS-STUFF
    change-space-req change-size move-frame
    menu-choice
    )

  (:export define-specializable-command)


  ;; Experimentally derived list:
  (:export
    *resynchronize-after-command*
    %ntstamp
    almost-white-p
    bordering
    command-name-for-command-in-command-table
    command-parser
    command-table-binary-searcher
    command-table-commands
    copy-ink
    copy-line-style
    device-transformation
    fill-event
    frame-find-menu-group
    frame-exit-frame frame-exit-internal
    insured-device-transformation
    line-style-scale-dashes
    make-%gray-stream
    menu-group-element-string
    menu-group-element-type
    menu-group-element-value
    menu-group-elements
    move-and-resize-sheet*
    move-sheet*
    pane-prop
    partial-command-p
    port-prop
    queue-repaint
    repaint-region
    reset-watcher
    resize-sheet*
    sheet-event-queue
    spacing
    state-match-p state-set
    *unsupplied-argument*
    valid-cp-lambda-list-keyword-p
    vscrolling
    write-command-argument-translators
    write-command-argument-translator-internal
    command-in-command-table-p
    map-over-command-table-inheritance
    port-default-pointer-documentation-handler)


  ;; CLIM-INTERNALS symbols to share
  (:export
    with-text-style-internal
    ;; Symbols shared between CLIM-STREAM and CLIM-INTERNALS
    draw-character-wrap-indicator
    with-output-recording-options-internal
    writable-character-p
    process-spacing-arg)

  ;; symbols that used to be exported by SILICA-PORT but weren't
  ;; already listed above.  How to trim this?
  (:export port-cprops
	   repaint-process
	   process-next-event dispatch-repaint
	   defclgop find-clgop
	   clgop-spread clgop-args clgop-args*
	   clgop-name clgop-name* clgop-keys
	   clgop-darg-specs substitute-clgop-args do-clgop-spreads
	   generate-clgop-letted-body with-processed-dargs ?
	   <- x y min-x min-y
	   max-x max-y  rectangle rectangle-set point-x point-y
	   nowhere everywhere
	   )

  ;; ---- End of the yank in a block of text from old CLIM-Shared

  ;; ---- Things that used to be shared or exported but aren't anymore
  ;; in the new RSL package setup.  Presumably this means that these things
  ;; aren't supposed to even BE in CLIM 2, but for now, they still exist.
  ;; These need to be resolved, either by removing them, or really exporting
  ;; them from the appropriate package.
  (:export
    *null-text-style* *default-text-style*

    )
)

;;; This is intended to replace the following packages:
;;;  SILICA, WINDSHIELD, CLIM-STREAM and CLIM-INTERNALS from 0.9.
;;;  CLIM in 1.0.

(clim-lisp:defpackage clim-internals
  (:use clim-lisp clim clim-port clim-utils)

  #+(and ccl-2 ansi-90)
  (:shadowing-import-from CLIM-UTILS
    char=
    standard-char-p
    graphic-char-p
    alpha-char-p)

  #-ccl-2
  (:shadowing-import-from CLIM-UTILS
    defun
    flet labels
    defgeneric defmethod
    dynamic-extent
    #-excl non-dynamic-extent)

  #+(or Lucid excl)
  (:shadowing-import-from CLIM-UTILS
    with-slots))
