;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10; Package: CL-USER; Lowercase: Yes -*-

(in-package #-(or ansi-90 Genera) "USER" #+(or ansi-90 Genera) "COMMON-LISP-USER")

"Copyright (c) 1991 by International Lisp Associates.  All rights reserved.

 Portions derived from CLIM 1.0 file SYS:CLIM;UTILS;PACKAGES.LISP:
   Copyright (c) 1990, 1991 Symbolics, Inc.  All rights reserved.
   Portions copyright (c) 1990, 1991 International Lisp Associates.  All rights reserved."

;;; We assume Allegro 4.0 or later,
;;;	      CLOE <Some version> or later
;;;	      Genera 8.0.1 or later,
;;;	      Lucid 4.0 or later,
;;;	      MCL 2.0b2 or later
;;; or some other Lisp vendor.

;;; We assume that PCL is mutually exclusive with any of the versions listed
;;; above, and no longer have any conditionals of the form
;;;   #+(and <vendor> (not PCL))
;;; in the code.

;;; A number of MOP symbols are missing from Genera, and are commented out with
;;; semicolons rather than with #-Genera.  These are unlikely to have been
;;; implemented by any of the vendors, and CLIM doesn't use them anyway.

;;; Define the CLIM-LISP package, a package designed to mimic ANSI Common Lisp
;;; as closely as possible (including CLOS and the Gray stream proposal).
;;; Symbols from CLtL I which were deleted from the language by CLtL II have
;;; been removed from the export list; if we need them, we can export them from
;;; CLIM-UTILS.  These fall into three broad categories:
;;; 
;;; 1.  The extended character functions, e.g., CHAR-BITS and its relatives.
;;; 2.  The module facility: *MODULES*, PROVIDE, REQUIRE.
;;; 3.  Random: COMMON, COMMONP, COMPILER-LET.
;;;
;;; The first of these will be replaced with our own extended character system
;;; (which uses the CLtL I symbols in those implementations which still support
;;; them).  The second set we don't need on a portable basis; specific CLIM
;;; implementations may need to use them to load, e.g., CLX, but they know who
;;; they are and will take care of this themselves.  The third set we will not
;;; need at all.

;;; Still to come: a theory about what to do about implementations which export
;;; certain symbols but don't actually implement them, or sometimes they don't
;;; implement them the way we would like to use them.  For example, Genera
;;; exports DEFINE-DECLARATION and DYNAMIC-EXTENT from COMMON-LISP, but the
;;; former is not defined, and the latter doesn't do anything when it is used
;;; as a declaration.  Similarly, the function COMPILE-FILE-ENVIRONMENT-P under
;;; MCL works just fine for everything except 'COMPILE-FILE.

;;; Choose the right DEFPACKAGE symbol.
(#+(or ansi-90 Genera)			  defpackage
 #-(or ansi-90 Genera)			  clim-lisp::defpackage

	    CLIM-LISP				;; (defpackage CLIM-LISP ...)

 (:use COMMON-LISP)

 #+(and Allegro ANSI-90)
 (:use CLOS STREAM)				;Use CLOS and Gray stream package

 #-ansi-90
 (:shadowing-import-from #+(or Genera Cloe-Runtime)		CLOS-INTERNALS
			 #+PCL					PCL
			 #+(not (or Genera Cloe-Runtime PCL))	CLOS
   defstruct
   documentation
   setf)

 #-ansi-90
 (:import-from 
	       #+(or Genera Cloe-Runtime)			CLOS-INTERNALS
	       #+Lucid						CLOS
	       #+PCL						PCL
	       #+(not (or Genera Cloe-Runtime Lucid PCL))	CLOS

   add-dependent
   add-direct-method
   add-direct-subclass
   add-method
   allocate-instance
   built-in-class
   call-method
   call-next-method
   change-class
   class
   class-default-initargs
   class-direct-default-initargs
   class-direct-slots
   class-direct-subclasses
   class-direct-superclasses
   class-finalized-p
   class-name
   class-of
   class-precedence-list
   class-prototype
   class-slots
   #+PCL classp
   compute-applicable-methods
;; compute-applicable-methods-using-classes	; Not in Genera?
   compute-class-precedence-list
   compute-discriminating-function
   compute-effective-method
   compute-effective-slot-definition
   compute-slots
   defclass
   defgeneric
   define-method-combination
   defmethod
   direct-slot-definition-class
   ensure-class
   ensure-class-using-class
   ensure-generic-function
   ensure-generic-function-using-class
;; extract-lambda-list				; Not in Genera?
;; extract-specializer-names			; Not in Genera?
   finalize-inheritance
   find-class
   find-method
   find-method-combination
   funcallable-standard-class
   function-keywords
   generic-flet
   generic-function
   generic-function-argument-precedence-order
   generic-function-declarations
   generic-function-initial-methods
   generic-function-lambda-list
   generic-function-method-class
   generic-function-method-combination
   generic-function-methods
   generic-function-name
   generic-labels
   initialize-instance
   invalid-method-error
   make-instance
   make-instances-obsolete
   make-load-form
   make-load-form-saving-slots
   make-method					;--- This is apparently gone from CLtL&MOP.
   make-method-lambda
   map-dependents
   method
   method-combination
   method-combination-error
;; method-combination-name			; Not in Genera?
   method-combination-options
;; method-combination-order			; Not in Genera?
;; method-combination-operator			; Not in Genera?
;; method-combination-identity-with-one-argument; Not in Genera?
   method-function
   method-generic-function
   method-lambda-list
   method-qualifiers
   method-slot-name
   method-specializers
   next-method-p
   no-applicable-method
   no-next-method
   print-object
   reinitialize-instance
   remove-dependent
   remove-direct-method
   remove-direct-subclass
   remove-method
   set-funcallable-instance-function
   shared-initialize
   slot-boundp
   slot-boundp-using-class
   slot-definition-allocation
   slot-definition-initargs
   slot-definition-initform
   slot-definition-initfunction
   slot-definition-location
   slot-definition-name
   slot-definition-readers
   slot-definition-type
   slot-definition-writers
   slot-exists-p
   slot-exists-p-using-class
   slot-makunbound
   slot-makunbound-using-class
   slot-missing
   slot-unbound
   slot-value
   slot-value-using-class
   specializer-direct-generic-functions
   specializer-direct-methods
   standard
   standard-class
   standard-generic-function
   standard-method
   standard-object
   structure-class
   structure-object
   symbol-macrolet
   update-dependent
   update-instance-for-different-class
   update-instance-for-redefined-class
   validate-generic-function-class-change
   validate-metaclass-change
   validate-superclass
   with-accessors
   with-added-methods
   with-slots)

 #+ccl-2
 (:import-from ccl
   class-direct-subclasses
   class-direct-superclasses
   class-precedence-list
   class-prototype
   class)

 #-(or ansi-90 Genera)
 (:shadowing-import-from #+lcl4.0 LUCID-COMMON-LISP
			 #-(or lcl4.0) |No-Such-Package|
   *break-on-signals*				;Conditions v18
   *debugger-hook*				;Conditions v18
   abort					;Conditions v18
   arithmetic-error-operands			;Conditions v18
   arithmetic-error-operation			;Conditions v18
   arithmetic-error				;Conditions v18
   assert					;Conditions v18 (supersedes CLtL)
   break					;Conditions v18 (supersedes CLtL)
   ccase					;Conditions v18 (supersedes CLtL)
   cell-error					;Conditions v18
   cell-error-name				;Conditions v18
   cerror					;Conditions v18 (supersedes CLtL)
   check-type					;Conditions v18 (supersedes CLtL)
   compute-restarts				;Conditions v18
   condition					;Conditions v18
   continue					;Conditions v18
   control-error				;Conditions v18
   ctypecase					;Conditions v18 (supersedes CLtL)
   #-Lucid define-condition			;Conditions v18
   division-by-zero				;Conditions v18
   ecase					;Conditions v18 (supersedes CLtL)
   end-of-file					;Conditions v18
   error					;Conditions v18 (supersedes CLtL)
   etypecase					;Conditions v18 (supersedes CLtL)
   file-error-pathname				;Conditions v18
   file-error					;Conditions v18
   find-restart					;Conditions v18
   floating-point-inexact			;Issue FLOATING-POINT-CONDITION-NAMES
   floating-point-invalid-operation		;Issue FLOATING-POINT-CONDITION-NAMES
   floating-point-overflow			;Conditions v18
   floating-point-underflow			;Conditions v18
   handler-bind					;Conditions v18
   handler-case					;Conditions v18
   ignore-errors				;Conditions v18
   invoke-debugger				;Conditions v18
   invoke-restart-interactively			;Conditions v18
   invoke-restart				;Conditions v18
   make-condition				;Conditions v18
   muffle-warning				;Conditions v18
   package-error-package			;Conditions v18
   package-error				;Conditions v18
   parse-error					;Issue READER-ERROR
   print-not-readable-object			;Issue DATA-IO
   print-not-readable				;Issue DATA-IO
   program-error				;Conditions v18
   restart-bind					;Conditions v18
   restart-case					;Conditions v18
   restart-name					;Conditions v18
   restart					;Conditions v18
   serious-condition				;Conditions v18
   signal					;Conditions v18
   simple-condition-format-arguments		;Conditions v18
   #-ansi-90 simple-condition-format-string
   #+ansi-90 simple-condition-format-control
   simple-condition				;Conditions v18
   simple-error					;Conditions v18
   simple-type-error				;Conditions v18
   simple-warning				;Conditions v18
   storage-condition				;Conditions v18
   store-value					;Conditions v18
   stream-error-stream				;Conditions v18
   stream-error					;Conditions v18
   style-warning				;Issue COMPILER-DIAGNOSTICS
   type-error-datum				;Conditions v18
   type-error-expected-type			;Conditions v18
   type-error					;Conditions v18
   unbound-slot-instance			;Issue UNDEFINED-VARIABLES-AND-FUNCTIONS
   unbound-slot					;Issue UNDEFINED-VARIABLES-AND-FUNCTIONS
   unbound-variable				;Conditions v18
   undefined-function				;Conditions v18
   use-value					;Conditions v18
   warning					;Conditions v18
   warn						;Conditions v18 (supersedes CLtL)
   with-simple-restart)				;Conditions v18

 #+Lucid (:shadow define-condition)

 #+(or Genera CLOE-Runtime)
 (:import-from CLOS-INTERNALS
   compile-file-environment-p)

 #+Cloe-Runtime
 (:import-from CLOE
   with-standard-io-syntax)

 #+Cloe-Runtime
 (:import-from SYSTEM
  stream-read-char
  stream-unread-char
  stream-read-char-no-hang
  stream-peek-char
  stream-listen
  stream-read-line
  stream-clear-input

  stream-write-char
  stream-line-column
  stream-start-line-p
  stream-write-string
  stream-terpri
  stream-fresh-line
  stream-finish-output
  stream-force-output
  stream-clear-output
  stream-advance-to-column

  stream-read-byte
  stream-write-byte)

 #+LCL4.0
 (:import-from LUCID-COMMON-LISP
   dynamic-extent)

 #+(and excl ANSI-90)
 (:import-from EXCL
   dynamic-extent)

 ;; Stream Proposal -- Classes and class predicates.
 #-CLIM-uses-Lisp-stream-classes
 (:shadow
   ;; Class names
   fundamental-stream
   fundamental-input-stream
   fundamental-output-stream
   fundamental-character-stream
   fundamental-binary-stream
   fundamental-character-input-stream
   fundamental-character-output-stream
   fundamental-binary-input-stream
   fundamental-binary-output-stream

   ;; Function names
   input-stream-p
   output-stream-p
   open-stream-p
   streamp)

 ;; You can't define a presentation type PATHNAME on the existing
 ;; type PATHNAME in Allegro (and MCL?) 'cause the Lisp PATHNAME
 ;; type is a structure not a CLOS class.  So for now, shadow
 ;; the real PATHNAME type until Symbolics fixes the presentation
 ;; type mechanism.
#+excl
 (:shadow pathname)
 
 ;; --- Removed: PATHNAME and TRUENAME: We don't care if they don't work
 ;; --- on CLIM streams.
 #-CLIM-uses-Lisp-stream-functions
 (:shadow
   ;; CL stream input functions
   read-byte
   read-char
   unread-char
   read-char-no-hang
   peek-char
   listen
   read-line
   clear-input
   ;; CL stream output functions
   write-byte
   write-char
   write-string
   terpri
   fresh-line
   force-output
   finish-output
   clear-output
   format
   ;; Miscellaneous CL stream functions and macros
   stream-element-type
   close
   with-open-stream)

 ;; Import these symbols so that we can define methods for them.
 #+ccl-2
 (:import-from CCL
  stream-force-output
  stream-clear-input
  stream-fresh-line
  stream-listen)

 ;; --- In CCL-2 and Genera, CLOSE is not a generic function.  We will
 ;; supply the rewritten CLOSE function in the file cl-stream-classes.lisp,
 ;; although strictly speaking that's a modularity violation.
 #+(or CCL-2 Genera)
 (:shadow close with-open-stream)

 ;; --- In Genera (and maybe others), STREAM-ELEMENT-TYPE is not Generic.
 ;; Do the same kludge with shadowing.
 #+Genera
 (:shadow stream-element-type)

 (:export
   ;; ANSI Common Lisp
   *print-readably*
   *read-eval*
   array-displacement
   augment-environment
   base-char
   base-string
   broadcast-stream
   broadcast-stream-streams
   compile-file-environment-p
   *compile-file-pathname*
   compile-file-pathname
   *compile-file-truename*
   *compile-print*
   compiler-macro
   compiler-macroexpand
   compiler-macroexpand-1
   compiler-macro-function
   *compile-verbose*
   complement
   concatenated-stream
   concatenated-stream-streams
   constantly
   copy-pprint-dispatch
   copy-structure
   debug
   declaration-information
   define-compiler-macro
   define-declaration
   ;; define-setf-expander  
   defpackage
   delete-package
   destructuring-bind
   dynamic-extent
   echo-stream
   echo-stream-input-stream
   echo-stream-output-stream
   ;encapsulated
   enclose
   extended-char
   fdefinition
   file-stream
   file-string-length
   formatter
   function-information
   function-lambda-expression
   *gensym-counter*
   ;; get-setf-expansion
   hash-table-rehash-size
   hash-table-rehash-threshold
   hash-table-size
   hash-table-test
   ignorable
   load-logical-pathname-translations
   *load-pathname*
   *load-print*
   load-time-value
   *load-truename*
   logical-pathname
   logical-pathname-translations
   loop-finish
   map-into
   nth-value
   pathname-match-p
   pprint-dispatch
   pprint-exit-if-list-exhausted
   pprint-fill
   pprint-indent
   pprint-linear
   pprint-logical-block
   pprint-newline
   pprint-pop
   pprint-tab
   pprint-tabular
   *print-lines*
   *print-miser-width*
   *print-pprint-dispatch*
   *print-right-margin*
   print-unreadable-object
   readtable-case
   real
   realp
   row-major-aref
   set-pprint-dispatch
   simple-base-string
   ;; special-operator-p
   stream-external-format
   string-stream
   synonym-stream
   synonym-stream-symbol
   translate-logical-pathname
   translate-pathname
   two-way-stream
   two-way-stream-input-stream
   two-way-stream-output-stream
   upgraded-array-element-type
   upgraded-complex-part-type
   variable-information
   wild-pathname-p
   with-compilation-unit
   with-condition-restarts
   with-hash-table-iterator
   with-package-iterator
   with-standard-io-syntax

   ;; Condition system
   *break-on-signals*				;Conditions v18
   *debugger-hook*				;Conditions v18
   abort					;Conditions v18
   arithmetic-error-operands			;Conditions v18
   arithmetic-error-operation			;Conditions v18
   arithmetic-error				;Conditions v18
   cell-error-name				;Conditions v18
   cell-error					;Conditions v18
   compute-restarts				;Conditions v18
   condition					;Conditions v18
   continue					;Conditions v18
   control-error				;Conditions v18
   define-condition				;Conditions v18
   division-by-zero				;Conditions v18
   end-of-file					;Conditions v18
   file-error-pathname				;Conditions v18
   file-error					;Conditions v18
   find-restart					;Conditions v18
   floating-point-inexact			;Issue FLOATING-POINT-CONDITION-NAMES
   floating-point-invalid-operation		;Issue FLOATING-POINT-CONDITION-NAMES
   floating-point-overflow			;Conditions v18
   floating-point-underflow			;Conditions v18
   handler-bind					;Conditions v18
   handler-case					;Conditions v18
   ignore-errors				;Conditions v18
   invoke-debugger				;Conditions v18
   invoke-restart-interactively			;Conditions v18
   invoke-restart				;Conditions v18
   make-condition				;Conditions v18
   muffle-warning				;Conditions v18
   package-error-package			;Conditions v18
   package-error				;Conditions v18
   parse-error					;Issue READER-ERROR
   print-not-readable-object			;Issue DATA-IO
   print-not-readable				;Issue DATA-IO
   program-error				;Conditions v18
   reader-error
   restart-bind					;Conditions v18
   restart-case					;Conditions v18
   restart-name					;Conditions v18
   restart					;Conditions v18
   serious-condition				;Conditions v18
   signal					;Conditions v18
   simple-condition-format-arguments		;Conditions v18
   simple-condition-format-control
   simple-condition				;Conditions v18
   simple-error					;Conditions v18
   simple-type-error				;Conditions v18
   simple-warning				;Conditions v18
   storage-condition				;Conditions v18
   store-value					;Conditions v18
   stream-error-stream				;Conditions v18
   stream-error					;Conditions v18
   style-warning				;Issue COMPILER-DIAGNOSTICS
   type-error-datum				;Conditions v18
   type-error-expected-type			;Conditions v18
   type-error					;Conditions v18
   unbound-slot-instance			;Issue UNDEFINED-VARIABLES-AND-FUNCTIONS
   unbound-slot					;Issue UNDEFINED-VARIABLES-AND-FUNCTIONS
   unbound-variable				;Conditions v18
   undefined-function				;Conditions v18
   use-value					;Conditions v18
   warning					;Conditions v18
   with-simple-restart				;Conditions v18

   ;; Stream Proposal
   fundamental-stream
   fundamental-input-stream
   fundamental-output-stream
   fundamental-character-stream
   fundamental-binary-stream
   fundamental-character-input-stream
   fundamental-character-output-stream
   fundamental-binary-input-stream
   fundamental-binary-output-stream

   interactive-stream-p

   stream-read-char
   stream-unread-char
   stream-read-char-no-hang
   stream-peek-char
   stream-listen
   stream-read-line
   stream-clear-input

   stream-write-char
   stream-line-column
   stream-start-line-p
   stream-write-string
   stream-terpri
   stream-fresh-line
   stream-finish-output
   stream-force-output
   stream-clear-output
   stream-advance-to-column

   stream-read-byte
   stream-write-byte

   ;; CLOS Chapters 2 and 3
   add-dependent
   add-direct-method
   add-direct-subclass
   add-method
   allocate-instance
   built-in-class
   call-method
   call-next-method
   change-class
   class
   class-default-initargs
   class-direct-default-initargs
   class-direct-slots
   class-direct-subclasses
   class-direct-superclasses
   class-finalized-p
   class-name
   class-of
   class-precedence-list
   class-prototype
   class-slots
   #+PCL classp
   compute-applicable-methods
;; compute-applicable-methods-using-classes	; Not in Genera?
   compute-class-precedence-list
   compute-discriminating-function
   compute-effective-method
   compute-effective-slot-definition
   compute-slots
   defclass
   defgeneric
   define-method-combination
   defmethod
   describe-object
   direct-slot-definition-class
   ensure-class
   ensure-class-using-class
   ensure-generic-function
   ensure-generic-function-using-class
;; extract-lambda-list				; Not in Genera?
;; extract-specializer-names			; Not in Genera?
   finalize-inheritance
   find-class
   find-method
   find-method-combination
   funcallable-standard-class
   function-keywords
   generic-flet
   generic-function
   generic-function-argument-precedence-order
   generic-function-declarations
   generic-function-initial-methods
   generic-function-lambda-list
   generic-function-method-class
   generic-function-method-combination
   generic-function-methods
   generic-function-name
   generic-labels
   initialize-instance
   invalid-method-error
   make-instance
   make-instances-obsolete
   make-load-form
   make-load-form-saving-slots
   make-method					;--- This is apparently gone from CLtL&MOP.
   make-method-lambda
   map-dependents
   method
   method-combination
   method-combination-error
;; method-combination-name			; Not in Genera?
   method-combination-options
;; method-combination-order			; Not in Genera?
;; method-combination-operator			; Not in Genera?
;; method-combination-identity-with-one-argument; Not in Genera?
   method-function
   method-generic-function
   method-lambda-list
   method-qualifiers
   method-slot-name
   method-specializers
   next-method-p
   no-applicable-method
   no-next-method
   print-object
   reinitialize-instance
   remove-dependent
   remove-direct-method
   remove-direct-subclass
   remove-method
   set-funcallable-instance-function
   shared-initialize
   slot-boundp
   slot-boundp-using-class
   slot-definition-allocation
   slot-definition-initargs
   slot-definition-initform
   slot-definition-initfunction
   slot-definition-location
   slot-definition-name
   slot-definition-readers
   slot-definition-type
   slot-definition-writers
   slot-exists-p
   slot-exists-p-using-class
   slot-makunbound
   slot-makunbound-using-class
   slot-missing
   slot-unbound
   slot-value
   slot-value-using-class
   specializer-direct-generic-functions
   specializer-direct-methods
   standard
   standard-class
   standard-generic-function
   standard-method
   standard-object
   structure-class
   structure-object
   symbol-macrolet
   update-dependent
   update-instance-for-different-class
   update-instance-for-redefined-class
   validate-generic-function-class-change
   validate-metaclass-change
   validate-superclass
   with-accessors
   with-added-methods
   with-slots

   ;; CLtL
   &allow-other-keys
   &aux
   &body
   &environment
   &key
   &optional
   &rest
   &whole
   *
   **
   ***
;  #-ANSI-90 *break-on-warnings*
   *debug-io*
   *default-pathname-defaults*
   *error-output*
   *features*
   *load-verbose*
   *macroexpand-hook*
;  #-ANSI-90 *modules*
   *package*
   *print-array*
   *print-base*
   *print-case*
   *print-circle*
   *print-escape*
   *print-gensym*
   *print-length*
   *print-level*
   *print-pretty*
   *print-radix*
   *query-io*
   *random-state*
   *read-base*
   *read-default-float-format*
   *read-suppress*
   *readtable*
   *standard-input*
   *standard-output*
   *terminal-io*
   *trace-output*
   +
   ++
   +++
   -
   //
   ///
   /=
   /
   1+
   1-
   <
   <=
   =
   >
   >=
   abs
   acons
   acos
   acosh
   adjoin
   adjust-array
   adjustable-array-p
   alpha-char-p
   alphanumericp
   and
   append
   apply
   apropos
   apropos-list
   aref
   array-dimension
   array-dimension-limit
   array-dimensions
   array-element-type
   array-has-fill-pointer-p
   array-in-bounds-p
   array-rank-limit
   array-rank
   array-row-major-index
   array-total-size-limit
   array-total-size
   arrayp
   array
   ash
   asin
   asinh
   assert
   assoc-if
   assoc-if-not
   assoc
   atanh
   atan
   atom
   bignum
   bit-and bit-ior bit-xor bit-eqv bit-nand bit-nor
   bit-andc1 bit-andc2 bit-orc1 bit-orc2 bit-not
   bit-vector-p
   bit-vector
   bit
   block
   boole-clr boole-set boole-1 boole-2 boole-c1 boole-c2 boole-and boole-ior
   boole-xor boole-eqv boole-nand boole-nor boole-andc1 boole-andc2 boole-orc1 boole-orc2
   boole
   both-case-p
   boundp
   break
   butlast
   byte
   byte-position
   byte-size
   caaaar
   caaadr
   caaar
   caadar
   caaddr
   caadr
   caar
   cadaar
   cadadr
   cadar
   caddar
   cadddr
   caddr
   cadr
   call-arguments-limit
   car
   case
   catch
   ccase
   cdaaar
   cdaadr
   cdaar
   cdadar
   cdaddr
   cdadr
   cdar
   cddaar
   cddadr
   cddar
   cdddar
   cddddr
   cdddr
   cddr
   cdr
   ceiling
   cerror
;; #-ANSI-90 char-bit
;; #-ANSI-90 char-bits
;; #-ANSI-90 char-bits-limit
   char-code
   char-code-limit
;; #-ANSI-90 char-control-bit
   char-downcase
   char-equal
;; #-ANSI-90 char-font
;; #-ANSI-90 char-font-limit
   char-greaterp
;; #-ANSI-90 char-hyper-bit
   char-int
   char-lessp
;; #-ANSI-90 char-meta-bit
   char-name
   char-not-equal
   char-not-greaterp
   char-not-lessp
;; #-ANSI-90 char-super-bit
   char-upcase
   char/=
   char<
   char<=
   char=
   char>
   char>=
   character
   characterp
   char
   check-type
   cis
   clear-input
   clear-output
   close
   clrhash
   code-char
   coerce
;; #-ANSI-90 common
;; #-ANSI-90 commonp
   compilation-speed
   compile
   compile-file
   compiled-function-p
   compiled-function
;; #-ANSI-90 compiler-let
   complex
   complexp
   concatenate
   cond
   conjugate
   cons
   consp
   constantp
   copy-alist
   copy-list
   copy-readtable
   copy-seq
   copy-symbol
   copy-tree
   cos
   cosh
   count
   count-if
   count-if-not
   ctypecase
   decf
   declaim
   declaration
   declare
   decode-float
   decode-universal-time
   defconstant
   define-modify-macro
   define-setf-method			;; --- Will be replaced with DEFINE-SETF-EXPANSION
   defmacro
   defparameter
   defsetf
   defstruct
   deftype
   defun
   defvar
   delete-duplicates
   delete-file
   delete-if
   delete-if-not
   delete
   denominator
   deposit-field
   describe
   digit-char
   digit-char-p
   directory-namestring
   directory
   disassemble
   do
   do*
   do-all-symbols
   do-external-symbols
   do-symbols
   documentation
   dolist
   dotimes
   double-float-epsilon
   double-float-negative-epsilon
   double-float
   dpb
   dribble
   ecase
   ed
   eighth
   elt
   encode-universal-time
   endp
   enough-namestring
   eq
   eql
   equalp
   equal
   error
   etypecase
   eval
   eval-when
   evenp
   every
   exp
   export
   expt
   fboundp
   fceiling
   ffloor
   fifth
   file-author
   file-length
   file-namestring
   file-position
   file-write-date
   fill
   fill-pointer
   find
   find-all-symbols
   find-if
   find-if-not
   find-package
   find-symbol
   finish-output
   first
   fixnum
   flet
   float-digits
   float-precision
   float-radix
   float-sign
   floatp
   float
   floor
   fmakunbound
   force-output
   format
   fourth
   fresh-line
   fround
   ftruncate
   ftype
   funcall
   function
   functionp
   gcd
   gensym
   gentemp
   get-decoded-time
   get-dispatch-macro-character
   get-internal-real-time
   get-internal-run-time
   get-macro-character
   get-output-stream-string
   get-properties
   get-setf-method			;; --- Will be replaced with GET-SETF-EXPANSION
   get-setf-method-multiple-value	;; --- Ditto
   get-universal-time
   getf
   gethash
   get
   go
   graphic-char-p
   hash-table-count
   hash-table-p
   hash-table
   host-namestring
   identity
   if
   ignore
   imagpart
   import
   in-package
   incf
   inline
   input-stream-p
   inspect
;; #-ANSI-90 int-char
   integer-decode-float
   integer-length
   integerp
   integer
   internal-time-units-per-second
   intern
   intersection
   isqrt
   keywordp
   keyword
   labels
   lambda
   lambda-list-keywords
   lambda-parameters-limit
   last
   lcm
   ldb
   ldb-test
   ldiff
   least-negative-double-float
   least-negative-long-float
   least-negative-normalized-double-float
   least-negative-normalized-long-float
   least-negative-normalized-short-float
   least-negative-normalized-single-float
   least-negative-short-float
   least-negative-single-float
   least-positive-double-float
   least-positive-long-float
   least-positive-normalized-double-float
   least-positive-normalized-long-float
   least-positive-normalized-short-float
   least-positive-normalized-single-float
   least-positive-short-float
   least-positive-single-float
   length
   let
   let*
   lisp-implementation-type
   lisp-implementation-version
   list
   list*
   list-all-packages
   list-length
   listen
   listp
   load
   locally
   logandc1
   logandc2
   logand
   logbitp
   logcount
   logeqv
   logior
   lognand
   lognor
   lognot
   logorc1
   logorc2
   logtest
   logxor
   log
   long-float-epsilon
   long-float-negative-epsilon
   long-float
   long-site-name
   loop
   lower-case-p
   machine-instance
   machine-type
   machine-version
   macro-function
   macroexpand-1
   macroexpand
   macrolet
   make-array
   make-broadcast-stream
;; #-ANSI-90 make-char
   make-concatenated-stream
   make-dispatch-macro-character
   make-echo-stream
   make-hash-table
   make-list
   make-package
   make-pathname
   make-random-state
   make-sequence
   make-string
   make-string-input-stream
   make-string-output-stream
   make-symbol
   make-synonym-stream
   make-two-way-stream
   makunbound
   mapc
   mapcan
   mapcar
   mapcon
   maphash
   maplist
   mapl
   map
   mask-field
   max
   member-if
   member-if-not
   member
   merge
   merge-pathnames
   min
   minusp
   mismatch
   mod
   most-negative-double-float
   most-negative-fixnum
   most-negative-long-float
   most-negative-short-float
   most-negative-single-float
   most-positive-double-float
   most-positive-fixnum
   most-positive-long-float
   most-positive-short-float
   most-positive-single-float
   multiple-value-bind
   multiple-value-call
   multiple-value-list
   multiple-value-prog1
   multiple-value-setq
   multiple-values-limit
   name-char
   namestring
   nbutlast
   nconc
   nil
   nintersection
   ninth
   not
   notany
   notevery
   notinline
   nreconc
   nreverse
   nset-difference
   nset-exclusive-or
   nstring-capitalize
   nstring-downcase
   nstring-upcase
   nsublis
   nsubst-if
   nsubst-if-not
   nsubstitute
   nsubstitute-if
   nsubstitute-if-not
   nsubst
   nth
   nthcdr
   null
   numberp
   number
   numerator
   nunion
   oddp
   open
   open-stream-p
   optimize
   or
   otherwise
   output-stream-p
   package-name
   package-nicknames
   package-shadowing-symbols
   package-use-list
   package-used-by-list
   packagep
   package
   pairlis
   parse-integer
   parse-namestring
   pathname-device
   pathname-directory
   pathname-host
   pathname-name
   pathname-type
   pathname-version
   pathnamep
   pathname
   peek-char
   phase
   pi
   plusp
   pop
   position
   position-if
   position-if-not
   pprint
   prin1-to-string
   prin1
   princ-to-string
   princ
   print
   probe-file
   proclaim
   prog
   prog*
   prog1
   prog2
   progn
   progv
;; #-ANSI-90 provide
   psetf
   psetq
   push
   pushnew
   quote
   random
   random-state-p
   random-state
   rassoc-if
   rassoc-if-not
   rassoc
   rationalize
   rationalp
   rational
   ratio
   read-byte
   read-char
   read-char-no-hang
   read-delimited-list
   read-from-string
   read-line
   read-preserving-whitespace
   readtablep
   readtable
   read
   realpart
   reduce
   remf
   remhash
   remove-duplicates
   remove-if
   remove-if-not
   remove
   remprop
   rem
   rename-file
   rename-package
   replace
;; #-ANSI-90 require
   rest
   return-from
   return
   revappend
   reverse
   room
   rotatef
   round
   rplaca
   rplacd
   safety
   satisfies
   sbit
   scale-float
   schar
   search
   second
   sequence
   set
;; #-ANSI-90 set-char-bit
   set-difference
   set-dispatch-macro-character
   set-exclusive-or
   set-macro-character
   set-syntax-from-char
   setf
   setq
   seventh
   shadow
   shadowing-import
   shiftf
   short-float-epsilon
   short-float-negative-epsilon
   short-float
   short-site-name
   signed-byte
   signum
   simple-array
   simple-bit-vector-p
   simple-bit-vector
   simple-string-p
   simple-string
   simple-vector-p
   simple-vector
   sin
   single-float-epsilon
   single-float-negative-epsilon
   single-float
   sinh
   sixth
   sleep
   software-type
   software-version
   some
   sort
   space
   special-form-p			;; --- Will be replaced with special-operator-p
   special
   speed
   sqrt
   stable-sort
   standard-char-p
   standard-char
   step
   stream-element-type
   streamp
   stream
   string
   string-capitalize
;; #-ANSI-90 string-char-p
;; #-ANSI-90 string-char
   string-downcase
   string-equal
   string-greaterp
   string-left-trim
   string-lessp
   string-not-equal
   string-not-greaterp
   string-not-lessp
   string-right-trim
   string-trim
   string-upcase
   string/=
   string<
   string<=
   string=
   string>
   string>=
   stringp
   structure
   sublis
   subseq
   subsetp
   subst-if
   subst-if-not
   substitute
   substitute-if
   substitute-if-not
   subst
   subtypep
   svref
   sxhash
   symbol-function
   symbol-name
   symbol-package
   symbol-plist
   symbol-value
   symbolp
   symbol
   t
   tagbody
   tailp
   tan
   tanh
   tenth
   terpri
   the
   third
   throw
   time
   trace
   tree-equal
   truename
   truncate
   type-of
   typecase
   typep
   type
   unexport
   unintern
   union
   unless
   unread-char
   unsigned-byte
   untrace
   unuse-package
   unwind-protect
   upper-case-p
   use-package
   user-homedir-pathname
   values
   values-list
   variable
   vector
   vector-pop
   vector-push-extend
   vector-push
   vectorp
   warn
   when
   with-input-from-string
   with-open-file
   with-open-stream
   with-output-to-string
   write
   write-byte
   write-char
   write-line
   write-string
   write-to-string
   y-or-n-p
   yes-or-no-p
   zerop))

;;; Get around a CCL-2 DEFPACKAGE bug.
#+ccl-2
(eval-when (eval compile load)
  (export '(()) "CLIM-LISP"))

#+Genera
(pushnew (find-package "CLIM-LISP") si:*reasonable-packages*)
