;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10; Package: CLIM2; Lowercase: Yes -*-

(in-package "CLIM2")

"Copyright (c) 1991 by International Lisp Associates.  All rights reserved."

(defvar *clim-internals-package* (find-package "CLIM2"))


;;; Here's how to get (:colon-mode :internal) in a CL package.  Just for now...
#+Genera
(eval-when (eval compile load)
  (let ((package (find-package "CLIM2")))
    (setf (si:pkg-prefix-intern-function package) 'intern)))

;;; Copied from CLIM;PKGDCL.LISP
(defmacro clim:define-clim-package (name &rest options)
  (let ((new-options nil)
	(use-list '(CLIM CLIM-LISP)))
    (dolist (option options)
      (if (or (atom option) (not (eql (first option) ':use)))
	  (push option new-options)
	  (setf use-list (append use-list (cdr option)))))
    `(clim-lisp:defpackage ,name
       (:use ,@use-list)
       ,@(nreverse new-options))))

(clim:define-clim-package clim-demo)
(clim:define-clim-package clim-user)
