;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-TEST; Base: 10 -*-

(in-package :clim-test)

"Copyright (c) 1990 by International Lisp Associates.  All rights reserved."

;;; --- rsl would prefer that DEFINE-APPLICATION-FRAME take superclasses
;;; as a keyword, but it might be too late to change this.

(define-application-frame test-program
			  ()			;Superclasses
  (documentation-pane display-pane)		;Slots

  (:pane
    (with-frame-slots (documentation-pane display-pane)
      (vertically ()
	(make-clim-pane (documentation-pane :scroll-bars nil :vs 70 :hs 500))
	(make-clim-pane (display-pane :hs 500 :vs #+Imach 300 #-Imach 500)))))
   
  (:top-level (run-test-program)))

(defvar *all-clim-tests* nil)

(defstruct (clim-test 
	    (:print-function (lambda (test stream ignore)
			       (declare (ignore ignore))
			       (print-unreadable-object 
				(test stream 
				      :type nil ;Stupid.  Says "VECTOR" on EXCL
				      :identity t)
				(princ 'clim-test stream) ; Do it right.
				(write-char #\space stream)
				(princ (clim-test-name test) stream)))))
  name
  documentation
  properties
  (last t))
  
(defvar *clim-test-arguments* '(window &optional documentation-window test))

#+Genera (scl:defprop define-clim-test "CLIM test" zwei:definition-type-name)
#+Genera (scl:defprop define-clim-test zwei:defselect-function-spec-finder
		      zwei:definition-function-spec-finder)

;;; Until we are ready to have this in the real system.
(defun stupid-canonicalize-and-match-lambda-lists (true-lambda-list supplied-lambda-list)
  (let ((supplied-lambda-list (copy-list supplied-lambda-list))
	(new-lambda-list nil)
	(ignores nil)
	(state '&required)
	temp)
    (macrolet ((canonical-gensym (name)
		 `(or (get ,name 'canonical-gensym)
		      (setf (get ,name 'canonical-gensym) (make-symbol (symbol-name ,name)))))
	       (match-names (true-name supplied-name)
		 `(and (symbolp ,true-name) (symbolp ,supplied-name)
		       (string-equal ,true-name ,supplied-name)))
	       (get-optional (spec) `(if (listp ,spec) (first ,spec) ,spec))
	       (make-keyword (name) `(intern (string ,name) *keyword-package*))
	       (get-key-keyword (spec)
		 `(if (listp ,spec)
		      (if (listp (car ,spec)) (caar ,spec) (make-keyword (car ,spec)))
		      (make-keyword ,spec))))
      (flet ((get-false-argument-name (argument)
	       (ecase state
		 ((&required &rest) (canonical-gensym argument))
		 (&optional (let ((argname (get-optional argument)))
			      (canonical-gensym argname)))
		 ((&key &allow-other-keys)
		  (let* ((keyname (get-key-keyword argument)))
		    (canonical-gensym keyname)))))
	     (match-arguments (true supplied)
	       (ecase state
		 ((&required &rest) (match-names true supplied))
		 (&optional (match-names (get-optional true) (get-optional supplied)))
		 ((&key &allow-other-keys)
		  (match-names (get-key-keyword true) (get-key-keyword supplied))))))
      (declare (dynamic-extent #'match-arguments))
      (dolist (true-argument true-lambda-list)
	(cond ((member true-argument lambda-list-keywords)
	       (setf state true-argument)
	       (push true-argument new-lambda-list))
	      ((setf temp (member true-argument supplied-lambda-list :test #'match-arguments))
	       (push (first temp) new-lambda-list)
	       (setf supplied-lambda-list (delete (first temp) supplied-lambda-list)))
	      (t (let ((new-var (get-false-argument-name true-argument)))
		   (push new-var new-lambda-list)
		   (push new-var ignores)))))))
    (unless (null (setf temp (set-difference supplied-lambda-list lambda-list-keywords)))
      (warn "Unused lambda-list keywords: ~S" temp))
    (values (nreverse new-lambda-list) (nreverse ignores))))

(defmacro define-clim-test (name lambda-list &body body &environment env)
  (multiple-value-bind (name properties)
      (if (listp name)
	  (values (car name) (cdr name))
	  (values name nil))
    (multiple-value-bind (documentation declarations body)
	(extract-declarations body env)
      (multiple-value-bind (lambda-list ignores)
	  ;; --- (canonicalize-and-match-lambda-lists *clim-test-arguments* lambda-list)
	  (stupid-canonicalize-and-match-lambda-lists *clim-test-arguments* lambda-list)
	`(define-group ,name define-clim-test
	   (defun ,name ,lambda-list ,documentation 
		  ,@declarations (declare (ignore ,@ignores))
		  ,@body)
	   (let ((test (find ',name *all-clim-tests* :key #'clim-test-name)))
	     (unless test
	       (let ((last-cons (last *all-clim-tests*))
		     (new-test (make-clim-test :name ',name)))
		 (cond (last-cons
			(setf (clim-test-last (car last-cons)) nil)
			(nconc last-cons (list new-test)))
		       (t (setf *all-clim-tests* (list new-test))))
		 (setf (clim-test-last new-test) t)
		 (setf test new-test)))
	     (setf (clim-test-documentation test) ',documentation
		   (clim-test-properties test) ',properties)))))))

(defvar *test-suite-timeout* 60.)

(defmethod run-test-program ((frame test-program))
  ;; Magic incantation
  ;; --- maybe run-frame-top-level should do this automatically?
  (ci::initialize-stream-queues frame)
  (with-slots (documentation-pane display-pane) frame
    (dolist (test *all-clim-tests*)
      
      (let ((record-p (getf (clim-test-properties test) :output-recording))
	    (draw-p (not (getf (clim-test-properties test) :output-disabled)))
	    (self-terminating (getf (clim-test-properties test) :self-terminating)))

	(window-clear documentation-pane)
	(write-string (clim-test-documentation test) documentation-pane)
	(when self-terminating
	  (format documentation-pane "~%This test will determine when to end."))
	(force-output documentation-pane)

	(window-clear display-pane)
	(with-output-recording-options (display-pane :record-p record-p :draw-p draw-p)
	  (funcall (clim-test-name test) display-pane documentation-pane test))
	(force-output display-pane)

	(fresh-line documentation-pane)
	(when (not self-terminating)
	  (read-a-gesture-to-terminate test documentation-pane display-pane))))

    (window-clear documentation-pane)
    (window-clear display-pane)
    (stop-frame frame)))

(defun read-a-gesture-to-terminate (test documentation-pane display-pane)
  (fresh-line documentation-pane)
  (write-string (if (clim-test-last test)
		    "Click on display to end test"
		    "Click on display for next test")
		documentation-pane)
  (force-output documentation-pane)
  (read-gesture :stream display-pane :timeout *test-suite-timeout*))

(defun run-test-suite (&key (server-path *default-server-path*) (timeout 60.)
			    (width 600) (height 300))
  (let ((*test-suite-timeout* timeout))
    (launch-frame 'test-program :where server-path :wait-until-done t
		  :title "CLIM Test Suite"
		  :width width :height height)))
