;;; -*- Syntax: Common-Lisp; Base: 10; Package: CLIM; Mode: LISP -*-

(defvar *base* 0)
(defvar *max-base* 3)

(defun dld-test-dw-a (stream)
  (scl:send stream :clear-history)
  (let ((redisplayer (dw::redisplayer (stream)
		       (dotimes (row 15)
			 (dotimes (col 16)
			   (let ((value (+ *base* col (* row 16))))
			     (dw::with-redisplayable-output (:stream stream
							     :unique-id value #+ignore (+ col (* row 16))
							     :cache-value value)
			       (lisp:format stream "~4A" value))))
			 (terpri stream)))))
    (dw::do-redisplay redisplayer stream)
    (time
    (dotimes (b (1- *max-base*))
      (let ((*base* (1+ b)))
	(dw::do-redisplay redisplayer stream))))))

(defun dld-test-b-dw (stream)
  (scl:send stream :clear-history)
  (let* ((foo 1)
	 (redisplayer (dw::redisplayer (stream)
			(do ((row foo (1- row)))
			    ((= row 0))
			  (dw::with-redisplayable-output (:stream stream
							  :unique-id row
							  :cache-value row)
			    (dotimes (col 16)
			      (let* ((value (+ col (* row 16))))
				(dw::with-redisplayable-output (:stream stream
								:unique-id value
								:cache-value value)
				  (lisp:format stream "~4A" value))))
			    (lisp:terpri stream))))))
    (time
      (do ((foo-1 2 (1+ foo-1)))
	  ((= foo-1 15))
	(setq foo foo-1)
	(dw::do-redisplay redisplayer stream)))))

(defun dld-test-b (stream)
  (window-clear stream)
  (window-expose stream)
  (let* ((foo 1)
	 (redisplayer (updating-output (stream)
			(do ((row foo (1- row)))
			    ((= row 0))
			  (updating-output (stream :unique-id row :cache-value row)
			    (dotimes (col 16)
			      (let* ((value (+ col (* row 16))))
				(updating-output (stream
						   :unique-id value
						   :cache-value value)
				  (format stream "~4A" value))))
			    (terpri stream))))))
    (time
      (do ((foo-1 2 (1+ foo-1)))
	  ((= foo-1 15))
	(setq foo foo-1)
	(redisplay redisplayer stream)))))

(defun dld-test-a (stream)
  (window-clear stream)
  (window-expose stream)
  (let ((redisplayer (updating-output (stream)
		       (dotimes (row 15)
			 (dotimes (col 16)
			   (let ((value (+ *base* col (* row 16))))
			     (updating-output (stream
						:unique-id #+ignore value (+ col (* row 16))
						:cache-value value)
			       (format stream "~4A" value))))
			 (terpri stream)))))
    (time
    (dotimes (b (1- *max-base*))
      (let ((*base* (1+ b)))
	(redisplay redisplayer stream))))))


(defun meter-table-test (stream)
  (window-clear stream)
  (window-expose stream)
;  (user::with-phase-metering ()
;  (clear-resource 'text-output-record-element)
  (time
    (formatting-table (stream)
      (table-body stream))
;    t
    )
  (window-set-visibility stream nil)
;  (user::display-results)
  )

(defun table-body (stream)
  (dotimes (row 4)
    (formatting-row (stream)
      (dotimes (col 4)
	(let* ((cell-address (+ (* row 16) col))
	       (value (+ *print-base* cell-address)))
	  (formatting-cell (stream)
	    (write-string "FOO" stream)
	    #+ignore
	    (format stream "~A" value)))))))

(defun test-collection (stream)
  (time
    (with-new-output-record (stream 'cell-output-record)
      (dotimes (row 4)
	(dotimes (col 4)
	  (write-string "foo" stream))))))

(defun meter-table-test-1 (stream)
  (window-clear stream)
  (window-expose stream)
  (formatting-table (stream)
    (time
    (table-body-1 stream)))
  (window-set-visibility stream nil))

(defun table-body-1 (stream)
  (dotimes (row 4)
    (formatting-row (stream)
      (dotimes (col 4)
	(let* ((cell-address (+ (* row 16) col))
	       (value (+ *print-base* cell-address)))
	  (formatting-cell (stream)
	    (draw-rectangle* 0 0 25 15 :stream stream)
	    #+ignore
	    (format stream "~A" value)))))))

(defun meter-table-test-dw (stream)
  (scl:send stream :expose)
  (scl:send stream :clear-history)
  (time
    (scl:formatting-table (stream)
      ;; The Rows
      (dotimes (row 8)
	(scl:formatting-row (stream)
	  (dotimes (col 8)
	    (let* ((cell-address (+ (* row 16) col))
		   (value (+ *print-base* cell-address)))
	      (scl:formatting-cell (stream)
;		(multiple-value-bind (x y) (scl:send stream :read-cursorpos)
;		  (graphics:draw-rectangle x y (+ x 10) (+ y 10) :stream stream))
;		(format stream "~A" value)
		(cl:write-string "foo" stream)
		))))))))

(defun method-test ()
  (time
    (dotimes (n 240)
      (output-recording-stream-text-output-record win))))

(defparameter *items*
	      '("0" "1" "2" "3" "4" "5" "6" "7" "8" "9"
		"10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29"
		"100" "101" "102" "103" "104" "105" "106" "107" "108" "109"
		"110" "111" "112" "113" "114" "115" "116" "117" "118" "119"
		"1000" "1001" "1002" "1003" "1004" "1005" "1006" "1007" "1008" "1009"))


(defparameter *items*
	      '(0 1 2 3 4 5 6 7 8 9
		10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29
		100 101 102 103 104 105 106 107 108 109
		110 111 112 113 114 115 116 117 118 119
		1000 1001 1002 1003 1004 1005 1006 1007 1008 1009))

(defun test-formatting-items (win)
  (window-clear win)
  (window-expose win)
;  (time
  ;; Put enough items into the resource so we only have to allocate
  (dotimes (n (length *items*))
    (free-record (make-text-output-record-element)))
  (dotimes (n (length *items*))
    (free-record (cell-output-record-constructor)))
;  (mi::with-metering-enabled
  (time
    (format-items *items* :stream win :max-height 70
		  :printer #'(lambda (o s) (format s "~A" o)))
)
  (window-clear win)
  (time
    (format-items *items* :stream win :max-width 250
		  :printer #'(lambda (o s) (format s "~A" o))))
  )


(defun test-formatting-items-dw (win)
  (scl:send win :clear-history)
  (scl:send win :expose)
  (time
    (scl:format-item-list *items* :stream win :max-height 70 
			  :printer #'(lambda (o s) (lisp:format s "~A" o))
			  ))
  (scl:send win :clear-history)
  (time
    (scl:format-item-list *items* :stream win :max-width 250 
			  :printer #'(lambda (o s) (lisp:format s "~A" o))
			  )))

;;; string versions
;(defun test-formatting-items (win)
;  (window-clear win)
;  (window-expose win)
;  (time
;    (format-items *items* :stream win :max-height 70
;		  :printer #'write-string))
;  (window-clear win)
;  (time
;    (format-items *items* :stream win :max-width 250
;		  :printer #'write-string)))
;
;
;(defun test-formatting-items-dw (win)
;  (scl:send win :clear-history)
;  (scl:send win :expose)
;  (time
;    (scl:format-item-list *items* :stream win :max-height 70 
;			  :printer #'lisp:write-string
;			  ))
;  (scl:send win :clear-history)
;  (time
;    (scl:format-item-list *items* :stream win :max-width 250 
;			  :printer #'lisp:write-string
;			  )))

(defun do-body (item-list stream printer presentation-type cell-align-x cell-align-y)
  ;;--- Lists?  Sequences?
  (dolist (item item-list)
    (formatting-cell (stream :align-x cell-align-x :align-y cell-align-y)
      (cond (printer
	     (funcall printer item stream))
	    (presentation-type
	     (present item presentation-type :stream stream))))))

;; hacked for metering
(defun format-items (item-list &key (stream *standard-output*) printer presentation-type
			       inter-row-spacing inter-column-spacing
			       n-rows n-columns max-width max-height
			       (record-type 'item-list-output-record)
			       cell-align-x cell-align-y)
  (when (and printer presentation-type)
    (error "Only one of ~S or ~S can be specified." ':printer ':presentation-type))
  (when (and (null printer) (null presentation-type))
    (error "One of ~S or ~S must be specified." ':printer ':presentation-type))
  (formatting-item-list (stream :record-type record-type :n-rows n-rows :n-columns n-columns
			:max-width max-width :max-height max-height
			:inter-row-spacing inter-row-spacing
			:inter-column-spacing inter-column-spacing)
    (do-body item-list stream printer presentation-type cell-align-x cell-align-y)))


(define-application pane-test ()
		    :subwindows ((one :application :scroll-bars nil)
				 (two :application :scroll-bars nil)
				 (three :application :scroll-bars nil)
				 (four :application :scroll-bars nil))
		    :layout ((main (:column 1
				    (:row 1/2 (one 1/3) (two 2/3))
				    (:row 1/2 (three 2/3) (four 1/3))))))

(define-pane-test-operation foobar () )

(defun resize-frame (appl)
  (let* ((tlw (application-top-level-window appl))
	 (gw (slot-value tlw 'window)))
    (window-expose tlw)
    (scl:send gw :refresh)
    (scl:send gw :set-size 500 150)
    (multiple-value-bind (w h) (scl:send gw :size)
      (loop repeat 10
	    for new-width from w by -10
	    do
	(scl:send gw :set-size new-width h)
	(read-gesture :stream tlw :timeout 0)))
    (multiple-value-bind (w h) (scl:send gw :size)
      (loop repeat 10
	    for new-height from h by -10
	    do
	(scl:send gw :set-size w new-height)
	(read-gesture :stream tlw :timeout 0)))
    (multiple-value-bind (w h) (scl:send gw :size)
      (loop repeat 10
	    for new-width from w by 10
	    for new-height from h by 10
	    do
	(scl:send gw :set-size new-width new-height)
	(read-gesture :stream tlw :timeout 0)))))


(scl:defflavor my-frame () (tv:bordered-constraint-frame-with-shared-io-buffer)
  (:default-init-plist
    :configurations '((main (:layout
			      (main :column foo bar)
			      (foo :row one two)
			      (bar :row three four))
			    (:sizes
			      (foo (one 1/3) (two 2/3))
			      (bar (three 2/3) (four 1/3))
			      (main (foo 1/2) (bar 1/2)))))
    :panes '((one tv:window-pane)
	     (two tv:window-pane)
	     (three tv:window-pane)
	     (four tv:window-pane))))

(defun resize-genera-frame (frame)
  (scl:send frame :expose)
  (scl:send frame :set-size 500 150)
  (multiple-value-bind (w h) (scl:send frame :size)
    (loop repeat 10
	  for new-width from w by -10
	  do
      (scl:send frame :set-size new-width h)))
  (multiple-value-bind (w h) (scl:send frame :size)
    (loop repeat 10
	  for new-height from h by -10
	  do
      (scl:send frame :set-size w new-height)))
  (multiple-value-bind (w h) (scl:send frame :size)
    (loop repeat 10
	  for new-width from w by 10
	  for new-height from h by 10
	  do
      (scl:send frame :set-size new-width new-height))))

(defun test-pop-up-avv (parent)
  (with-menu (menu parent)
    (entity-set-size menu 500 150)
    (window-expose menu)
    (stream-set-input-focus menu)
    (accepting-values (menu)
      (accept 'pathname :stream menu)
      (terpri menu)
      (accept 'pathname :stream menu :prompt "Path 2"))
    (window-set-visibility menu nil)
    ))

(defun test-pop-up-avv-dw (parent)
  (dw::accepting-values (*query-io* :own-window t)
    (scl:accept 'pathname)
    (scl:accept 'pathname :prompt "path 2")))

(defvar *size* 10)

(defun redisplay-test (stream)
  (window-clear stream)
  (window-expose stream)
  (let ((redisplayer
	  (updating-output (stream)
	    (formatting-table (stream)
	      ;; The Rows
	      (dotimes (row *size*)
		(formatting-row (stream)
		  (dotimes (col *size*)
		    (let* ((cell-address (+ (* row *size*) col))
			   (value (if (= cell-address 12)
				      (decode-universal-time (get-universal-time))
				      cell-address)))
		      (formatting-cell (stream)
			(updating-output (stream :unique-id cell-address :cache-value value)
			  (format stream "~A" value)))))))))))
    (stream-set-cursor-position* stream 0 0)
    (dotimes (count 2)
      (if (= count 1)
	  (time (redisplay redisplayer stream))
	  (redisplay redisplayer stream)))))

(defun redisplay-test-dw (stream)
  (scl:send stream :clear-history)
  (let ((redisplayer
	  (dw:redisplayer (stream)
	    (scl:formatting-table (stream)
	      ;; The Rows
	      (dotimes (row *size*)
		(scl:formatting-row (stream)
		  (dotimes (col *size*)
		    (let* ((cell-address (+ (* row *size*) col))
			   (value (if (= cell-address 12)
				      (decode-universal-time (get-universal-time))
				      cell-address)))
		      (scl:formatting-cell (stream)
			(dw:with-redisplayable-output (:stream stream :unique-id cell-address :cache-value value)
			  (format stream "~A" value)))))))))))
    (dotimes (count 2)
      (if (= count 1)
	  (time (dw::do-redisplay redisplayer stream))
	  (dw::do-redisplay redisplayer stream)))))


(defun simplest-redisplay-test (stream)
  (window-clear stream)
  (window-expose stream)
  (let* ((item "foo")
	 (redisplayer (updating-output (stream)
			(write-string item stream))))
    (dotimes (count 20)
      (setf (aref item 1) (code-char count))
      (redisplay redisplayer stream))))
  
(defun simple-redisplay-test (stream)
  (window-clear stream)
  (window-expose stream)
  (let* ((item-list (list 0 1 2 3 4 5 6 7 8 9))
	 (redisplayer
	   (updating-output (stream)
	     (let ((item-no 0))
	       (dolist (item item-list)
		 (updating-output (stream :unique-id item-no :cache-value item)
		   (format stream "~A" item)
		   (terpri stream))
		 (incf item-no))))))
    (stream-set-cursor-position* stream 0 0)
    (time
      (dotimes (count 50)
	(setf (elt item-list 5) count)
	(redisplay redisplayer stream)
	))))

(defun test-lexical (var)
  (flet ((foo (n)
	      (+ n var)))
    (foo 17)))

(defun simple-redisplay-test-dw (stream)
  (scl:send stream :clear-history)
  (let* ((item-list '(0 1 2 3 4 5 6 7 8 9))
	 (redisplayer
	   (dw:redisplayer (stream)
	     (let ((item-no 0))
	       (dolist (item item-list)
		 (dw:with-redisplayable-output (:stream stream :unique-id item-no :cache-value item)
		   (lisp:format stream "~A" item))
		   (lisp:terpri stream)
		 (incf item-no))))))
    (time
      (dotimes (count 50)
	(setf (elt item-list 5) count)
	(dw::do-redisplay redisplayer stream)))))


(defun test-sensitivity (win)
  (window-clear win)
  (window-expose win)
  (dotimes (n 500)
    (with-output-as-presentation (:stream win :object #P"foo" :type 'pathname)
      (write-string "X" win))
    (when (zerop (mod (1+ n) 50))
      (terpri win)))
  (with-input-editing (win)
    (accept 'pathname :stream win)))

(defun generate-presentation-types (count)
  (flet ((parser (ignore stream &rest stuff) (loop (read-gesture :stream stream) (beep stream))))
    (dotimes (n count)
      (let ((pt-name (fintern "DUMMY-TYPE-~D" n)))
	(define-presentation-type-1 pt-name nil nil
				    :data-args-function #'ignore
				    :supertype #'ignore
				    :parser #'parser)))))

(generate-presentation-types 20)

(defun draw-dummies (win)
  (window-clear win)
  (let ((type-number 0))
    (dotimes (n 10)
      (let ((type-name (fintern "DUMMY-TYPE-~D" type-number)))
	(with-output-as-presentation (:type type-name :object 'foo :stream win)
	  (draw-rectangle* (* n 20) 0 (+ (* n 20) 15) 15 :stream win)))
      (incf type-number))
    (stream-set-cursor-position* win 0 50)
    (dotimes (n 10)
      (let ((type-name (fintern "DUMMY-TYPE-~D" type-number)))
	(with-output-as-presentation (:type type-name :object 'foo :stream win)
	  (write-string "foo" win)))
      (stream-increment-cursor-position* win 10 nil)
      (incf type-number))))

(defun test-sensitivity-2 (win)
  (draw-dummies win)
  (window-expose win)
  (prog1
    (with-input-context (t) (obj)
	 (read-gesture :stream win)
       (t obj))
    (window-set-visibility win nil)))

;================================================================

(defconstant *clim-random-state* (make-random-state))

(defun draw-stuff (stream &optional record-p)
  (window-clear stream)
  (window-expose stream)
  (let ((ran (make-random-state *clim-random-state*))
	(size 16)
	(genera-window (slot-value stream  'window)))
    (multiple-value-bind (inside-width inside-height)
	(window-inside-size stream)
      (with-output-recording-options (stream :record-p record-p)
	(graphics:with-scan-conversion-mode (genera-window :sketch t)
	  (dotimes (i size)
	    (let ((x (+ 15 (* i 15))))
	      (dotimes (y size)
		(let ((y (+ 15 (* y 15)))
		      (value (random 1024 ran)))
		  (case (ldb (byte 2 0) value)
		    (0 (draw-circle* x y
				     (min x (abs (- inside-width x))
					  y (abs (- inside-height y))
					  (ldb (byte 6 0) value))
				     :stream stream :filled nil))
		    (1 (draw-rectangle* x y
					(min inside-width
					     (+ x (ldb (byte 6 0) value)))
					(min inside-height
					     (+ y (ldb (byte 6 0) (logxor value (ash value 3)))))
					:stream stream :filled nil))
		    (2 (draw-line* x y
				   (min inside-width (+ x (ldb (byte 6 0) value)))
				   (min inside-height (+ y (ldb (byte 6 0)
								(logxor value (ash value 3)))))
				   :stream stream))
		    (3 (draw-ellipse* x y
				      (min x (abs (- inside-width x))
					   y (abs (- inside-height y))
					   (ldb (byte 6 0) value))
				      (min x (abs (- inside-width x))
					   y (abs (- inside-height y))
					   (ldb (byte 6 0) (logxor value (ash value 3))))
				      :stream stream :filled nil))
;	    (4 (draw-triangle ))
;	    (5 (draw-polygon))
;	    (6 (draw-oval  ))
;	    (7 (draw-spline ))
		    ))))))))))
