;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-USER; Base: 10 -*-


(defun draw-some-stuff (stream)
  #1=(progn
       (draw-rectangle* stream -100 -100 4000 4000 :ink 1) ;; see where clipping region is.
       (draw-rectangle* stream 0 0 400 400 :filled nil) ;; A bounding box, sort of.
       (draw-rectangle* stream 100 100 200 200 :ink 25)
       (draw-rectangle* stream 100 100 200 200 :filled nil :line-thickness 4)
       (with-drawing-options (stream :transformation (make-rotation-transformation* .3 250 150)
				     :text-size :very-large :text-face :bold)
	 (draw-rectangle* stream 200 100 300 200 :ink 12.5)
	 (draw-rectangle* stream 200 100 300 200 :line-thickness 6 :filled nil)
	 (draw-text* stream "<- a rectangle with a long string to run off the edge" 310 150))
       (let ((polygon '(100 300 150 300 175 350 100 400)))
	 (draw-polygon* stream polygon :ink 33)
	 (draw-polygon* stream polygon :filled nil :line-thickness 9 :line-dashed #(3 1 4 2))))
  (stream-set-cursor-position* stream 0 450)
  (format stream "~{~%~S~}" (cdr '#1#)))

(defun draw-some-postscript (&key (pathname (on-postscript::default-postscript-file))
			     #+Genera (hardcopy t))
  (with-open-stream (ps (make-printer-stream
			  :server-path `(:postscript :file ,pathname)))
    (draw-some-stuff ps))
  #+Genera
  (when hardcopy (hardcopy:hardcopy-file pathname hardcopy:*default-text-printer*
					 :format :postscript))
  pathname)
