;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-USER; Base: 10 -*-

(in-package :clim-user)

(defun make-a-table (window)
  (formatting-table (window)
    (formatting-row (window)
      (formatting-cell (window)
	(present "ONE" 'string :stream window))
      (formatting-cell (window)
	(present "TWO" 'string :stream window)))
    (formatting-row (window)
      (formatting-cell (window)
	(present "THREE" 'string :stream window))
      (formatting-cell (window)
	(present "FOUR" 'string :stream window)))))

(defun this-works (window)
  (window-clear window)
  (make-a-table window)
  (accept 'string :stream window))

(defun this-does-not-work (window)
  (window-clear window)
  (make-a-table window)
  (stream-set-cursor-position*
    window
    (+ (bounding-rectangle-width
	 (output-recording-stream-output-record window))
       5)
    0)
  ;; This keeps the first line of presentations from being mouse-sensitive:
  (write-string "foo" window)
  (stream-set-cursor-position*
    window
    0
    (+ (bounding-rectangle-height
	 (output-recording-stream-output-record window))
       20))
  (accept 'string :stream window))
