;;; -*- Base: 10; Mode: Lisp; Package: CLIM; Syntax: Common-Lisp -*-

(in-package 'clim)

(defun test-output-history (stream)
  (window-clear stream)
  (dotimes (i 15)
    (write-string "Fribble" stream)
    (terpri stream))
  (lisp:format t "~&The total height should be around ~D; it is ~D"
	       (+ (stream-line-height stream)
		  (* 14 (+ (stream-line-height stream)(stream-vsp stream))))
	       (entity-height (output-recording-stream-output-record stream))))

(defun test-table (stream)
  (window-clear stream)
  (formatting-table (stream :inter-row-spacing (stream-vsp stream))
    (dotimes (i 15)
      (formatting-row (stream)
	(formatting-cell (stream)
	  (write-string "Fribble" stream))
	(formatting-cell (stream)
	  (format stream "~D" i)))))
  (lisp:format t "~&The total height should be around ~D; it is ~D"
	       (+ (stream-line-height stream)
		  (* 14 (+ (stream-line-height stream)(stream-vsp stream))))
	       (entity-height (output-recording-stream-output-record stream))))
