;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CL-USER; Base: 10 -*-

(defparameter *dw-stream* (tv:make-window 'dw::dynamic-window
					  :height clim-demo::*outside-height*
					  :width clim-demo::*outside-width*
					  :label nil))

(send *dw-stream* :expose)

(defparameter *temporary-dw-windows*
	      (let (w)
		(do ((i 80 (+ i 5)))
		    ((> i 280))
		  (push (tv:make-window 'dw::dynamic-window :x i :y i :expose-p t :blinker-p nil
					:width 80 :height 80
					:margin-components '((dw::margin-ragged-borders)))
			w))
		(nreverse w)))

(defparameter *temp-dw-text-window*
	      (let* ((w (tv:make-window 'dw::dynamic-window :expose-p t :blinker-p nil
					 :x 300 :y 300 :width 100 :height 100
					:margin-components '((dw::margin-ragged-borders)))))
		(format w " Remove ~% Add ~% File ~% Move ~% Copy ~% Expand")
		w))


(defun vertical-lines (&optional (stream *dw-stream*))
  (loop for x from 10 by 2
	with width = 1
         while (< x clim-demo::*test-width*)
	do (graphics:draw-line x 10 x clim-demo::*test-height* :stream stream :thickness width)))

(defun concentric-squares (&optional (stream *dw-stream*))
  (loop for radius from 3 by 3 below clim-demo::*center-y*
	for top = (- clim-demo::*center-y* radius)
	for bottom = (+ clim-demo::*center-y* radius)
	do (graphics:draw-rectangle top top bottom bottom :stream stream :alu :flip)))

(defun concentric-ellipses (&optional (stream *dw-stream*))
  (loop for x-radius from 3 by 3 below clim-demo::*center-y*
	for y-radius from 2 by 2
	do (graphics:draw-ellipse clim-demo::*center-x* clim-demo::*center-y* x-radius y-radius
				  :stream stream :alu :flip)))

(defun empty-temp-windows (&optional ignore)
  (dolist (stream *temporary-dw-windows*)
    (send stream :expose)
    (send stream :deactivate)))

(defun text-window (&optional ignore)
  (dotimes (i 10)
    (send *temp-dw-text-window* :expose)
    (send *temp-dw-text-window* :deactivate)))

(defun smbx-test-3a (&optional (stream *dw-stream*))
  (dotimes (i 10)
    (send stream :set-cursorpos 0 0)
    (dotimes (i clim-demo::*smbx-test-3a-count*)
      (write-string clim-demo::*smbx-test-3-string* stream)
      (terpri stream))))

(defun smbx-test-3b (&optional (stream *dw-stream*))
  (dotimes (i 10)
    (send stream :set-cursorpos 0 0)
    (dotimes (i clim-demo::*smbx-test-3b-count*)
      (dolist (appearance clim-demo::*smbx-test-3b-appearances*)
	(with-character-style (appearance stream)
	  (write-string clim-demo::*smbx-test-3-string* stream)
          (terpri stream))))))

(defun smbx-test-3c (&optional (stream *dw-stream*))
  (send stream :set-cursorpos 0 0)
  (dolist (string clim-demo::*smbx-test-3c-strings*)
    (write-string string stream))
  (let ((inside-height (send stream :inside-height)))
    (multiple-value-bind (ignore current-y)
	(send stream :viewport-position)
      (let ((line-height (send stream :line-height)))
	(do ((y current-y (- y line-height)))
	    ((< y line-height))
	  (send stream :set-viewport-position 0 y)))
      (send stream :set-viewport-position 0 0))))

(defun smbx-test-3d (&optional (stream *dw-stream*))
  (let ((line-height (send stream :line-height))
	(max-y (send stream :maximum-y-position)))
    (send stream :set-viewport-position 0 0)
    (do ((y 0 (+ y line-height)))
	((> y max-y))
      (send stream :set-viewport-position 0 y))))


(let ((stream *dw-stream*))
  (send stream :clear-history)
  (send stream :expose)
  (dw:with-output-recording-disabled (stream)
    (time (concentric-ellipses))
    )
  (send stream :deactivate)
    )


On FUJI
Genera 7.2
May-Day-PCL
CLIM 0.9 + patches
                                 Recording
                          T                    NIL
                      DW    CLIM           DW      CLIM

VERTICAL-LINES        3.3    9.4           1.9      4.4
CONCENTRIC-SQUARES     .5    2.3            .3      1.4
CONCENTRIC-ELLIPSES   2.3    3.5           1.8      2.7
EMPTY-TEMP-WINDOWS   20.0   27.0
TEXT-WINDOW           5.0    7.8

SMBX-TEST-3A          3.4   24.5           1.8     21.1
SMBX-TEST-3B          6.3   25.5           2.7     22.2
SMBX-TEST-3C         10.0  145.0
SMBX-TEST-3D          7.0   70.2

On BUGS
Genera 8.0.1
CLOS
Devo CLIM
                                 Recording
                          T                    NIL
                      DW    CLIM           DW      CLIM

VERTICAL-LINES        2.7    2.7           1.1      1.9
CONCENTRIC-SQUARES     .5     .6            .7       .5
CONCENTRIC-ELLIPSES    .6     .7            .6       .5
EMPTY-TEMP-WINDOWS   93.6   82.7
TEXT-WINDOW          21.2   21.2

SMBX-TEST-3A          2.4   12.7           2.9     11.8
SMBX-TEST-3B          5.8   13.6           3.2     12.6
SMBX-TEST-3C         40.5   74.2
SMBX-TEST-3D         19.0   48.0

On DIAMONDHEAD
Genera 7.2
May-Day-PCL
Devo CLIM
                                 Recording
                          T                    NIL
                      DW    CLIM           DW      CLIM

VERTICAL-LINES        3.8    9.0           2.3      4.5
CONCENTRIC-SQUARES     .6    2.1            .3      1.2
CONCENTRIC-ELLIPSES   2.5    3.7           2.1      2.9
EMPTY-TEMP-WINDOWS   19.4   26.2
TEXT-WINDOW           4.5    8.0          

SMBX-TEST-3A          3.4   25.0                   21.5
SMBX-TEST-3B          6.8   26.5                   22.7
SMBX-TEST-3C         18.8   72.2
SMBX-TEST-3D          7.0   17.0
