;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-TEST; Base: 10 -*-

(in-package :clim-test)

(define-clim-test draw-a-rectangle (window)
  "Draw a rectangle from (50,50) to (100,100)"
  (draw-rectangle* window 50 50 100 100))

(define-clim-test draw-a-gray-rectangle (window)
  "Draw a gray rectangle from (50,50) to (100,100)"
  (draw-rectangle* window 50 50 100 100 :ink +gray+))

(define-clim-test draw-a-red-rectangle (window)
  "Draw a red rectangle from (50,50) to (100,100)"
  (draw-rectangle* window 50 50 100 100 :ink +red+))

(define-clim-test draw-rectangles (window)
  "Draw some rectangles"
  (draw-grid window)
  (draw-some-rectangles window))

(define-clim-test (draw-recorded-rectangles :output-recording t) (window)
  "Draw rectangles with output recording turned on."
  (draw-rectangles window))

(define-clim-test draw-gray-rectangles (window)
  "Draw some different gray rectangles"
  (draw-grid window)
  (draw-some-rectangles window *gray-wheel*))

(define-clim-test draw-colored-rectangles (window)
  "Draw some different colored rectangles"
  (draw-grid window)
  (draw-some-rectangles window *color-wheel*))

(define-clim-test draw-transformed-rectangles-1 (window)
  "Draw rectangles rotated by PI/6 radians and scaled by (2,3)"
  (draw-grid window)
  (with-scaling (window 2 3)
    (with-rotation (window (float (/ pi 6.0) 1.0))
      (draw-some-rectangles window))))

(define-clim-test draw-transformed-rectangles-2 (window)
  "Draw rectangles scaled by (2,3) and rotated by PI/6 radians"
  (draw-grid window)
  (with-rotation (window (float (/ pi 6.0) 1.0))
    (with-scaling (window 2 3)
      (draw-some-rectangles window))))

(define-clim-test draw-circles (window)
  "Draw some different circles"
  (draw-grid window)
  (draw-some-circles window))

(define-clim-test draw-scaled-circles (window)
  "Draw the same circles with scaling (2,3)"
  (draw-grid window)
  (with-scaling (window 2 3)
    (draw-some-circles window)))

(define-clim-test (draw-some-strings :output-recording t) (window)
  "Draw some colored strings"
  (let ((y-coordinate 10)
	(*package* ci::*clim-package*))
    (dolist (color '(red green blue black white))
      (let ((color-var (fintern "+~A+" color)))
	(with-drawing-options (window :ink (symbol-value color-var))
	  (draw-text* window (format nil "A ~(~A~) string." color)
		      20 (incf y-coordinate 10)))))))

(defparameter *Gettysburg-address*

	      "

Fourscore and seven years ago our forefathers
brought forth on this continent a new nation,
conceived in Liberty, and dedicated to the
proposition that all men are created equal.
Now we are engaged in a great civil war,
testing whether that nation, or any nation so
conceived and so dedicated, can long endure.
We are met on a great battlefield of that
war.  We have come to dedicate a portion of
that field, as a final resting place for
those who here gave their lives that that
nation might live.  It is altogether fitting
and proper that we do so.  But, in a larger
sense, we cannot dedicate -- we cannot
consecrate -- we cannot hallow this ground.
The brave men, living and dead, who struggled
here, have consecrated it far above our poor
power to add or detract.  The world will
little note, nor long remember, what we say
here, but it can never forget what they did
here.  It is for us, the living, rather, to
be dedicated here to the unfinished work
which they who fought here have thus far so
nobly advanced.  It is rather for us to be
here dedicated to the great task remaining
before us -- that from these honored dead we
take increased devotion to that cause for
which they gave the last full measure of
devotion -- that we here highly resolve that
these dead shall not have died in vain --
that this nation, under God, shall have a new
birth of freedom -- and that government of
the people, by the people, and for the
people, shall not perish from the earth.

			-- Abraham Lincoln, 19 November 1863
")

#||

;;; Short enough to fit in single window.
(defparameter *Gettysburg-address*
	      '"Fourscore and seven years ago our forefathers brought forth on
this continent a new nation, conceived in Liberty, and
dedicated to the proposition that all men are created equal.

[...]

It is rather for us to be here dedicated to the great task
remaining before us -- that from these honored dead we take
increased devotion to that cause for which they gave the last
full measure of devotion -- that we here highly resolve that
these dead shall not have died in vain -- that this nation,
under God, shall have a new birth of freedom -- and that
government of the people, by the people, and for the people,
shall not perish from the earth.

			-- Abraham Lincoln, 19 November 1863
")
||#

(define-clim-test write-text (window)
  "Write some text"
  (write-string *Gettysburg-address* window))

(define-clim-test write-mixed-text (window)
  "Write some text in varying character styles"
  (flet ((limits (string)
	   (let ((start (search string *Gettysburg-address*)))
	     (values start (and start (+ start (length string)))))))
    (multiple-value-bind (p1 p2) (limits "Fourscore and seven years ago")
      (multiple-value-bind (p3 p4) (limits "Abraham Lincoln")
	(write-string *Gettysburg-address* window :start 0 :end p1)
	(with-text-face (':bold window)
	  (write-string *Gettysburg-address* window :start p1 :end p2))
	(write-string *Gettysburg-address* window :start p2 :end p3)
	(with-text-face (':italic window)
	  (write-string *Gettysburg-address* window :start p3 :end p4))
	(write-string *Gettysburg-address* window :start p4)))))

(define-clim-test (write-recorded-text :output-recording t) (window)
  "Write some text with output recording turned on.  Try clicking in scroll bar."
  (write-mixed-text window))

(define-clim-test write-colored-text (window)
  "Write text in blue"
  (with-drawing-options (window :ink +blue+)
    (write-mixed-text window)))
