;;; -*- Mode: LISP; Syntax: Common-lisp; Base: 10; Package: CLIM-DEMO -*-

(in-package "CLIM-DEMO")

(defun clim-scroller (&key (server-path *default-server-path*)
			   (hs 600)
			   (vs #+Imach 200 #-Imach 400))
  (let ((framem (find-frame-manager :server-path server-path))
	(frame (make-frame 'frame))
	pane)
    (with-look-and-feel-realization (framem frame)
      (setf (frame-pane frame)
	    (scrolling (:hs+ +fill+ :vs+ +fill+ :hs hs :vs vs
			     :subtransformationp t )
	      (setf pane (make-pane 'extended-stream-pane))))
      (adopt-frame framem frame)
      (enable-frame frame)

      (values pane frame))))

;;;
;;; A new implementation of CLIM SCROLLERs.  This attempts to put the window where
;;; you really say you want it.

(defvar *quadrant* :lower-left)
(defconstant +quadrant-list+ '(:upper-left :upper-right :lower-right :lower-left))

(defun incf-quadrant ()
  (setf *quadrant* (nth (mod (1+ (position *quadrant* +quadrant-list+))
			     (length +quadrant-list+))
			+quadrant-list+)))

(defun make-geometry (frame-manager width height left top right bottom quadrant)

  (unless (or quadrant
	      (and left width) (and right width) (and left right)
	      (and bottom height) (and top height) (and top bottom))
    (setf quadrant (incf-quadrant)))

  (when (and left right width) (assert (= width (- right left))))
  (when (and top bottom height) (assert (= height (- bottom top))))

  (multiple-value-bind (max-width max-height)
      (bounding-rectangle-size (sheet-region (ws::graft frame-manager)))
	
    (when (null width)
      (setf width (cond ((and left right) (- right left))
			(right right)
			(left (- max-width left))
			(t  (floor max-width 2)))))
    (setf width (max 0 (min width max-width)))
    (when (null left)
      (setf left (if right (max (- right width) 0)
		     (ecase quadrant
		       ((:upper-left  :lower-left ) 0)
		       ((:upper-right :lower-right) (- max-width width))))))

    (when (null height)
      (setf height (cond ((and top bottom) (- top bottom))
			 (top top)
			 (bottom (- max-height bottom))
			 (t (floor max-height 2)))))
    (setf height (max 0 (min height max-height)))
    (when (null bottom)
      (setf bottom (if top (max (- top height) 0)
		       (ecase quadrant
			 ((:lower-left :lower-right) 0)
			 ((:upper-left :upper-right) (- max-height height)))))))

  `(:left ,left :bottom ,bottom :width ,width :height ,height))

(defvar *clim-window-counter* 0)

(defun make-clim-window (&key (server-path *default-server-path*) (scroll-bars :vertical)
			      (streamp t)
			      width height left top right bottom quadrant (background +white+)
			      plain
			      (title (format nil "CLIM window ~D" (incf *clim-window-counter*)))
			      new-scrolling)
  "Make a CLIM window; scroll-bars in {:vertical :horizontal :both nil},
	quadrant in {nil :upper-left :upper-right :lower-left :lower-right}"
  (let* ((framem (find-frame-manager :server-path server-path))
	 (frame (make-frame 'frame :command-table 'w::user-command-table))
	 (geometry (make-geometry framem width height left top right bottom quadrant))
	 pane)
    (multiple-value-bind (vertical-scroll-off horizontal-scroll-off)
	(ecase scroll-bars
	  ((:both t) (values nil nil))
	  (:horizontal (values t nil))
	  (:vertical (values nil t))
	  ((:neither nil) (values t t)))
      (with-look-and-feel-realization (framem frame)
	(setf (frame-pane frame)
	      (cond (streamp
		     (if new-scrolling
			 ;; New scrolling, using adaptive scroll bar
			 (make-pane 'ws::scroller-pane
				    :hs 300 :vs 200
				    :hs+ +fill+ :vs+ +fill+
				    :hs- +fill+ :vs- +fill+
				    :contents (setf pane
						    (make-pane 'ci::new-extended-stream-pane
							       :background background))
				    :scroll-bars scroll-bars)
			 ;; "old" scrolling
			 (scrolling (:hscrolling-p vertical-scroll-off	; worst possible use of
				     :vscrolling-p horizontal-scroll-off	; these keywords, IMHO -- rsl
				     :hs+ +fill+ :vs+ +fill+
				     :hs 1 :vs 1		;---These are required: get ZERODIVIDE without
				     :subtransformationp t)
				    (setf pane (make-pane 'extended-stream-pane :background background)))))
		    (t (setf pane (make-pane 'ws::basic-clim-pane
					     :hs 300 :vs 200
					     :hs+ +fill+ :vs+ +fill+
					     :hs- +fill+ :vs- +fill+)))))
	(adopt-frame framem frame)
	(apply #'reset-frame frame :title title :plain plain geometry)
	(enable-frame frame)
	(values pane frame)))))



