;;; -*- Mode: LISP; Syntax: Common-lisp; Base: 10; Package: CLIM -*-

(in-package 'clim)

;;; Expanded version of function from ws-test.lisp, with keywords
(defun clim-stream (&key (host *default-host*) (port-type *default-port-type*)
			 (display-id *default-display-id*))
  (let ((framem (find-frame-manager :host host :display-id display-id
				    :port-type port-type))
        (frame (make-frame 'frame)))
    (with-look-and-feel-realization (framem frame)
      (setf (frame-pane frame)
	    (spacing (:space 2)
		     #-Imach(make-pane'extended-stream-pane
			       :hs 600 :vs 350)
		     #+Imach(make-pane'extended-stream-pane
			       :hs 600 :vs 200)
		     ))
      (adopt-frame framem frame)
      (enable-frame frame)
      (values (sheet-child (frame-pane frame)) frame))))

(defun clim-scroller (&key (host *default-host*) (port-type *default-port-type*)
			   (display-id *default-display-id*)
			   (hs 600)
			   (vs #+Imach 200 #-Imach 400)
			   make-frame-options)
  (let ((framem (find-frame-manager :host host :display-id display-id
				    :port-type port-type))
	(frame (apply #'make-frame 'frame make-frame-options)))
    (with-look-and-feel-realization (framem frame)
      (setf (frame-pane frame)
	    (scrolling (:subtransformationp t 
		       :hs+ +fill+ :vs+ +fill+ :hs hs :vs vs)
	      (make-pane 'extended-stream-pane)))
      (adopt-frame framem frame)
      (enable-frame frame)
      (values (do ((stream (frame-pane frame) (sheet-child stream)))
		  ((typep stream 'extended-stream-pane) stream))
	      frame))))



