;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10; Lowercase: Yes -*-

(in-package #-ansi-90 "USER" #+ansi-90 "CL-USER")

#+PCL
(pcl::precompile-random-code-segments clim)

#+(and Genera (not PCL))
(when (scl:fboundp 'clos-internals::ensure-all-constructor-functions)
  (clos-internals::ensure-all-constructor-functions))

#+(and Allegro (version>= 4.0))
;;; I believe this is equivalent to the PRECOMPILE-RANDOM-CODE-SEGMENTS
;;; call above. --- rsl
(dolist (generator-entry clos::*dfun-constructors*)
  (let ((generator (car generator-entry)))
    (dolist (args (cdr generator-entry))
      (apply #'clos::get-dfun-constructor generator (car args)))))

#+(and Allegro (version>= 4.0))
;;; JKF says this will help too.
(dolist (eff clos::*effective-methods*)
  (clos::get-effective-method-generator-eff (clos::eff-body eff)))


;;; This doesn't really belong here, but I want to add the feature
;;; only when the last file has been loaded.
(pushnew :clim *features*)
(pushnew :clim-development *features*)

;;; No precise meaning, but at least new transformation/region classes
(pushnew :clim-two *features*)

;;; In the development hierarchy, this representes the highest patch
;;; number from the "released" CLIM that has been migrated.
(defvar *clim-patch-level* 0)

;;; One day this can use some more hairy database.
(defun clim-version ()
  #+Genera (declare (values major-version minor-version descriptive-string))
  (values 'development
	  *clim-patch-level*
	  "In-house development"))

#+Genera
(progn
  (scl:defflavor CLIM-private-patch-info ((description)) ())
  (scl:defmethod (sct::private-patch-info-description CLIM-private-patch-info) ()
    (or description
	(multiple-value-bind (release ECO-level descriptive-string)
	    (clim-version)
	  (lisp:format nil "CLIM version: ~D; ECO level ~D~@[ ~A~]."
		       release ECO-level descriptive-string))))
  (scl:defmethod (sct::private-patch-info-pathname CLIM-private-patch-info) ()
    #.sys:fdefine-file-pathname)
  (unless (find-if #'(lambda (x) (typep x 'CLIM-private-patch-info)) sct::*private-patch-info*)
    (push (scl:make-instance 'CLIM-private-patch-info) sct::*private-patch-info*)))

#-Ansi-90
(provide :CLIM)
