(in-package "CL-USER")

;;; The Environment

(defvar *clim-is-loaded* nil)
(defvar *loaded-file-alist* nil)

(let ((old-purge (purge-functions))
      (old-optimize (declaration-information 'optimize))
      (bin-directory
       (make-pathname :host "CLIM" 
                      :directory '(:relative (:logical "binary"))))
      ;; These are just the ones believed to work.
      (all-demos '("address-book" 
                   "graphics-demos"
                   "cad-demo"
                   "mas-b-back-propagation"))
      (all-tests '("clim-output-benchmarks"))
      (compilation (unless *clim-is-loaded*
                     :load))
      (demos nil)
      (tests nil)
      (save nil))
  (unwind-protect
    (progn
      (purge-functions t)
      (proclaim '(optimize
                  (speed 2)
                  (safety 1)
                  (space 3)))
      (load-logical-pathname-translations "clim")
      (block go
        (loop
          (format t "~&Will do the following steps:~@
                  ~A~:[~*~;~@
                  Load the following demos:  ~{~A~^, ~}~]~:[~*~;~@
                  Load the following tests:  ~{~A~^, ~}~]~:[~*~;~@
                  Save the result in ~A.~]~@
                  Type any of these commands:~@
                  L(oad), C(compile), R(ecompile), N(one) -- Load/compile all of CLIM~@
                  S(ave) <file> -- Save a CLIM application.~@
                  D(emos) {<name>}*, T(ests) {<name>}* -- Compile/load name={wildcards|all|none}~@
                  G(o) to start.~@
                  > "
                  (cdr (assoc compilation '((:load ."Load CLIM")
                                            (:compile . "Compile CLIM")
                                            (:Recompile . "Recompile CLIM")
                                            (nil . "Don't load CLIM"))))
                  (and compilation demos) demos
                  (and compilation tests) tests
                  (and (eq compilation :load) save) (when save (merge-pathnames save "clim:")))
          (let* ((cmd-line (string-trim " 	"
                                        (read-line)))
                 (argpos (position #\Space cmd-line))
                 (cmd (intern (string-upcase (subseq cmd-line 0 argpos)) "KEYWORD"))
                 (argline (when argpos 
                            (string-trim "	 "
                                         (subseq cmd-line (1+ argpos)))))
                 (args nil))
            (when argline
              ;; avoid loading loop
              (block done
                (loop (when (equal argline "")
                        (return-from done))
                      (let* ((pos (position #\Space argline))
                             (char (char argline 0)))
                        (multiple-value-bind (start end)
                                (if (not (eql char #\"))
                                  (values 0 pos)
                                  (values 1 (position #\" argline
                                                      :start 1)))
                          (let ((arg (subseq argline start end)))
                            (push arg args)
                            (unless end
                              (return-from done))
                            (setq argline
                                  (string-trim " 	"
                                               (subseq argline (1+ end)))))))))
              (setq args (nreverse args)))
            (flet ((process-arglist (current all pathname)
                      (dolist (arg args)
                        (cond ((string-equal arg "none")
                               (setq current nil))
                              ((string-equal arg "all")
                               (setq current all))
                              ((eql (char arg 0) #\-)
                               (setq current (remove (subseq arg 1) current :test #'equal)))
                              ((find #\* arg)
                               (dolist (p (reverse (directory (make-pathname :name arg
                                                                             :defaults pathname))))
                                 (pushnew (pathname-name p) current :test #'equal)))
                              (t (pushnew arg current :test #'equal))))
                      (sort current #'string-lessp)))
              (case cmd
                ((:d :demo :demos)
                 (setq demos (process-arglist demos all-demos "clim:demo;*.lisp")))
                ((:t :test :tests)
                 (setq tests (process-arglist tests all-tests "clim:test;*.lisp")))
                ((:l :load)
                 (setq compilation :load))
                ((:c :comp :comple :compile)
                 (setq compilation :compile)
                 (when save
                   (format t "~&Can't compile and save.  Turning off save.~%")
                   (setq save nil)))
                ((:n :none :no)
                 (setq compilation nil))
                ((:r :re :recomp :recompile)
                 (setq compilation :recompile)
                 (when save
                   (format t "~&Can't compile and save.  Turning off save.~%")
                   (setq save nil)))
                ((:s :save)
                 (setq save (first args))
                 (unless (eq compilation :load)
                   (format t "~&Must load only before saving.~%")
                   (setq compilation :load)))
                ((:g :go)
                 (return-from go))
                (otherwise
                 (format t "~&~A is not recognized.~%" cmd)))))))
      (case compilation
        ((:load :compile :recompile nil)
         (labels ((pathname-equal-internal (x y)
                      (typecase x
                        (symbol (eq x y))
                        (string (string-equal x y))
                        (list (and (listp y)
                                   (every #'pathname-equal-internal x y)))
                        (t (equal x y))))
                  (pathname-equal (p1 p2)
                    (and (equal (pathname-host p1) (pathname-host p2))
                         (equal (pathname-device p1) (pathname-device p2))
                         (pathname-equal-internal (pathname-directory p1) (pathname-directory p2))
                         (equal (pathname-name p1) (pathname-name p2))
                         (equal (pathname-type p1) (pathname-type p2))
                         (equal (pathname-version p1) (pathname-version p2))))
                  (create-bin-directory (pathname)
                                        (let* ((path (translate-logical-pathname pathname))
                                               (dir (pathname-directory path))
                                               (dirname (first (last dir)))
                                               (ndir (butlast dir))
                                               (dirpath (make-pathname :name dirname
                                                                       :type :unspecific
                                                                       :directory ndir
                                                                       :defaults path)))
                                          (ccl:create-directory dirpath)
                                          pathname))
                  (doit (src-path &key compile-only no-source-ok)
                        (let ((bin-path (make-pathname :type "fasl"
                                                       :defaults (merge-pathnames bin-directory
                                                                                  src-path)))
                              (src-path (make-pathname :type "lisp"
                                                       :defaults src-path)))
                          (unless (ccl::directory-exists-p bin-path)
                            (create-bin-directory bin-path))
                          (case compilation
                            ((:load nil))
                            (otherwise
                             (when (or (not no-source-ok)
                                       (probe-file src-path))
                               (when (or (not (probe-file bin-path))
                                         (> (file-write-date src-path)
                                            (file-write-date bin-path)))
                                 (compile-file src-path
                                               :output-file bin-path
                                               :verbose t)))))
                          (unless compile-only
                            (let ((bucket (assoc bin-path *loaded-file-alist*
                                                 :test #'pathname-equal)))
                              (when (or (null bucket)
                                        (< (second bucket)
                                           (file-write-date bin-path)))
                                (load bin-path :verbose t)
                                (unless bucket 
                                  (push (setq bucket (list bin-path 0)) *loaded-file-alist*))
                                (setf (second bucket) (file-write-date bin-path))))))))
           (doit "clim:sys;load-CLIM-Mac" :compile-only t :no-source-ok t)
           (doit "clim:sys;defsystem" :no-source-ok t)
           (doit "clim:sys;sysdcl" :no-source-ok t)
           (set (intern "*AUTO-CREATE-OUTPUT-DIRECTORIES*" "DEFSYSTEM") t)
           (ecase compilation
             (:compile (compile-clim))
             (:recompile (compile-clim :recompile t))
             (:load (load-clim))
             ((nil)))
           (setq *clim-is-loaded* t)
           (dolist (demo demos)
             (doit (make-pathname :name demo :defaults "clim:demo;")))
           (dolist (test tests)
             (doit (make-pathname :name test :defaults "clim:test;")))
           (when save
             (set '*patch-major-version*
                   (with-open-file (str "clim:major-version.number"
                                        :if-does-not-exist nil)
                     (if (null str)
                       (if (boundp '*patch-major-version*)
                         (1+ (symbol-value '*patch-major-version*))
                         10)
                       (read str))))
             (with-open-file (str "clim:major-version.number"
                                  :direction :output
                                  :if-exists :overwrite)
               (write (1+ (symbol-value '*patch-major-version*)) :stream str))
             (when (and (boundp '*old-listener-window-size*)
                        (boundp '*old-listener-window-position*))
               ;; If an init file has move the listeners, move them back.
               ;; Otherwise they might start up off the screen or something.
               (setq *listener-window-size* (symbol-value '*old-listener-window-size*)
                     *listener-window-position* (symbol-value '*old-listener-window-position*)))
             (dump-clim :name save))))))
    (purge-functions old-purge)
    (proclaim `(optimize ,@old-optimize))))
