;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-STREAM; Base: 10 -*-

;;; This file might want to be in the ON-X package. --- rsl

(in-package "CLIM-STREAM")

"Copyright (c) 1989, 1990, 1991 International Lisp Associates.  All rights reserved."

;;; Character-drawing methods for CLX implementation

(defmacro with-X-stream-glyph-for-character (&body body)
  `(macrolet ((stream-glyph-for-character (medium character appearance &optional our-font)
		`(multiple-value-bind (character-set index)
		     (char-character-set-and-index ,character)
		   (when (eql character-set *standard-character-set*)
		     ;; A little gross, but right, I think:
		     (setf index (xlib::char->card8 ,character)))
		   (let* ((x-font (or ,our-font
				      ;;--- Need some portable function to call
				      (realize-text-style (port ,medium) ,appearance)
				      #+ignore
				      (text-style-mapping (port ,medium)
							  character-set ,appearance)))
			  (escapement-x (xlib:char-width x-font index))
			  (escapement-y 0)
			  (origin-x 0)
			  (origin-y (xlib:font-ascent x-font))
			  (bb-x escapement-x)
			  (bb-y (+ origin-y (xlib:font-descent x-font))))
		     (values index x-font escapement-x escapement-y
			     origin-x origin-y bb-x bb-y)))))
     ,@body))

(defmethod stream-glyph-for-character
	   ((medium on-x::basic-x-medium) character appearance
	    &optional our-font)
  #+Genera (declare (values index font escapement-x escapement-y 
			    origin-x origin-y bb-x bb-y))
  (with-X-stream-glyph-for-character
      (stream-glyph-for-character medium character appearance our-font)))

(defmethod stream-scan-string-for-writing  ((stream output-protocol-mixin)
					    (medium on-x::basic-x-medium)
					    string start end
					    style cursor-x max-x
					    &optional glyph-buffer)
  #+Genera (declare
	    (values write-char next-char-index new-cursor-x
		    new-baseline new-height font))
  (with-x-stream-glyph-for-character
    (stream-scan-string-for-writing-body)))








