;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-STREAM; Base: 10; Lowercase: Yes -*-

(in-package "CLIM-STREAM")

"Copyright (c) 1988, 1989, 1990 International Lisp Associates.  All rights reserved."

;;; Encapsulating-stream-mixin needs to be defined early on, because many methods are
;;; written on this class.

;;; What about xstream (multiple self) problem?
(defclass encapsulating-stream-mixin (fundamental-stream)
     ((stream :initarg :stream))
  )

(defgeneric encapsulating-stream-p (stream))

(defmethod encapsulating-stream-p ((stream t)) nil)

(defmethod encapsulating-stream-p ((stream encapsulating-stream-mixin)) t)

;;;

(defmethod input-stream-p ((stream encapsulating-stream-mixin))
  (with-slots (stream) stream
    (input-stream-p stream)))

(defmethod output-stream-p ((stream encapsulating-stream-mixin))
  (with-slots (stream) stream
    (output-stream-p stream)))

(defmethod stream-element-type ((stream encapsulating-stream-mixin))
  (with-slots (stream) stream
    (stream-element-type stream)))

;;;

(defmacro define-protocol-p-method (method-name class-name)
  `(define-group ,method-name define-protocol-p-method
     (defgeneric ,method-name (entity))
     (defmethod ,method-name ((entity t))
       nil)
     (defmethod ,method-name ((entity ,class-name))
       t)
     (defmethod ,method-name ((estream encapsulating-stream-mixin))
       ;; pass it on.
       (with-slots (stream) estream
	 (,method-name stream)))))

;;; For communication through parsers to lower levels.
;;; Later, clever use of macrolet can replace this.
(defvar *input-wait-test* nil)
(defvar *input-wait-handler* nil)
(defvar *pointer-button-press-handler* nil) 

;;; Moved from CLIM-DEFS because STREAM-OUTPUT-RECORDING uses it...

;;;  There really should be a file full of these macro definitions someplace.
(defmacro with-output-recording-options ((stream &key (draw-p nil draw-p-supplied)
						      (record-p nil record-p-supplied))
					 &body body)
  (let ((new-stream (gensymbol 'stream)))
    `(let ((,new-stream ,stream))
       (flet ((with-output-recording-options-body () ,@body))
	 (declare (dynamic-extent #'with-output-recording-options-body))
	 (with-output-recording-options-internal
	   ,new-stream
	   ,(if draw-p-supplied draw-p `(stream-draw-p ,new-stream))
	   ,(if record-p-supplied record-p `(stream-record-p ,new-stream))
	   #'with-output-recording-options-body)))))

