;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-STREAM; Base: 10 -*-

(in-package "CLIM-STREAM")

"Copyright (c) 1988, 1989, 1990 International Lisp Associates.  All rights reserved."

;;; Pointers and pointer actions

(defclass pointer
	 ()
    ((root :accessor pointer-root :initform nil :initarg :root)
     (window :accessor pointer-window :initform nil)
     ;; Position in root coordinates 
     (x-position :accessor pointer-x-position :initform 0)
     (y-position :accessor pointer-y-position :initform 0)
     (native-x-position :accessor pointer-native-x-position :initform 0)
     (native-y-position :accessor pointer-native-y-position :initform 0)
     (button-state :accessor pointer-button-state :initform 0)
     (position-changed :accessor pointer-position-changed)
     (cursor-pattern :accessor pointer-cursor-pattern)
     (cursor-width :accessor pointer-cursor-width)
     (cursor-height :accessor pointer-cursor-height)
     (cursor-x-offset :accessor pointer-cursor-x-offset)
     (cursor-y-offset :accessor pointer-cursor-y-offset)))

#-Silica
(progn
(defmethod entity-position ((pointer pointer))
  (with-slots (x-position y-position) pointer
    (values x-position y-position)))

(defmethod entity-set-position ((pointer pointer) new-x new-y)
  (with-slots (x-position y-position position-changed) pointer
    (setf x-position new-x)
    (setf y-position new-y)
    (setf position-changed t))
  (values new-x new-y))
)

;;; Should have just made pointers obey region protocol
#+Silica
(defun pointer-position* (pointer)
  (values (pointer-x-position pointer)
	  (pointer-y-position pointer)))

#+Silica
(defun pointer-set-position* (pointer new-x new-y)
  (setf (pointer-x-position pointer) new-x)
  (setf (pointer-y-position pointer) new-y))

#+Silica
(defun pointer-set-native-position (pointer new-x new-y)
  (setf (pointer-native-x-position pointer) new-x)
  (setf (pointer-native-y-position pointer) new-y))

(defmethod pointer-decache ((pointer pointer))
  (with-slots (window) pointer
    ;; Beware of the cached stream pane becoming ungrafted.
    (unless (and window (port window))
      (setf window nil))
    (when window
      (let ((native-x-position (pointer-native-x-position pointer))
	    (native-y-position (pointer-native-y-position pointer)))
	(multiple-value-setq (native-x-position native-y-position)
	  (untransform-point* (fetch-native-transformation window) 
			      native-x-position 
			      native-y-position))
	(setf (pointer-x-position pointer) native-x-position
	      (pointer-y-position pointer) native-y-position)))))

(defmethod (setf pointer-window) :before (new-value (pointer pointer))
   (with-slots (window) pointer
     (unless (eql new-value window)
       (when window
	 ;; --- horrible cross-protocol modularity violation here
	 ;; but it's hours before AAAI
	 (when (output-recording-stream-p window)
	   (set-highlighted-presentation window nil))))))

(defmethod query-pointer ((pointer pointer))
  #+Genera
  (declare (values window x y))
  (with-slots (window x-position y-position) pointer
    (values window x-position y-position)))

(defun pointer-state-changed (pointer old-window old-x old-y)
  (multiple-value-bind (window x-position y-position) (query-pointer pointer)
    (values
      (or (not (eql window old-window))
	  (not (eql old-x x-position))
	  (not (eql old-y y-position)))
      window x-position y-position)))

