;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-STREAM; Base: 10 -*-

(in-package "CLIM-STREAM")

"Copyright (c) 1989, 1990, 1991 International Lisp Associates.  All rights reserved."

;;; Character-drawing methods for Genera implementation

;;; This algorithm is a paraphrase of the apparent contents of TV:%DRAW-STRING-CLIPPED-INTERNAL
(defmacro with-genera-stream-glyph-for-character (&body body)
  `(macrolet ((stream-glyph-for-character (medium character appearance &optional our-font)
		`(multiple-value-bind (character-set index)
		     (char-character-set-and-index ,character)
		   ;; For now we are asserting that each string passed
		   ;; to WRITE-STRING will have no appearance changes
		   ;; within it.  This is what our-font is all about.
		   (let* ((font (or ,our-font
				    (text-style-mapping
				      (port ,medium) character-set ,appearance)))
			  (FIT (sys:font-indexing-table font))
			  (LKT (sys:font-left-kern-table font))
			  (CWT (sys:font-char-width-table font))
			  (escapement-x (if (diacritic-char-p ,character) 0
					    (if CWT (aref CWT index)
						(sys:font-char-width font))))
			  (escapement-y 0)
			  (origin-x (if LKT (aref LKT index) 0))
			  (origin-y (sys:font-baseline font))
			  (bb-x (if FIT (- (aref FIT (1+ index)) (aref FIT index))
				    (sys:font-char-width font)))
			  (bb-y (sys:font-char-height font)))
		     (values index font escapement-x escapement-y origin-x origin-y
			     bb-x bb-y)))))
     ,@body))

(defmethod stream-glyph-for-character ((medium on-genera::basic-genera-medium)
				       character appearance &optional our-font)
  #+Genera
  (declare (values index font escapement-x escapement-y origin-x origin-y bb-x bb-y))
  (with-genera-stream-glyph-for-character
    (stream-glyph-for-character medium character appearance our-font)))

(defmethod stream-scan-string-for-writing  ((stream output-protocol-mixin)
					    (medium on-genera::basic-genera-medium)
					    string start end
					    style cursor-x max-x
					    &optional glyph-buffer)
  #+Genera (declare
	     (values write-char next-char-index new-cursor-x new-baseline new-height font))
  (with-genera-stream-glyph-for-character
    (stream-scan-string-for-writing-body)))


