;;; -*- Mode: Lisp; Package: CLIM-STREAM; Base: 10.; Syntax: Common-Lisp -*-

(in-package "CLIM-STREAM")

"Copyright (c) 1989, 1990 International Lisp Associates, Inc."

(defvar *stream-protocols* nil)

(defmacro define-stream-protocol (name &body accessors)
  `(progn
     (defprotocol ,name nil)
     (defrole ,name () ,(map 'list #'(lambda (accessor-name)
				       (list accessor-name :accessor accessor-name))
			     accessors))
     (pushnew ',name *stream-protocols*)))

(defmacro generate-stream-protocol-trampolines ()
  `(progn
     ,@(with-collection
	 (dolist (protocol *stream-protocols*)
	   (collect `(generate-trampolines
		       ,protocol ,protocol
		       encapsulating-stream-mixin
		       `(slot-value ,encapsulating-stream-mixin 'stream)))))))

#||
;;; For example:
;;; The protocol name is output-recording-protocol.
;;;  The accessors are output-recording-stream-output-record and output-recording-stream-mumble
(define-stream-protocol output-recording-protocol
  output-recording-stream-output-record
  output-recording-stream-mumble)

;;; Here is an operation.
(defoperation output-recording-stream-replay output-recording-protocol
  ((stream output-recording-protocol) output-record &optional bounding-rectangle)
  )
||#


