;;; -*- Mode: LISP; Syntax: Common-lisp; Package: SILICA; Base: 10; Lowercase: Yes -*-

;; $fiHeader: transformations.lisp,v 1.4 91/03/26 12:03:18 cer Exp $

(in-package "SILICA")

"Copyright (c) 1991 International Lisp Associates, Inc.  All rights reserved."

;;; This could simply call TYPEP, I suppose.
(defmethod transformationp ((thing transformation)) t)
(defmethod transformationp (thing) nil)

(defmethod regionp ((thing region)) t)
(defmethod regionp (thing) nil)

;;;
;;; ???
;;;  These are here to handle reflecting rectangles used to define areas
;;;  The problem is that reflecting makes the "open" end flip.
;;;  Of course this is still assuming discrete coordinates.
;;;

(defun careful-transform-region (xf r)
  (typecase r
    (nowhere r)
    (rectangle
     (let ((r (transform-region xf r)))
       ;; --- In the "mutable" world, this just mutated this intermediate R,
       ;; --- thereby saving some consing.
       (with-bounding-rectangle* (x1 y1 x2 y2) r
         (cond ((reflection-transformation-p xf)
		(setq r (make-rectangle* x1 (1+ y1) x2 (1+ y2))))
	       ;; Make a fresh copy.
	       (t (setq r (make-rectangle* x1 y1 x2 y2)))))
       r))
    (otherwise
     (error "Can't handle this type of region"))))

(defun careful-untransform-region (xf r)
  (let ((r (untransform-region xf r)))
    (assert (typep r 'rectangle) ()
	    "Can't handle this type of region")
    (with-bounding-rectangle* (x1 y1 x2 y2) r
      (cond ((reflection-transformation-p xf)
	     ;; --- In the "mutable" world, this just mutated this intermediate R,
	     ;; --- thereby saving some consing.
	     (setq r (make-rectangle* x1 (1- y1) x2 (1- y2))))
	    ;; Return a copy
	    (t (setq r (make-rectangle* x1 y1 x2 y2)))))
    r))

(defun careful-transform-rectangle* (xf minx miny maxx maxy)
  ;; --- Yikes!  Consing two rectangles seems a bit excessive.
  (let ((temp-rect (make-rectangle* minx miny maxx maxy)))
    (setq temp-rect
	  (transform-region xf temp-rect))
    (with-bounding-rectangle* (minx miny maxx maxy) temp-rect
      (when (reflection-transformation-p xf)
	(incf miny)
	(incf maxy))
      (values minx miny maxx maxy))))

(defun careful-untransform-rectangle* (xf minx miny maxx maxy)
  ;; --- Yikes!  Consing two rectangles seems a bit excessive.
  (let ((temp-rect (make-rectangle* minx miny maxx maxy)))
    (setq temp-rect
	  (untransform-region xf temp-rect))
    (with-bounding-rectangle* (minx miny maxx maxy) temp-rect
      (when (reflection-transformation-p xf)
	(incf miny)
	(incf maxy))
      (values minx miny maxx maxy))))

(defun transform-rectangle* (transformation min-x min-y max-x max-y)
  ;; --- Cons out the wazoo.
  (let ((rect (make-rectangle* min-x min-y max-x max-y)))
    (setq rect (transform-region transformation rect))
    (bounding-rectangle* rect)))

(defun untransform-rectangle* (transformation min-x min-y max-x max-y)
  ;; --- Cons out the wazoo.
  (let ((rect (make-rectangle* min-x min-y max-x max-y)))
    (setq rect (untransform-region transformation rect))
    (bounding-rectangle* rect)))

(defmethod translation-transformation-tx ((transform translation-transformation))
  (slot-value transform 'tx))

(defmethod translation-transformation-ty ((transform translation-transformation))
  (slot-value transform 'ty))

;;; --- Obviously a kludge.
;;; --- Added 12/22/91 doughty.
(defmethod translation-transformation-tx ((transform identity-transformation))
  0)

(defmethod translation-transformation-ty ((transform identity-transformation))
  0)

;;; ----------------

(defmethod translate-transformation ((transform identity-transformation) dx dy)
  (declare (type real dx dy))
  (let ((dx (float dx 0f0))
	(dy (float dy 0f0)))
    (declare (single-float dx dy))
    (if (and (= dx 0f0) (= dy 0f0))
	transform
	(make-translation-transformation-1 dx dy))))

(defmethod translate-transformation ((transform translation-transformation) dx dy)
  (declare (type real dx dy))
  (let ((dx (float dx 0f0))
	(dy (float dy 0f0)))
    (declare (single-float dx dy))
    (if (and (= dx 0f0) (= dy 0f0))
	transform
	(with-slots (tx ty) transform
	  (declare (single-float tx ty))
	  (let ((tx (+ dx tx))
		(ty (+ dy ty)))
	    (declare (single-float tx ty))
	    (if (and (= tx 0f0) (= ty 0f0))
		+identity-transformation+
		(make-translation-transformation-1 tx ty)))))))

(defmethod translate-transformation ((transform standard-transformation) dx dy)
  (declare (type real dx dy))
  (let ((dx (float dx 0f0))
	(dy (float dy 0f0)))
    (declare (single-float dx dy))
    (if (and (= dx 0f0) (= dy 0f0))
	transform
	(with-slots (mxx mxy myx myy tx ty) transform
	  (declare (single-float mxx mxy myx myy tx ty))
	  (make-standard-transformation-1 mxx mxy myx myy
					  (+ tx dx)
					  (+ ty dy))))))

;;; Scaling
(defmethod scale-transformation
	   ((transform identity-transformation) mx my &optional origin)
  (declare (type real mx my))
  (assert (null origin) nil "Bill & Dennis don't understand origin.")
  (make-scaling-transformation mx my))

(defmethod scale-transformation
	   ((transform translation-transformation) mx my &optional origin)
  (declare (type real mx my))
  (assert (null origin) nil "Bill & Dennis don't understand origin.")
  (let ((mx (float mx 0f0))
	(my (float my 0f0)))
    (declare (single-float mx my))
    (if (and (= mx 1f0) (= my 1f0))
	transform
	(with-slots (tx ty) transform
	  (declare (single-float tx ty))
	  (make-transformation-1 mx 0f0 0f0 my (* tx mx) (* ty my))))))

(defmethod scale-transformation
	   ((transform standard-transformation) mx my &optional origin)
  (declare (type real mx my))
  (assert (null origin) nil "Bill & Dennis don't understand origin.")
  (let ((mx (float mx 0f0))
	(my (float my 0f0)))
    (declare (single-float mx my))
    (if (and (= mx 1f0) (= my 1f0))
	transform
	(with-slots ((mxx1 mxx) (mxy1 mxy) (myx1 myx) (myy1 myy) (tx1 tx) (ty1 ty)) transform
	  (declare (single-float mxx1 mxy1 myx1 myy1 tx1 ty1))
	  (make-transformation-1 (* mxx1 mx) (* mxy1 my) (* myx1 mx) (* myy1 my)
				 (* tx1 mx) (* ty1 my))))))

;;; Rotation
(defmethod compose-rotation-transformation
	   ((transform identity-transformation) angle &optional origin)
  (declare (type real angle))
  (assert (null origin) nil "Bill & Dennis don't understand origin.")
  (make-rotation-transformation angle))

(defmethod compose-rotation-transformation
	   ((transform translation-transformation) angle &optional origin)
  (assert (null origin) nil "Bill & Dennis don't understand origin.")
  (let ((angle (mod (float angle 0f0) (float (* 2 pi) 0f0))))
    (declare (single-float angle))
    (if (= angle 0f0)
	transform
	(with-slots ((tx1 tx) (ty1 ty)) transform
	  (declare (single-float tx1 ty1))
	  (let* ((c (cos angle))
		 (s (sin angle)))
	    (declare (single-float c s))
	    (make-standard-transformation-1
	      c s
	      (- s) s
	      (- (* c tx1) (* s ty1)) (+ (* s tx1) (* c ty1)))
	    #+Ignore ;; Old 1.0 defn appears below.  Why does it have
	    ;; [c (-s) s c] rather than [c s (-s) c]?
	    (make-standard-transformation-1 c (- s) s c tx1 ty1))))))

(defmethod compose-rotation-transformation
	   ((transform standard-transformation) angle &optional origin)
  (assert (null origin) nil "Bill & Dennis don't understand origin.")
  (let ((angle (mod (float angle 0f0) (float (* 2 pi) 0f0))))
    (declare (single-float angle))
    (if (= angle 0f0)
	transform
	(with-slots ((mxx1 mxx) (mxy1 mxy) (myx1 myx) (myy1 myy) (tx1 tx) (ty1 ty)) transform
	  (declare (single-float mxx1 mxy1 myx1 myy1 tx1 ty1))
	  (let* ((c (cos angle))
		 (s (sin angle))
		 ;; --- The 1.0 definition of this has a + wherever we have
		 ;; --- a minus and vice versa.  Someone smart will have to 
		 ;; --- reconcile.
		 (mxx (- (* mxx1 c) (* mxy1 s)))
		 (mxy (+ (* mxy1 c) (* mxx1 s)))
		 (myx (- (* myx1 c) (* myy1 s)))
		 (myy (+ (* myy1 c) (* myx1 s)))
		 (tx  (- (* tx1 c)  (* ty1 s)))
		 (ty  (+ (* tx1 s)  (* ty1 c))))
	    (declare (single-float c s mxx mxy myx myy))
	    (make-transformation-1 mxx mxy myx myy tx ty))))))


;;; intersection

(defmethod region-intersection ((rect1 standard-rectangle) (rect2 standard-rectangle))
  (with-slots ((sx1 min-x) (sy1 min-y) (ex1 max-x) (ey1 max-y)) rect1
    (with-slots ((sx2 min-x) (sy2 min-y) (ex2 max-x) (ey2 max-y)) rect2
      (or (ltrb-intersection sx1 sy1 ex1 ey1
			     sx2 sy2 ex2 ey2)
	  +nowhere+))))
