;;; -*- Mode: Lisp; Package: ON-X; Base: 10.; Syntax: Common-Lisp -*-
;;;
;;; Copyright (c) 1989, 1990 by Xerox Corporation.  All rights reserved. 
;;;

(in-package "ON-X")

;;;
;;; Translaters
;;;

(defmacro x-button-number->standard-button-name (code)
  `(aref '#(nil :left :middle :right) ,code))

(defmacro x-button-state->standard-button-state (state)
  `,state)

;;;
;;; Input Querying
;;;

#+ignore
(defmethod slot-unbound (class
			 (port x-port)
			 (slot-name (eql 'rband-gc)))
  (declare (ignore class))
  (with-slots (rband-gc x-root x-screen) port
    (setf rband-gc (xlib:create-gcontext
		    :drawable x-root
		    :function boole-xor
		    :stipple (realize-shade port *gray*)
		    :line-size 0
		    :foreground (xlib:screen-black-pixel x-screen)
		    :subwindow-mode :include-inferiors))))

(defmethod do-poll-pointer ((port x-port) sheet)
  (multiple-value-bind (x y same-screen-p child mask)
      (xlib:query-pointer (sheet-mirror sheet))
    (declare (ignore same-screen-p child))
    (values x y mask)))

(defmethod prompt-for-location ((port x-port))
  (with-event-process-stopped (port)
    (with-slots (x-root x-display height-pixel) port
      (multiple-value-bind (x y)
	  (clx-utils:clx-prompt-for-screen-location 
	   x-root x-display 
	   (realize-cursor port :position))
	(values x (- height-pixel y))))))

;;
;; ???
;; The following should take args in root coodinate system, but right now they
;; assume a sw coord system
;;
;; Also they rounds for client convenience, though in the future, I'll force
;; clinet to be in the graft's native coordinate system on this call.
;;

(defmethod prompt-for-region ((port x-port) left bottom width height)
  (with-event-process-stopped (port)
    (with-slots (x-root x-display height-pixel rband-gc) port
      (multiple-value-setq 
	  (left bottom width height)
	(clx-utils:clx-prompt-for-screen-region 
	 x-root x-display rband-gc
	 (realize-cursor port :upper-left) 
	 (realize-cursor port :lower-left)
	 (realize-cursor port :upper-right)
	 (realize-cursor port :lower-right)
	 (round left) (round (- height-pixel bottom)) 
	 (round width)
	 (round height)))
      (values left (- height-pixel bottom height) width height))))

(defmethod prompt-for-region-location ((port x-port) width height)
  (with-event-process-stopped (port)
    (with-slots (x-root x-display rband-gc height-pixel) port
      (multiple-value-bind (x y)
	  (clx-utils:clx-prompt-for-screen-region-location 
	   x-root x-display 
	   (realize-cursor port :upper-left) rband-gc
	   (round width)
	   (round height))
	(values x (- height-pixel y height))))))



;;;
;;; Invoking Input Contract
;;;

(defmacro invoke (&rest rest-keys)
  `(queue-input 
     contract
     :sheet sheet
     :time time
     :x x :y y
     :state (x-button-state->standard-button-state state)
     ,@rest-keys))

(defmethod dispatch-device-event 
	   ((port x-port) (contract invoking-input-contract)
	    &key sheet event-key time x y state char code &allow-other-keys)
  (when sheet
    (multiple-value-setq (x y)
      (untransform-point* (fetch-native-transformation sheet) x y)))
  (case event-key
    ((:motion-notify :enter-notify :leave-notify)
     (invoke :type :pointer-motion))
    ((:button-press 
      :button-release
      :button-click
      ;; :button-click-hold  ??? Maybe should take these and break them here
      :button-click-click)
     (invoke :type event-key
	     :button (x-button-number->standard-button-name code) ))
    ((:key-press :key-release)
     (when char (invoke :type event-key :char char)))))

(defmethod dispatch-crossing-event
	   ((port x-port) (contract invoking-input-contract) 
	    &key cross-type direction sheet state x y time &allow-other-keys)
  (ecase cross-type
    (:enter (invoke :type :pointer-enter :direction direction))
    (:exit (invoke :type :pointer-exit :direction direction))))

;;;
;;; Standard Input Contract
;;;

(defmacro alloc-and-fill (type &rest keys)
  `(let ((event (allocate-event ,type)))
     (fill-event event sheet time x y  
		 (x-button-state->standard-button-state state)
		 ,@keys)
     event))
    
(defmethod dispatch-device-event 
	   ((port x-port) (contract standard-input-contract)
	    &key event-key time x y state sheet
	    ;; Extras
	    code keysym char
	    &allow-other-keys)
  (macrolet ((be (type) 
	       `(alloc-and-fill 
		 ,type :button (x-button-number->standard-button-name code))))
    (let ((event
	   (case event-key
	     ((:motion-notify :enter-notify :leave-notify)
	      (alloc-and-fill 'motion-event))
	     (:button-press   (be 'button-press-event))
	     (:button-release (be 'button-release-event))
	     (:key-press   (alloc-and-fill 'key-press-event :keysym keysym :char char))
	     (:key-release (alloc-and-fill 'key-release-event :keysym keysym :char char))
	     (:button-click      (be 'click-event))
	     ;; (:button-click-hold (be 'click-hold-event)) ???
	     (:button-click-click (be 'click-click-event)))))
      (queue-event contract event)
      (free-event event))))

(defmethod dispatch-crossing-event
	   ((port x-port) (contract standard-input-contract)
	    &key cross-type time x y state direction sheet &allow-other-keys)
  (ecase cross-type
    (:enter
     (let ((event (alloc-and-fill 'enter-event :direction direction)))
       (queue-event contract event)
       (free-event event)))
    (:exit
     (let ((event (alloc-and-fill 'exit-event :direction direction)))
       (queue-event contract event)
       (free-event event)))))

