;;; -*- Mode: Lisp; Package: ON-X; Base: 10.; Syntax: Common-Lisp -*-

(in-package "ON-X")

"Genera port implementation Copyright (c) 1990 by International Lisp Associates, Inc.
 All rights reserved."

;;; Copy the keysym codes from CLX.
;;; The task of translating a keysym into a character is done at the port level.

(defvar *x-keysym->clim-keysym-table*
	(make-hash-table :test (xlib::keysym->character-map-test)))
(defvar *clim-keysym->x-keysym-table* (make-hash-table))

(defmacro define-keysym (x-keysym clim-keysym)
  `(progn (setf (gethash ,x-keysym *x-keysym->clim-keysym-table*) ',clim-keysym)
	  (unless (gethash ,clim-keysym *clim-keysym->x-keysym-table*)
	    (setf (gethash ,clim-keysym *clim-keysym->x-keysym-table*) ,x-keysym))))

(defun-inline x-keysym->keysym (x-keysym)
  (gethash x-keysym *x-keysym->clim-keysym-table*))

(defun-inline keysym->x-keysym (keysym)
  (gethash keysym *clim-keysym->x-keysym-table*))

(define-keysym 032 :space)
(define-keysym 033 :\!)
(define-keysym 034 :\")
(define-keysym 035 :\#)
(define-keysym 036 :\$)
(define-keysym 037 :\%)
(define-keysym 038 :\&)
(define-keysym 039 :\')
(define-keysym 040 :\()
(define-keysym 041 :\))
(define-keysym 042 :\*)
(define-keysym 043 :\+)
(define-keysym 044 :\,)
(define-keysym 045 :\-)
(define-keysym 046 :\.)
(define-keysym 047 :\/)
(define-keysym 048 :\0)
(define-keysym 049 :\1)
(define-keysym 050 :\2)
(define-keysym 051 :\3)
(define-keysym 052 :\4)
(define-keysym 053 :\5)
(define-keysym 054 :\6)
(define-keysym 055 :\7)
(define-keysym 056 :\8)
(define-keysym 057 :\9)
(define-keysym 058 :\:)
(define-keysym 059 :\;)
(define-keysym 060 :\<)
(define-keysym 061 :\=)
(define-keysym 062 :\>)
(define-keysym 063 :\?)
(define-keysym 064 :\@)
(define-keysym 065 :\A)
(define-keysym 097 :\A)
(define-keysym 066 :\B)
(define-keysym 098 :\B)
(define-keysym 067 :\C)
(define-keysym 099 :\C)
(define-keysym 068 :\D)
(define-keysym 100 :\D)
(define-keysym 069 :\E)
(define-keysym 101 :\E)
(define-keysym 070 :\F)
(define-keysym 102 :\F)
(define-keysym 071 :\G)
(define-keysym 103 :\G)
(define-keysym 072 :\H)
(define-keysym 104 :\H)
(define-keysym 073 :\I)
(define-keysym 105 :\I)
(define-keysym 074 :\J)
(define-keysym 106 :\J)
(define-keysym 075 :\K)
(define-keysym 107 :\K)
(define-keysym 076 :\L)
(define-keysym 108 :\L)
(define-keysym 077 :\M)
(define-keysym 109 :\M)
(define-keysym 078 :\N)
(define-keysym 110 :\N)
(define-keysym 079 :\O)
(define-keysym 111 :\O)
(define-keysym 080 :\P)
(define-keysym 112 :\P)
(define-keysym 081 :\Q)
(define-keysym 113 :\Q)
(define-keysym 082 :\R)
(define-keysym 114 :\R)
(define-keysym 083 :\S)
(define-keysym 115 :\S)
(define-keysym 084 :\T)
(define-keysym 116 :\T)
(define-keysym 085 :\U)
(define-keysym 117 :\U)
(define-keysym 086 :\V)
(define-keysym 118 :\V)
(define-keysym 087 :\W)
(define-keysym 119 :\W)
(define-keysym 088 :\X)
(define-keysym 120 :\X)
(define-keysym 089 :\Y)
(define-keysym 121 :\Y)
(define-keysym 090 :\Z)
(define-keysym 122 :\Z)
(define-keysym 091 :\[)
(define-keysym 092 :\\)
(define-keysym 093 :\])
(define-keysym 094 :\^)
(define-keysym 095 :\_)
(define-keysym 096 :\`)
(define-keysym 123 :\{)
(define-keysym 124 :\|)
(define-keysym 125 :\})
(define-keysym 126 :\~)

(define-keysym (xlib::keysym 255 255) :rubout)
(define-keysym (xlib::keysym 255 009) :tab)
(define-keysym (xlib::keysym 255 010) :linefeed)
(define-keysym (xlib::keysym 009 227) :page)
(define-keysym (xlib::keysym 255 013) :return)
(define-keysym (xlib::keysym 255 008) :backspace)

(define-keysym (xlib::keysym 255 011) :clear-input)
(define-keysym (xlib::keysym 255 106) :help)
(define-keysym (xlib::keysym 255 097) :refresh)
(define-keysym (xlib::keysym 255 105) :abort)
(define-keysym (xlib::keysym 255 087) :end)
(define-keysym (xlib::keysym 255 086) :scroll)
(define-keysym (xlib::keysym 255 104) :complete)

;;; And the shifts
(define-keysym xlib::left-shift-keysym :left-shift)
(define-keysym xlib::right-shift-keysym :right-shift)
(define-keysym xlib::left-control-keysym :left-control)
(define-keysym xlib::right-control-keysym :right-control)
(define-keysym xlib::caps-lock-keysym :caps-lock)
(define-keysym xlib::shift-lock-keysym :shift-lock)
(define-keysym xlib::left-meta-keysym :left-meta)
(define-keysym xlib::right-meta-keysym :right-meta)
(define-keysym xlib::left-super-keysym :left-super)
(define-keysym xlib::right-super-keysym :right-super)
(define-keysym xlib::left-hyper-keysym :left-hyper)
(define-keysym xlib::right-hyper-keysym :right-hyper)

