;;; -*- Mode: Lisp; Base: 10.; Syntax: Common-Lisp; Package: USER -*-
;;;
;;; SILICA (Top Level Defining File)
;;; Copyright (c) 1989, 1990 by Xerox Corporation.  All rights reserved. 
;;;
;;; SILICA is a kernel for building window system and user interface 
;;; software in Common Lisp.
;;; 

(in-package "USER")

(provide "SILICA")
(pushnew :silica *features*)

(clim-lisp:defpackage SILICA
    (:nicknames "SIO2" "W")
  (:use CLIM-UTILS CLIM-LISP CLIM CLIM-SHARED)
  (:shadowing-import-from CLIM-UTILS DYNAMIC-EXTENT DEFMETHOD DEFUN FLET LABELS)
  (:export
   
   ;;;;;;;;;;;;;;;
   ;; GEOMETRY
   ;;
   
   ;; From transformations.lisp
   +identity-transformation+
   compose-with-rotation
   compose-with-scaling
   compose-with-translation
   compose-transformations
   even-scaling-transformation-p
   identity-transformation-p
   invert-transformation
   invertible-transformation-p
   make-3-point-transformation
   make-3-point-transformation*
   make-reflection-transformation
   make-reflection-transformation*
   make-rotation-transformation
   make-rotation-transformation*
   make-scaling-transformation
   make-scaling-transformation*
   make-transformation
   make-translation-transformation
   rectilinear-transformation-p
   reflection-transformation-p
   rigid-transformation-p
   scaling-transformation-p
   transform-distance*
   transform-point*
   transformation
   transformation-equal
   translation-transformation-p
   untransform-distance*
   untransform-point*

   ;; Spec Issues
   copy-transformation

   ;; Naming Issues
   transform-dimensions untransform-dimensions
   transform-rectangle* untransform-rectangle*

   ;; Extra internals that need to be examined.
   translation-x translation-y


   ;; From regions.lisp
   +everywhere+
   +nowhere+
   area
   design
   ellipse
   ellipse-center-point
   ellipse-center-point*
   ellipse-end-angle
   ellipse-radii
   ellipse-start-angle
   elliptical-arc
   line
   line-end-point
   line-end-point*
   line-start-point
   line-start-point*
   make-ellipse
   make-ellipse*
   make-elliptical-arc
   make-elliptical-arc*
   make-line
   make-line*
   make-point
   make-polygon
   make-polygon*
   make-polyline
   make-polyline*
   make-rectangle
   make-rectangle*
   map-over-polygon-coordinates
   map-over-polygon-segments
   map-over-region-set-regions
   max-x max-y min-x min-y ;; Gotta share these slot names with CLIM
   opacity
   opacity-value
   path
   point
   point-position
   point-x
   point-y
   polygon
   polygon-points
   polyline
   polyline-closed
   rectangle
   rectangle-edges*
   rectangle-height
   rectangle-max-point
   rectangle-max-x
   rectangle-max-y
   rectangle-min-point
   rectangle-min-x
   rectangle-min-y
   rectangle-size
   rectangle-width
   region
   region-set
   region-set-function
   region-set-regions
   standard-ellipse
   standard-elliptical-arc
   standard-line
   standard-point
   standard-polygon
   standard-polyline
   standard-rectangle
   transform-region
   untransform-region

   ;; REGION EXTRAS
   ;; Bounding region protocol
   with-bounding-rectangle*
   bounding-rectangle* 
   bounding-rectangle 
   bounding-rectangle-min-x
   bounding-rectangle-min-y
   bounding-rectangle-min-point
   bounding-rectangle-max-x
   bounding-rectangle-max-y
   bounding-rectangle-max-point
   bounding-rectangle-position
   bounding-rectangle-position*
   bounding-rectangle-width
   bounding-rectangle-height
   bounding-rectangle-dimensions

   rectangle-position 
   rectangle-position*
   
   region-equal
   region-contains-region-p
   region-contains-point*-p
   region-intersects-region-p
   region-union
   region-intersection
   region-difference
   
   region-empty-p ;; Not in Spec
   rectangle-dimensions
   
   nowhere everywhere
   
   ;; From designs.lisp
   +blue+
   +cyan+
   +green+
   +magenta+
   +red+
   +white+
   +yellow+
   color
   color-ihs
   color-rgb
   compose-in
   compose-out
   compose-over
   copy-ink
   make-color-ihs
   make-color-rgb
   make-contrasting-inks
   make-design-from-output-record
   make-flipping-ink
   make-gray-color
   make-opacity
   make-pattern
   make-rectangular-tile
   make-stencil

   ;; Stupid colors
   +alice-blue+
   +antique-white+
   +aquamarine+
   +azure+
   +beige+
   +bisque+
   +black+
   +blanched-almond+
   +blue-violet+
   +brown+
   +burlywood+
   +cadet-blue+
   +chartreuse+
   +chocolate+
   +coral+
   +cornflower-blue+
   +cornsilk+
   +dark-goldenrod+
   +dark-green+
   +dark-khaki+
   +dark-olive-green+
   +dark-orange+
   +dark-orchid+
   +dark-salmon+
   +dark-sea-green+
   +dark-slate-blue+
   +dark-slate-gray+
   +dark-turquoise+
   +dark-violet+
   +deep-pink+
   +deep-sky-blue+
   +dim-gray+
   +dodger-blue+
   +firebrick+
   +floral-white+
   +forest-green+
   +gainsboro+
   +ghost-white+
   +gold+
   +goldenrod+
   +gray+
   +green-yellow+
   +honeydew+
   +hot-pink+
   +indian-red+
   +ivory+
   +khaki+
   +lavender+
   +lavender-blush+
   +lawn-green+
   +lemon-chiffon+
   +light-blue+
   +light-coral+
   +light-cyan+
   +light-goldenrod+
   +light-goldenrod-yellow+
   +light-gray+
   +light-pink+
   +light-salmon+
   +light-sea-green+
   +light-sky-blue+
   +light-slate-blue+
   +light-slate-gray+
   +light-steel-blue+
   +light-yellow+
   +lime-green+
   +linen+
   +maroon+
   +medium-aquamarine+
   +medium-blue+
   +medium-orchid+
   +medium-purple+
   +medium-sea-green+
   +medium-slate-blue+
   +medium-spring-green+
   +medium-turquoise+
   +medium-violet-red+
   +midnight-blue+
   +mint-cream+
   +misty-rose+
   +moccasin+
   +navajo-white+
   +navy-blue+
   +old-lace+
   +olive-drab+
   +orange+
   +orange-red+
   +orchid+
   +pale-goldenrod+
   +pale-green+
   +pale-turquoise+
   +pale-violet-red+
   +papaya-whip+
   +peach-puff+
   +peru+
   +pink+
   +plum+
   +powder-blue+
   +purple+
   +rosy-brown+
   +royal-blue+
   +saddle-brown+
   +salmon+
   +sandy-brown+
   +sea-green+
   +seashell+
   +sienna+
   +sky-blue+
   +slate-blue+
   +slate-gray+
   +snow+
   +spring-green+
   +steel-blue+
   +tan+
   +thistle+
   +tomato+
   +turquoise+
   +violet+
   +violet-red+
   +wheat+
   +white-smoke+
   +yellow-green+

   ;;;;;;;;;;;;;;;;; 
   ;; GRAPHICS Types
   ;;
   
   ;; pixmaps
   pixmap make-pixmap pixmapp pixmap-format pixmap-data pixmap-width
   pixmap-height color-table color-count
   pixmap-ncolors pixmap-colors
   write-pixmap-to-file
   realize-pixmap

   ;; cursors
   cursor make-cursor *cursors* available-cursors

   #||
   ;; fonts
   font make-font font-equal *default-font*
   font-family font-size font-rotation font-italic? font-bold? font-face
   font-scale font-ascent font-descent font-height 
   string-width string-height char-width
   realize-font 
   ||#
    
   text-style
   parse-text-style intern-text-style
   text-style-family text-style-face text-style-size 
   merge-text-styles define-character-face-class
   define-character-face-added-mappings define-character-face
   merged-text-style text-style-components
   display-device define-display-device
   define-text-style-mappings add-text-style-mapping
   text-style-mapping standarize-style
   *standard-character-set* *null-text-style*
   *undefined-text-style* *default-text-style*
   text-style-scale text-style-ascent text-style-descent text-style-height
   string-width string-height char-width
   diacritic-char-p
   char-character-set-and-index
    
   ;; shades
   shade *default-shade* 
   *black* *extra-dark-gray* *dark-gray* *light-dark-gray* *gray* 
   *dark-light-gray* *light-gray* *extra-light-gray* *white*
   realize-shade shade-to-color

   +foreground+ +background+ +flipping-ink+
   
   ;; colors
   realize-color
   externalize-color almost-white-p ;; ??
    
   ;; operations
   display-operation *default-operation* *paint* *replace* *invert*
   *erase*

   ;;;;;;;;;;;;;;;;
   ;; CLIM GRAPHICS
   ;;
    
   ;; abstract  & basic clg display medium
   basic-clg-medium basic-clg-display-medium basic-clg-pixmap-medium

   medium-foreground medium-background medium-ink
   medium-text-style 
;;   medium-default-text-style medium-merged-text-style
   medium-line-style medium-transformation medium-clipping-region
   
   with-drawing-options
   with-text-style with-text-face with-text-family with-text-size
   with-translation with-rotation with-scaling
   with-additional-transformation   ;;???
   
   pi-single-float 2pi pi/2
   draw-point draw-point* draw-points draw-points*
   draw-line draw-line* draw-lines draw-lines*
   draw-polygon draw-polygon*
   draw-rectangle draw-rectangle*
   draw-text draw-text* draw-text-rectangle draw-text-rectangle*
   draw-circle draw-circle*
   draw-ellipse draw-ellipse*
   draw-spline draw-spline*
   draw-image draw-image*
   copy-area copy-area*
    
   get-image get-image*
   medium-force-output medium-finish-output

   ;; new graphics macrology
   define-graphics-function-method find-graphics-function
   gf-spread-function-name gf-type gf-spread-lambda-list
   gf-method-argument-list gf-method-lambda-list gf-spread-arguments
   copy-line-style
   line-style-units line-style-thickness line-style-scale-lines line-style-joint-shape
   line-style-cap-shape line-style-dashed line-style-dash-pattern line-style-scale-dashes
   line-style-initial-dash-phase

   
   ;;;;;;;;;;;;;;;;
   ;; SILICA KERNEL
   ;;
   
   ;; porting 

   *default-host* *default-display-id* *default-screen-id* *default-port-type*
   *default-server-path* *server-path-defaults*
   port make-port find-port port-match
   port-name find-port-type
   reset-watcher register-watcher unregister-watcher

   destroy-port destroy-ports port-force-output port-finish-output
   restart-port restart-ports
   with-port do-with-port do-with-pointer
   *port* *ports* 
   port-prop port-cprop
    
   mirrored-sheet-mixin sheet-mirror mirror->sheet sheet-mirror!
   realize-mirror destroy-mirror enable-mirror disable-mirror
   sheet-target-native-edges*
   sheet-actual-native-edges* set-sheet-actual-native-edges*
   mirror-origin mirror-inside-region*
   update-mirror-region mirror-region-updated
   sheet-native-transformation update-native-transformation
   mirror-region mirror-region* 
   sheet-mirror-resource-id mirror-resource-id
    
   find-graft make-graft graft graftp realize-graft 
   graft-origin graft-units 
    
   graft-width-pixel graft-height-pixel graft-width-mm graft-height-mm
   graft-pixels-per-point
    
   to-graft-transformation-pixel to-graft-transformation-mm
    
   beep whistle ring-bell 
    
   cut-buffer 
   prompt-for-location prompt-for-region-location prompt-for-region

   install-settings install-mirror-settings

   ;; model
   model-sheet sheetp
   sheet-region sheet-enabled-p sheet-viewable-p

   contract sheet-contract relationship-contract 

   ;; Part Mechanism
   part sheet-part child-part parent-part windowing-part input-part
   contract-child-part contract-parent-part
   contract-name 

   ;; silica sheets
   sheet make-sheet define-sheet-class
   sheet-parents sheet-parent sheet-adam fetch-mirrored-sheet
   sheet-transformation sheet-children sheet-child sheet-siblings 
    
   sheet-parent-part sheet-child-part
   sheet-youth-contract sheet-adult-contract     
   sheet-adult-contract-class sheet-youth-contract-class
   sheet-output-contract-class sheet-input-contract-class
   sheet-output-contract sheet-input-contract
    
   sheet-enabled-children
   walk-tree walk-sheets count-sheets
   flush-sheet

   ;; windowing contract parts and mixins
   sheet-rectangle-mixin sheet-translation-mixin
   sheet-rectangle-translation-mixin
   enabled-slot-mixin permanently-enabled-mixin
   dtcr-mixin

   simple-parent-part simple-child-part
   standard-windowing-contract standard-child-part standard-parent-part
   define-windowing-contract

   ;; windowing contract protocols
   fetch-delta-transformation fetch-native-transformation
   fetch-clipping-region  fetch-native-clipping-region 
   child-at-point* which-descendant 
   occluding-sheets 
   children-in-region
   children-in-rectangle*
    
   ;; output handling
   output-contract standard-output-contract
   providing-output-contract mute-output-contract
   
   ;; Repaint Protocol
   repaint-sheet repaint-handler mute-repainter forwarding-repainter
   handle-repaint
   queue-repaint queue-repaint-mixin eager-queue-repaint-mixin
   repaint-region
   
   medium display-medium medium-sheet sheet-medium
   pixmap-medium make-pixmap-medium medium-pixmap 
   client-transformation client-clipping-region
   silica-transformation silica-clipping-region
   device-transformation device-clipping-region
   insured-device-transformation

   with-output-protection with-output-synchronization 
   display-medium-valid-p validate-medium 
   display-medium-invalidate
   using-display-medium using-clim-medium cleanup-display-medium


   ;; Standard Events
   
   event event-sheet event-key event-time
   device-event event-input-state event-x event-y 
   event-native-x event-native-y
   key-press-event key-release-event event-char
   button-press-event button-release-event event-button
   button-click-event click-hold-event button-click-click-event
   pointer-motion-event pointer-enter-event pointer-exit-event
   fill-event allocate-event free-event

   repaint-event
   
   +pointer-left+ +pointer-middle+ +pointer-right+
   +hyper-key+ +super-key+ +meta-key+ +control-key+ +shift-key+
   state-match-p
   
   ;; input handling
    
   process-next-event
   standard-event-distributor find-recipient 
   distribute-device-event
   dispatch-device-event dispatch-crossing-event
   propagate-events? handle-clicks?
   standard-cursor-support
   sheet-cursor
    
   standard-event-distributor-part
   distributor-keyboard-focus
   enable-keyboard-focus
   disable-keyboard-focus
    
   input-contract mute-input-contract
   invoking-input-contract

   standard-input-contract  
   sheet-event-queue
   event-queue make-event-queue with-event-queue
   standard-delivery get-next-event peek-event done-with-event

   poll-pointer query-sheet

   input-handler 
   queue-event queue-input
   key-press key-release button-press button-release
   button-click button-click-click
   pointer-motion pointer-enter pointer-exit

   terminal-stream-mixin terminal-stream
   open-terminal-stream close-terminal-stream

    
   ;; Kernel Protocol
   enact-contract repeal-contract change-contract 
   change-input-contract change-output-contract
   enable-sheet disable-sheet
   adopt-child disown-child adopt-children disown-children
   sheet-enabled sheet-disabled sheet-adopted sheet-disowned
   sheet-grafted sheet-ungrafted
   sheet-region-changed sheet-transformation-changed
    
   move-sheet* resize-sheet* move-and-resize-sheet*
   raise-sheet bury-sheet
    
   ))



