;;; -*- Mode: Lisp; Package: SILICA; Base: 10.; Syntax: Common-Lisp -*-
;;;
;;; Copyright (c) 1989, 1990 by Xerox Corporation.  All rights reserved. 
;;;

(in-package "SILICA")

;;;
;;; SILICA DEBUG
;;; 

(defun pretty-class-name-of (object)
  (string-capitalize (class-name (class-of object))))

;;;
;;; Printing Silica Objects
;;;

(defmethod print-object ((transformation identity-transformation) stream)
  (format stream "#<Identity-Transformation>"))

(defmethod print-object ((transformation translation) stream)
  (format stream "#<Translation: ~d ~d>" 
	  (translation-x transformation)
	  (translation-y transformation)))

(defmethod print-object ((transformation srt-transformation ) stream)
  (format stream "#<Xf:(~d ~d)(~d ~d)(~d ~d)>" 
	  (slot-value transformation 'm00) (slot-value transformation 'm01)
	  (slot-value transformation 'm10) (slot-value transformation 'm11)
	  (slot-value transformation 'm20) (slot-value transformation 'm21)))

(defmethod print-object ((transformation st-transformation ) stream)
  (format stream "#<Xf:(~d xx)(xx ~d)(~d ~d)>" 
	  (slot-value transformation 'm00) (slot-value transformation 'm11)
	  (slot-value transformation 'm20) (slot-value transformation 'm21)))

(defmethod print-object ((region region) stream)
  (print-unreadable-object (region stream :type t :identity t)
    ))

(defmethod print-object ((pos point) stream)
  (print-unreadable-object (pos stream :identity t)
    (if (eql (class-name (class-of pos)) 'standard-point)
	(write-string "Point" stream)
	(write-string (pretty-class-name-of pos) stream))
    (format stream " (~d,~d)" 
	    (point-x pos)
	    (point-y pos))))

(defmethod print-object ((region standard-rectangle) stream)
  (with-bounding-rectangle* (minx miny maxx maxy) region
    (print-unreadable-object (region stream :type nil :identity t)
      (format stream "~a (~d,~d) (~d,~d) ~dx~d"
	      #+Genera (class-name (class-of region))
	      #-Genera (pretty-class-name-of region)
	      minx miny maxx maxy 
	      (- maxx minx) (- maxy miny)))))

(defmethod print-object ((display-medium display-medium) stream)
  (print-unreadable-object (display-medium stream :type #+Genera T #-Genera nil :identity T)
    #-Genera (format stream "~a" (pretty-class-name-of display-medium))))

(defun describe-tree (sheet &optional (indent ""))
  (format t "~a~s: ~s
 ~a~s ~%" indent
 sheet (sheet-region sheet)
 indent (sheet-transformation sheet))
  (describe-tree (sheet-parent sheet) (concatenate 'string indent " ")))

(defmethod print-object ((sheet sheet) stream)
  (print-unreadable-object (sheet stream :type T :identity t)
			   ))
 

;;;
;;; Environment Support
;;;

#+allegro
(progn
  (tpl:alias "wres" () (restart-ports))
  (tpl:alias "wdes" () (destroy-ports)))

