;;; -*- Mode: Lisp; Package: SILICA; Base: 10.; Syntax: Common-Lisp -*-
;;;
;;; Copyright (c) 1989, 1990 by Xerox Corporation.  All rights reserved. 
;;;

(in-package "SILICA")

;;; Stuff for making on-the-spur-of-the-moment sheet classes.
;;; Not currently used by CLIM.

(defun get-sheet-class (base-class
			youth-contract-class
			adult-contract-class
			output-contract-class 
			input-contract-class 
			supers)

  (when (symbolp adult-contract-class)
    (setq adult-contract-class (find-class adult-contract-class)))
  (when (symbolp youth-contract-class)
    (setq youth-contract-class (find-class youth-contract-class)))
  (apply #'find-dynamic-class 
	 #'(lambda ()
	     (concatenate 'string
			  (contract-name 
			   (class-prototype youth-contract-class))
			  "--"
			  (if adult-contract-class 		 
			      (contract-name
			       (class-prototype adult-contract-class))
			      "none")))

	 base-class 
	 (find-class (contract-child-part
		      (class-prototype youth-contract-class)))
	 (if adult-contract-class 
	     (find-class 
	      (contract-parent-part (class-prototype adult-contract-class)))
	     (find-class 'mute-parent-part))
	 output-contract-class
	 input-contract-class
	 supers))