;;; -*- Mode: Lisp; Package: SILICA; Base: 10.; Syntax: Common-Lisp -*-
;;;
;;; Copyright (c) 1989, 1990 by Xerox Corporation.  All rights reserved. 
;;;

(in-package "SILICA")


;;;
;;; MEDIUM Drawing Options
;;;

(defclass medium-options ()
    ((foreground :accessor medium-foreground :initform +black+)
     (background :accessor medium-background :initform +white+)))


;;;
;;; CLG Basic Media
;;;

(defclass basic-clg-medium (medium medium-options)
    ())

(defclass basic-clg-display-medium (basic-clg-medium
				    display-medium)
    ())

(defclass basic-clg-pixmap-medium (basic-clg-medium 
				   pixmap-medium)
    ())

(defmethod graphics-package-key ((medium basic-clg-medium))
  :clim)

;;;
;;; WITH-SAVED-MEDIUM
;;;

(defmacro with-saved-medium (fields medium &body forms)
  (let* ((initialize-forms
	  (mapcan #'(lambda (field) 
		      (unless (symbolp field)
			`((setf (,(first field) ,medium) ,(second field)))))
		  fields))
	 (save-bindings
	  (mapcar #'(lambda (field) 
		      `(,(gentemp) (,(if (symbolp field)
					 field
					 (car field))
				    ,medium)))
		  fields))
	 (restore-forms
	  (mapcar #'(lambda (save-binding)
		      `(setf ,(second save-binding) ,(first save-binding)))

		  save-bindings)))
    `(let ,save-bindings
      (unwind-protect 
	   (progn 
	     ,@initialize-forms
	     ,@forms)
	,@restore-forms))))


;;;
;;; Use client view control to implement clipping and transformation
;;; for a display medium and use the device view control stuff for a pixmap
;;; medium.  These are using accessors to get at these fields, so that any
;;; before and after methods associated with the real names are also invoked
;;; properly.  If I had shadowed the slots and provided accessors of the
;;; desired names, then these methods would not be correctly inherited.
;;;

(defmethod medium-clipping-region ((medium basic-clg-display-medium))
  (client-clipping-region medium))

(defmethod (setf medium-clipping-region) (new (medium basic-clg-display-medium))
  (setf (client-clipping-region medium) new))

(defmethod medium-transformation ((medium basic-clg-display-medium))
  (client-transformation medium))

(defmethod (setf medium-transformation)
	   (new-value (medium basic-clg-display-medium))
  (setf (client-transformation medium) new-value))

(defmethod medium-clipping-region ((medium basic-clg-pixmap-medium))
  (device-clipping-region medium))

(defmethod (setf medium-clipping-region) 
	   (new-region (medium basic-clg-pixmap-medium))
  (setf (device-clipping-region medium) new-region))

(defmethod medium-transformation ((medium basic-clg-pixmap-medium))
  (insured-device-transformation medium))

(defmethod (setf medium-transformation) 
	   (new-value (medium basic-clg-pixmap-medium))
  (setf (device-transformation medium) new-value))

;;;
;;; Graphics Extras
;;;

(defun draw-text-rectangle (medium string rectangle &rest args)
  (declare (dynamic-extent args))
  (with-bounding-rectangle* (minx miny maxx maxy) rectangle
    (apply #'draw-text-rectangle* medium string minx miny maxx maxy args)))

(defun draw-text-rectangle* (medium
			     string min-x min-y max-x max-y
			     &rest args
			     &key align-x align-y &allow-other-keys)
  
  (declare (dynamic-extent args))
  (apply #'draw-text* medium string
	 (ecase align-x
	   (:left  min-x)
	   (:center (floor (+ min-x max-x) 2))
	   (:right max-x))
	 (ecase align-y
	   (:top    min-y)
	   (:center (floor (+ min-y max-y) 2))
	   (:bottom max-y))
	 args))