;;; -*- Mode: Lisp; Package: SILICA; Base: 10.; Syntax: Common-Lisp -*-
;;;
;;; Copyright (c) 1990 by Xerox Corporations.  All rights reserved.
;;;

(in-package "SILICA")

;;; rudimentary audio

(defun beep (&optional (stream *standard-output*))
  (cond ((sheetp stream)
	 (ring-bell (silica::port stream))
	 #+ignore
	 (window-beep stream))
	(t
	 #+Genera (scl:beep)
	 #+:coral (ccl::ed-beep)))
  nil)

(defun whistle (&key (direction ':down))
  #+Genera (compiler:inhibit-style-warnings (dbg:whistle :direction direction))
  #-(or Genera) (declare (ignore direction))
  #+:coral (dotimes (i 3) (beep)))



