;;; -*- Mode: Lisp; Package: SILICA; Base: 10.; Syntax: Common-Lisp -*-
;;;
;;;

"Copyright (c) 1991 by International Lisp Associates.  All Rights Reserved."

(in-package "SILICA")

(defclass printer-medium (medium)
  ((printer-stream :initarg :printer-stream :accessor printer-stream)
   (client-transformation :initform +identity-transformation+ :accessor client-transformation)
   (client-clipping-region :initform +everywhere+ :accessor client-clipping-region)
   (document-title :initarg :title :accessor printer-document-title :initform nil)))

(defmethod printer-document-title :before ((medium printer-medium))
  (with-slots (document-title) medium
    (unless document-title
      (let ((sheet (medium-sheet medium)))
	(when sheet
	  (setf document-title (printer-document-title sheet)))))))

(defmethod medium-force-output ((medium printer-medium))
  (force-output (slot-value medium 'printer-stream)))

(defmethod medium-finish-output ((medium printer-medium))
  (finish-output (slot-value medium 'printer-stream)))

(defmethod insured-device-transformation ((medium printer-medium))
  (device-transformation medium))

;;; The DISPLAY-MEDIUM version of this returns NIL if the clipping region is empty.
(defmethod validate-medium ((medium printer-medium))
  (not (eql (device-clipping-region medium) +nowhere+)))

;;; The DISPLAY-MEDIUM version of this always returns T.
(defmethod %validate-medium ((medium printer-medium))
  t)

;;; The default method of this doesn't do anything.
(defmethod show-page ((medium printer-medium))
  nil)
