;;; -*- Mode: Lisp; Package: SILICA; Base: 10.; Syntax: Common-Lisp -*-
;;;
;;; Copyright (c) 1989, 1990 by Xerox Corporation.  All rights reserved. 
;;;

(in-package "SILICA")

;;;
;;; PIXMAPS
;;;

(defclass pixmap ()
    ((width :initform nil :initarg :width :accessor pixmap-width)
     (height :initform nil :initarg :height :accessor pixmap-height)

     (format :initform :bitmap :initarg :format :accessor pixmap-format)
     (data  :initform nil :initarg :data :accessor pixmap-data)
     
     ;; Only used in multi-color cases
     ;; (depth :initform 1 :initarg :depth :accessor pixmap-depth)
     (color-count :initform 2 :initarg :color-count :accessor color-count
		  :reader pixmap-ncolors)
     (color-table :initform (list +white+ +black+)
		  :initarg :color-table 
		  :accessor color-table
		  :initarg :colors
		  :reader pixmap-colors)
     ;;
     (port-pixmaps :initform nil :accessor port-pixmaps)))

(defmethod pixmapp ((pixmap pixmap)) t)
(defmethod pixmapp ((pixmap t)) nil)

(defmethod print-object ((pixmap pixmap) stream)
  (format stream "#<pixmap: ~dx~d, ~d colors>"
	  (pixmap-width pixmap) (pixmap-height pixmap) (color-count pixmap)))

(defun make-pixmap (&rest args)
  (declare (dynamic-extent args))
  (apply #'make-instance 'pixmap args))

(defmethod initialize-instance :after 
	   ((pixmap pixmap) &key pixels file x-file &allow-other-keys)

  (when x-file
    ;; ??? Must figure out better way of handling this
    (assert (find-package "XLIB") ()
	    "CLX must be loaded to making this pixmap type.")
    (funcall
     (intern "READ-X-BITMAP-FILE" "ON-X")
     pixmap x-file
     #+ignore
     (merge-pathnames x-file *silica-pixmap-directory*)))
  
  (when file
    (setf (pixmap-format pixmap) :dws)
    (pixmap-internal-read-pixmap-from-file 
     pixmap file
     #+ignore (merge-pathnames file *silica-pixmap-directory*)))
  
  (when pixels
    (setf (pixmap-format pixmap) :dws)
    (setf (pixmap-data pixmap)
	  (cond ((arrayp pixels) pixels)
		((listp pixels)
		 (make-array (* (pixmap-width pixmap) (pixmap-height pixmap))
			     :element-type 'integer
			     :initial-contents pixels))
		(t (error "can't use ~s as pixels in a pixmap.~%"))))))
