;;; -*- Mode: Lisp; Package: ON-GENERA; Base: 10.; Syntax: Common-Lisp -*-
;;;

(in-package "ON-GENERA")

(defmacro defmethod-nyi (name port-name lambda-list)
  `(defmethod ,name ,lambda-list
     #+Genera (declare (sys:function-parent ,name defmethod-nyi))
     (progn ,@(with-collection (dolist (l lambda-list)
				 (unless (member l lambda-list-keywords)
				   (collect (if (listp l) (first l) l))))))
     (error "~S is not yet implemented for the ~:(~A~) port." ',name ',port-name)))

;;; --- for some reason using IGNORE here generates an error.  Naturally, we should
;;; --- fix DEFUN and rename this back.
(defun nyi (&rest foo)
  (declare (ignore foo)
	   (dynamic-extent foo))
  (error "Not yet implemented in the Genera port"))

(defmethod warp-cursor ((port genera-port) sheet x y)
  (let ((mirror (sheet-mirror! sheet)))
    (when mirror
      (multiple-value-setq (x y)
	(transform-point* (fetch-native-transformation sheet) x y))
      (tv:multiple-value-bind (ox oy)
	  (tv:sheet-calculate-offsets mirror (tv:sheet-screen mirror))
	(tv:mouse-warp (+ ox (integerize-coordinate x))
		       (+ oy (integerize-coordinate y)))))))

(define-unimplemented-protocol-method cut-buffer port ((port genera-port)))

(define-unimplemented-protocol-method (setf cut-buffer) port (new-contents (port genera-port)))

;;;
;;; Setting Installation
;;;
  
(defmethod install-mirror-settings 
	   ((port genera-port) (sheet mirrored-sheet-mixin)
	    &key 
	    (plain      nil plain-sp)
	    (save-under nil save-under-sp)
	    state region title
	    &allow-other-keys)
  
  plain plain-sp
  state region

  (let ((mirror (sheet-mirror sheet)))

    (when title
      (unless (stringp title) (setq title (string title)))
      (scl:send mirror :set-name title))

    (when save-under-sp
      (cond ((and save-under (typep mirror 'temporary-silica-window))
	     )
	    (save-under
	     ;; --- change the mirror to temporary!
	     )
	    ((typep mirror 'silica-window)
	     )
	    (t
	     ;; --- change the mirror to normal!
	     )))
    ))


