;;; -*- Mode: Lisp; Package: ON-GENERA; Base: 10.; Syntax: Common-Lisp -*-

"Genera port implementation Copyright (c) 1990 by International Lisp Associates, Inc.
 All rights reserved."

;;; Copy the keysym codes from CLX.
;;; The task of translating a keysym into a character is done at the port level.

(defvar *genera-character->keysym-table* (make-hash-table))
(defvar *keysym->genera-character-table* (make-hash-table))

(defmacro define-keysym (character keysym)
  `(progn (setf (gethash ,character *genera-character->keysym-table*) ',keysym)
	  (setf (gethash ,keysym *keysym->genera-character-table*) ',character)))

(defun-inline genera-character->keysym (character)
  ;; use CL:MAKE-CHAR here to strip bits from the character.
  (gethash (char-upcase (cl:make-char character)) *genera-character->keysym-table*))

(defun-inline keysym->genera-character (keysym)
  (gethash keysym *keysym->genera-character-table*))

(define-keysym #\Space :Space)
(define-keysym #\! :\!)
(define-keysym #\" :\")
(define-keysym #\# :\#)
(define-keysym #\$ :\$)
(define-keysym #\% :\%)
(define-keysym #\& :\&)
(define-keysym #\' :\')
(define-keysym #\( :\()
(define-keysym #\) :\))
(define-keysym #\* :\*)
(define-keysym #\+ :\+)
(define-keysym #\, :\,)
(define-keysym #\- :\-)
(define-keysym #\. :\.)
(define-keysym #\/ :\/)
(define-keysym #\0 :\0)
(define-keysym #\1 :\1)
(define-keysym #\2 :\2)
(define-keysym #\3 :\3)
(define-keysym #\4 :\4)
(define-keysym #\5 :\5)
(define-keysym #\6 :\6)
(define-keysym #\7 :\7)
(define-keysym #\8 :\8)
(define-keysym #\9 :\9)
(define-keysym #\: :\:)
(define-keysym #\; :\;)
(define-keysym #\< :\<)
(define-keysym #\= :\=)
(define-keysym #\> :\>)
(define-keysym #\? :\?)
(define-keysym #\@ :\@)
(define-keysym #\A :\A)
(define-keysym #\B :\B)
(define-keysym #\C :\C)
(define-keysym #\D :\D)
(define-keysym #\E :\E)
(define-keysym #\F :\F)
(define-keysym #\G :\G)
(define-keysym #\H :\H)
(define-keysym #\I :\I)
(define-keysym #\J :\J)
(define-keysym #\K :\K)
(define-keysym #\L :\L)
(define-keysym #\M :\M)
(define-keysym #\N :\N)
(define-keysym #\O :\O)
(define-keysym #\P :\P)
(define-keysym #\Q :\Q)
(define-keysym #\R :\R)
(define-keysym #\S :\S)
(define-keysym #\T :\T)
(define-keysym #\U :\U)
(define-keysym #\V :\V)
(define-keysym #\W :\W)
(define-keysym #\X :\X)
(define-keysym #\Y :\Y)
(define-keysym #\Z :\Z)
(define-keysym #\[ :\[)
(define-keysym #\\ :\\)
(define-keysym #\] :\])
(define-keysym #\^ :\^)
(define-keysym #\_ :\_)
(define-keysym #\` :\`)
(define-keysym #\{ :\{)
(define-keysym #\| :\|)
(define-keysym #\} :\})
(define-keysym #\~ :\~)

(define-keysym #\Rubout :Rubout)
(define-keysym #\Tab :Tab)
(define-keysym #\Line :Linefeed)
(define-keysym #\Page :Page)
(define-keysym #\Return :Return)
(define-keysym #\Backspace :Backspace)

(define-keysym #\Clear-Input :clear-input)
(define-keysym #\Help :Help)
(define-keysym #\Refresh :Refresh)
(define-keysym #\Abort :Abort)
(define-keysym #\End :End)
(define-keysym #\Scroll :Scroll)
(define-keysym #\Complete :Complete)
