;;; -*- Mode: LISP; Syntax: Common-lisp; Package: ON-LV; Base: 10 -*-

(in-package :on-lv)

"Copyright (c) 1991 International Lisp Associates, Inc."

;;; For better or worse, our current sliders don't have any labels.  We
;;; should probably add some notion of label to the WS::SLIDER class, though.
(defclass lispview-slider (component-pane ws::slider)
  ((thickness :initform 19))
  )

(defmethod component-pane-lispview-class ((ls lispview-slider))
  (ecase (ws::slider-orientation ls)
    (:horizontal 'lv::horizontal-slider)
    (:vertical 'lv::vertical-slider)))

;;; Initialize the min, max, orientation, etc.
(defmethod component-pane-resources ((ls lispview-slider))
  (with-slots (thickness ws::show-value-p) ls
    (list ':min-value 0 ':max-value 100
	  ;; Arrrgh.  We can't call gaget-value 'cause it
	  ;; attempts to call through to the Motif widget.
	  ':value (slot-value ls 'ws::value) #+ignore (ws::gadget-value ls)
	  ':show-value ws::show-value-p
	  ':update-value #'(lambda (new-value)
			     (ws::value-change-callback 
			       ls
			       (ws::gadget-client ls)
			       (ws::gadget-id ls)
			       (/ new-value 100))))))

;;; Here are the hooks to changing the min, max, orientation, etc.
(defmethod (setf ws::slider-min-value) :after (new-value (ls lispview-slider))
  (setf (lv:min-value (sheet-mirror ls)) new-value))

(defmethod (setf ws::slider-max-value) :after (new-value (ls lispview-slider))
  (setf (lv:max-value (sheet-mirror ls)) new-value))

(defmethod (setf ws::slider-orientation) :after (new-value (ls lispview-slider))
  (check-type new-value (member :horizontal :vertical))
  (error "Can't change the orientation of a Lispview slider once it has been created"))

(defmethod (setf ws::slider-show-value-p) :after (new-value (ls lispview-slider))
  (setf (lv:show-value (sheet-mirror ls)) new-value))

(defmethod ws::set-gadget-value :after ((ls lispview-slider) new-value &key call-callbacks)
  (declare (ignore call-callbacks))
  ;; --- kludge, until we figure out how to map an arbitrary
  ;; --- user-supplied range into a nice integer-only range
  ;; --- assume min is 0 and max is 1 on the lisp side, while
  ;; --- the range is 0 to 100 on the widget side.
  (setq new-value (round (* new-value 100)))
  (setf (lv:value (sheet-mirror ls)) new-value))

(defmethod ws::compose-space ((sl lispview-slider))
  (let* ((component (sheet-mirror sl))
	 (region (lv:bounding-region component))
	 (thickness (slot-value sl 'thickness)))
    (ecase (ws::slider-orientation sl)
      (:vertical
       (ws::make-space-req :hs thickness :hs+ 0 :hs- 0
			   :vs (lv:region-height region) :vs+ +fill+ :vs- +fill+))
      (:horizontal
       (ws::make-space-req :vs thickness :vs+ 0 :vs- 0
			   :hs (lv:region-width region) :hs+ +fill+ :hs- +fill+)))))

;;; Setting the region of a Lispview slider doesn't change the slider bar
;;; size, so we need custom code.
(defmethod set-sheet-actual-native-edges* ((port lispview-port) 
					   (sl lispview-slider)
					   x1 y1 x2 y2)
  (let* ((component (sheet-mirror sl))
	 (x1 (round x1))
	 (y1 (round y1))
	 (x2 (round x2))
	 (y2 (round y2)))
    (setf (lv:bounding-region component)
	  (lv:make-region :left x1 :top y1 :right x2 :bottom y2))
    (case (ws::slider-orientation sl)
      (:horizontal
       (let* ((width (- x2 x1))
	      ;; The bar should be 16 pixels shorter than the whole gadget
	      ;; if no textual value is being shown; 60 pixels if it is.
	      (bar-size (if (lv:show-value component)
			    (- width 60)
			    (- width 16))))
	 (setf (lv:gauge-length component) bar-size))))
    ))

#+ignore
(defmethod ws::compose-space ((ls lispview-slider))
  (let* ((port (port ls))
	 (size-info (with-clm-bindings (port)
		      (xtk::get-values (sheet-mirror ls)
				       :width :height)))
	 (orient (ws::slider-orientation ls))
	 (thickness (or ;; --- how to account for the "label" in show-value-p t?
		     ;; --- this query seems to return "10" whether there
		     ;; is a label or not...
		     #+ignore
		     (and (sheet-mirror ls)
			  (first (get-widget-values 
				  ls 
				  (ecase orient
				    (:horizontal ':height)
				    (:vertical   ':width)))))
		     ;; so just use the value from the CLOS object
		     (slot-value ls 'thickness))))
    ;; --- kludge attempt to allow the value-showing lable to be visible
    (when (slot-value ls 'ws::show-value-p)
      (incf thickness 15))
    (ecase (ws::slider-orientation ls)
      (:vertical
       (ws::make-space-req :hs thickness :hs+ 0 :hs- 0
			   :vs (second size-info) :vs+ +fill+ :vs- +fill+))
      (:horizontal
       (ws::make-space-req :vs thickness :vs+ 0 :vs- 0
			   :hs (first size-info) :hs+ +fill+ :hs- +fill+)))))
